/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.openapi.impl.parser.processors;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.microprofile.openapi.impl.parser.ResolverCache;
import com.ibm.ws.microprofile.openapi.impl.parser.models.RefFormat;
import com.ibm.ws.microprofile.openapi.impl.parser.processors.ExternalRefProcessor;
import com.ibm.ws.microprofile.openapi.impl.parser.processors.HeaderProcessor;
import com.ibm.ws.microprofile.openapi.impl.parser.processors.LinkProcessor;
import com.ibm.ws.microprofile.openapi.impl.parser.processors.SchemaProcessor;
import com.ibm.ws.microprofile.openapi.impl.parser.util.RefUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Map;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.headers.Header;
import org.eclipse.microprofile.openapi.models.links.Link;
import org.eclipse.microprofile.openapi.models.media.Content;
import org.eclipse.microprofile.openapi.models.media.MediaType;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.responses.APIResponse;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ResponseProcessor {
    private final SchemaProcessor schemaProcessor;
    private final HeaderProcessor headerProcessor;
    private final LinkProcessor linkProcessor;
    private final ExternalRefProcessor externalRefProcessor;
    private final ResolverCache cache;
    private final OpenAPI openAPI;
    static final long serialVersionUID = 7907637787955321034L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public ResponseProcessor(ResolverCache cache, OpenAPI openAPI) {
        this.schemaProcessor = new SchemaProcessor(cache, openAPI);
        this.headerProcessor = new HeaderProcessor(cache, openAPI);
        this.linkProcessor = new LinkProcessor(cache, openAPI);
        this.externalRefProcessor = new ExternalRefProcessor(cache, openAPI);
        this.cache = cache;
        this.openAPI = openAPI;
    }

    public void processResponse(APIResponse response) {
        if (response.getRef() != null) {
            this.processReferenceResponse(response);
        }
        Schema schema = null;
        if (response.getContent() != null) {
            Content content = response.getContent();
            for (String mediaName : content.keySet()) {
                MediaType mediaType = (MediaType)content.get(mediaName);
                if (mediaType.getSchema() == null || (schema = mediaType.getSchema()) == null) continue;
                this.schemaProcessor.processSchema(schema);
            }
        }
        if (response.getHeaders() != null) {
            Map headers = response.getHeaders();
            for (String headerName : headers.keySet()) {
                Header header = (Header)headers.get(headerName);
                this.headerProcessor.processHeader(header);
            }
        }
        if (response.getLinks() != null) {
            Map links = response.getLinks();
            for (String linkName : links.keySet()) {
                Link link = (Link)links.get(linkName);
                this.linkProcessor.processLink(link);
            }
        }
    }

    public void processReferenceResponse(APIResponse response) {
        String newRef;
        RefFormat refFormat = RefUtils.computeRefFormat(response.getRef());
        String $ref = response.getRef();
        if (RefUtils.isAnExternalRefFormat(refFormat) && (newRef = this.externalRefProcessor.processRefToExternalResponse($ref, refFormat)) != null) {
            response.setRef(newRef);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ResponseProcessor.class);
    }
}

