/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.openapi.impl.parser.processors;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.microprofile.openapi.impl.parser.ResolverCache;
import com.ibm.ws.microprofile.openapi.impl.parser.models.RefFormat;
import com.ibm.ws.microprofile.openapi.impl.parser.processors.ExternalRefProcessor;
import com.ibm.ws.microprofile.openapi.impl.parser.processors.HeaderProcessor;
import com.ibm.ws.microprofile.openapi.impl.parser.util.RefUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.links.Link;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class LinkProcessor {
    private final ResolverCache cache;
    private final OpenAPI openAPI;
    private final HeaderProcessor headerProcessor;
    private final ExternalRefProcessor externalRefProcessor;
    static final long serialVersionUID = 3029374798314158411L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public LinkProcessor(ResolverCache cache, OpenAPI openAPI) {
        this.cache = cache;
        this.openAPI = openAPI;
        this.headerProcessor = new HeaderProcessor(cache, openAPI);
        this.externalRefProcessor = new ExternalRefProcessor(cache, openAPI);
    }

    public void processLink(Link link) {
        if (link.getRef() != null) {
            String newRef;
            RefFormat refFormat = RefUtils.computeRefFormat(link.getRef());
            String $ref = link.getRef();
            if (RefUtils.isAnExternalRefFormat(refFormat) && (newRef = this.externalRefProcessor.processRefToExternalLink($ref, refFormat)) != null) {
                link.setRef(newRef);
            }
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(LinkProcessor.class);
    }
}

