/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.javaeesec.identitystore;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.javaeesec.CDIHelper;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.stream.Stream;
import javax.el.ELException;
import javax.security.enterprise.identitystore.IdentityStore;
import javax.security.enterprise.identitystore.LdapIdentityStoreDefinition;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
class ELHelper {
    private static final String OBFUSCATED_STRING = "******";
    private static final TraceComponent tc = Tr.register(ELHelper.class);
    static final long serialVersionUID = -7946399093838466489L;

    ELHelper() {
    }

    @Trivial
    protected Object evaluateElExpression(String expression) {
        return this.evaluateElExpression(expression, false);
    }

    @Trivial
    @ManualTrace
    protected Object evaluateElExpression(String expression, boolean mask) {
        String methodName = "evaluateElExpression";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"evaluateElExpression", (Object[])new Object[]{expression == null ? null : (mask ? OBFUSCATED_STRING : expression), mask});
        }
        EvalPrivilegedAction evalPrivilegedAction = new EvalPrivilegedAction(expression, mask);
        Object result = AccessController.doPrivileged(evalPrivilegedAction);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"evaluateElExpression", result == null ? null : (mask ? OBFUSCATED_STRING : result));
        }
        return result;
    }

    @Trivial
    static boolean isImmediateExpression(String expression) {
        return ELHelper.isImmediateExpression(expression, false);
    }

    @Trivial
    @ManualTrace
    static boolean isImmediateExpression(String expression, boolean mask) {
        boolean result;
        String methodName = "isImmediateExpression";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isImmediateExpression", (Object[])new Object[]{expression == null ? null : (mask ? OBFUSCATED_STRING : expression), mask});
        }
        boolean bl = result = expression.startsWith("${") && expression.endsWith("}");
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isImmediateExpression", (Object)result);
        }
        return result;
    }

    protected Integer processInt(String name, String expression, int value, boolean immediateOnly) {
        Integer result = null;
        boolean immediate = false;
        if (expression.isEmpty()) {
            result = value;
        } else {
            Object obj = this.evaluateElExpression(expression);
            if (obj == null) {
                throw new IllegalArgumentException("EL expression '" + expression + "' for '" + name + "'evaluated to null.");
            }
            if (obj instanceof Number) {
                result = ((Number)obj).intValue();
                immediate = ELHelper.isImmediateExpression(expression);
            } else {
                throw new IllegalArgumentException("Expected '" + name + "' to evaluate to an integer value.");
            }
        }
        return immediateOnly && !immediate ? null : result;
    }

    protected LdapIdentityStoreDefinition.LdapSearchScope processLdapSearchScope(String name, String expression, LdapIdentityStoreDefinition.LdapSearchScope value, boolean immediateOnly) {
        LdapIdentityStoreDefinition.LdapSearchScope result;
        boolean immediate = false;
        if (expression.isEmpty()) {
            result = value;
        } else {
            Object obj = this.evaluateElExpression(expression);
            if (obj instanceof LdapIdentityStoreDefinition.LdapSearchScope) {
                result = (LdapIdentityStoreDefinition.LdapSearchScope)obj;
                immediate = ELHelper.isImmediateExpression(expression);
            } else if (obj instanceof String) {
                result = LdapIdentityStoreDefinition.LdapSearchScope.valueOf((String)((String)obj).toUpperCase());
                immediate = ELHelper.isImmediateExpression(expression);
            } else {
                throw new IllegalArgumentException("Expected '" + name + "' to evaluate to an LdapSearchScope type.");
            }
        }
        return immediateOnly && !immediate ? null : result;
    }

    @Trivial
    protected String processString(String name, String expression, boolean immediateOnly) {
        return this.processString(name, expression, immediateOnly, false);
    }

    @Trivial
    @ManualTrace
    @FFDCIgnore(value={ELException.class})
    protected String processString(String name, String expression, boolean immediateOnly, boolean mask) {
        String finalResult;
        String result;
        String methodName = "processString";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"processString", (Object[])new Object[]{name, expression == null ? null : (mask ? OBFUSCATED_STRING : expression), immediateOnly, mask});
        }
        boolean immediate = false;
        try {
            Object obj = this.evaluateElExpression(expression, mask);
            if (obj == null) {
                throw new IllegalArgumentException("EL expression '" + (mask ? OBFUSCATED_STRING : expression) + "' for '" + name + "'evaluated to null.");
            }
            if (!(obj instanceof String)) {
                throw new IllegalArgumentException("Expected '" + name + "' to evaluate to a String value.");
            }
            result = (String)obj;
            immediate = ELHelper.isImmediateExpression(expression, mask);
        }
        catch (ELException e) {
            result = expression;
            immediate = true;
        }
        String string = finalResult = immediateOnly && !immediate ? null : result;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"processString", finalResult == null ? null : (mask ? OBFUSCATED_STRING : finalResult));
        }
        return finalResult;
    }

    @Trivial
    @ManualTrace
    @FFDCIgnore(value={ELException.class})
    protected String[] processStringArray(String name, String expression, boolean immediateOnly, boolean mask) {
        String[] finalResult;
        String[] result;
        String methodName = "processStringArray";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"processStringArray", (Object[])new Object[]{name, expression == null ? null : (mask ? OBFUSCATED_STRING : expression), immediateOnly, mask});
        }
        boolean immediate = false;
        try {
            Object obj = this.evaluateElExpression(expression, mask);
            if (obj == null) {
                throw new IllegalArgumentException("EL expression '" + (mask ? OBFUSCATED_STRING : expression) + "' for '" + name + "'evaluated to null.");
            }
            if (!(obj instanceof String[])) {
                throw new IllegalArgumentException("Expected '" + name + "' to evaluate to a String value.");
            }
            result = (String[])obj;
            immediate = ELHelper.isImmediateExpression(expression, mask);
        }
        catch (ELException e) {
            throw new IllegalArgumentException("Expected '" + name + "' to evaluate to a String[] value.");
        }
        Object object = finalResult = immediateOnly && !immediate ? null : result;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"processStringArray", finalResult == null ? null : (mask ? "******" : finalResult));
        }
        return finalResult;
    }

    @Trivial
    @ManualTrace
    @FFDCIgnore(value={ELException.class})
    protected Stream<String> processStringStream(String name, String expression, boolean immediateOnly, boolean mask) {
        Stream finalResult;
        Stream result;
        String methodName = "processStringStream";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"processStringStream", (Object[])new Object[]{name, expression == null ? null : (mask ? OBFUSCATED_STRING : expression), immediateOnly, mask});
        }
        boolean immediate = false;
        try {
            Object obj = this.evaluateElExpression(expression, mask);
            if (obj == null) {
                throw new IllegalArgumentException("EL expression '" + (mask ? OBFUSCATED_STRING : expression) + "' for '" + name + "'evaluated to null.");
            }
            if (!(obj instanceof Stream)) {
                throw new IllegalArgumentException("Expected '" + name + "' to evaluate to a Stream<String> value.");
            }
            result = (Stream)obj;
            immediate = ELHelper.isImmediateExpression(expression, mask);
        }
        catch (ELException e) {
            throw new IllegalArgumentException("Expected '" + name + "' to evaluate to a Stream<String> value.");
        }
        Stream stream = finalResult = immediateOnly && !immediate ? null : result;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"processStringStream", finalResult == null ? null : (mask ? OBFUSCATED_STRING : finalResult));
        }
        return finalResult;
    }

    protected Set<IdentityStore.ValidationType> processUseFor(String useForExpression, IdentityStore.ValidationType[] useFor, boolean immediateOnly) {
        EnumSet<IdentityStore.ValidationType> result = null;
        boolean immediate = false;
        if (useForExpression.isEmpty()) {
            result = EnumSet.copyOf(Arrays.asList(useFor));
        } else {
            IdentityStore.ValidationType[] types;
            Object obj = this.evaluateElExpression(useForExpression);
            if (obj instanceof IdentityStore.ValidationType[]) {
                Tr.debug((TraceComponent)tc, (String)("processUseFor (validationtype): " + obj), (Object[])new Object[0]);
                types = (IdentityStore.ValidationType[])obj;
                result = EnumSet.copyOf(Arrays.asList(types));
                immediate = ELHelper.isImmediateExpression(useForExpression);
            } else if (obj instanceof String) {
                Tr.debug((TraceComponent)tc, (String)("processUseFor (String): " + (String)obj), (Object[])new Object[0]);
                types = new IdentityStore.ValidationType[2];
                String validation = ((String)obj).toLowerCase();
                if (validation.contains("validate")) {
                    types[0] = IdentityStore.ValidationType.VALIDATE;
                }
                if (validation.contains("provide_groups")) {
                    types[1] = IdentityStore.ValidationType.PROVIDE_GROUPS;
                }
                result = EnumSet.copyOf(Arrays.asList(types));
                immediate = ELHelper.isImmediateExpression(useForExpression);
            } else {
                Tr.debug((TraceComponent)tc, (String)"processUseFor obj was not an instance of string or ValidationType[]", (Object[])new Object[0]);
                throw new IllegalArgumentException("Expected 'useForExpression' to evaluate to an array of ValidationType.");
            }
        }
        if (result == null || result.isEmpty()) {
            Tr.debug((TraceComponent)tc, (String)"processUseFor result is empty or null", (Object[])new Object[0]);
            throw new IllegalArgumentException("The identity store must be configured with at least one ValidationType.");
        }
        for (IdentityStore.ValidationType v : result) {
            Tr.debug((TraceComponent)tc, (String)("processUseFor result: " + v), (Object[])new Object[0]);
        }
        return immediateOnly && !immediate ? null : Collections.unmodifiableSet(result);
    }

    @Trivial
    static String removeBrackets(String expression) {
        return ELHelper.removeBrackets(expression, false);
    }

    @Trivial
    @ManualTrace
    static String removeBrackets(String expression, boolean mask) {
        String methodName = "removeBrackets";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeBrackets", (Object[])new Object[]{expression == null ? null : (mask ? OBFUSCATED_STRING : expression), mask});
        }
        if (((expression = expression.trim()).startsWith("${") || expression.startsWith("#{")) && expression.endsWith("}")) {
            expression = expression.substring(2, expression.length() - 1);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeBrackets", expression == null ? null : (mask ? OBFUSCATED_STRING : expression));
        }
        return expression;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    class EvalPrivilegedAction
    implements PrivilegedAction<Object> {
        private final String expression;
        private final boolean mask;
        static final long serialVersionUID = 5380949017343508182L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Trivial
        public EvalPrivilegedAction(String expression, boolean mask) {
            this.expression = expression;
            this.mask = mask;
        }

        @Override
        @Trivial
        public Object run() {
            return CDIHelper.getELProcessor().eval(ELHelper.removeBrackets(this.expression, this.mask));
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(EvalPrivilegedAction.class);
        }
    }
}

