/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl.store.filters;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.msgstore.AbstractItem;
import com.ibm.ws.sib.msgstore.Filter;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcherState;
import com.ibm.ws.sib.processor.impl.store.itemstreams.DurableSubscriptionItemStream;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.ras.SibTr;

public final class SubscriptionStateFilter
implements Filter {
    private static final TraceComponent tc = SibTr.register(SubscriptionStateFilter.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private String _subscriptionId = null;
    private ConsumerDispatcherState _consumerDispatcherState = null;
    private SIBUuid12 _destination = null;

    public void setSubscriptionIDFilter(String subscriptionId) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setSubscriptionIDFilter", (Object)subscriptionId);
        }
        this._subscriptionId = subscriptionId;
        this._destination = null;
        this._consumerDispatcherState = null;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setSubscriptionIDFilter");
        }
    }

    public void setDestinationFilter(SIBUuid12 destination) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setDestinationFilter", (Object)destination);
        }
        this._destination = destination;
        this._subscriptionId = null;
        this._consumerDispatcherState = null;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setDestinationFilter");
        }
    }

    public void setConsumerDispatcherStateFilter(ConsumerDispatcherState consumerDispatcherState) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setConsumerDispatcherStateFilter", (Object)consumerDispatcherState);
        }
        this._consumerDispatcherState = consumerDispatcherState;
        this._subscriptionId = null;
        this._destination = null;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setConsumerDispatcherStateFilter");
        }
    }

    public boolean filterMatches(AbstractItem item) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"filterMatches", (Object)item);
        }
        ConsumerDispatcherState subState = null;
        if (item instanceof DurableSubscriptionItemStream) {
            try {
                subState = ((DurableSubscriptionItemStream)item).getConsumerDispatcherState();
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.store.filters.SubscriptionStateFilter.filterMatches", (String)"1:180:1.33.1.1", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)e);
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"filterMatches", (Object)e);
                }
                return false;
            }
            if (this._subscriptionId != null) {
                boolean retval = subState.getSubscriberID().equals(this._subscriptionId);
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"filterMatches", (Object)retval);
                }
                return retval;
            }
            if (this._destination != null) {
                boolean retval = subState.getTopicSpaceUuid().equals((Object)this._destination);
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"filterMatches", (Object)retval);
                }
                return retval;
            }
            if (this._consumerDispatcherState != null) {
                boolean retval;
                boolean bl = retval = subState == this._consumerDispatcherState;
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"filterMatches", (Object)retval);
                }
                return retval;
            }
            if (this._destination == null && this._subscriptionId == null && this._consumerDispatcherState == null) {
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"filterMatches", (Object)Boolean.TRUE);
                }
                return true;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"filterMatches", (Object)Boolean.FALSE);
        }
        return false;
    }
}

