/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.admin.internal;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.SIDestinationAddressFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.messaging.service.JsMainAdminServiceImpl;
import com.ibm.ws.sib.admin.JsAdminService;
import com.ibm.ws.sib.admin.JsMainAdminService;
import com.ibm.ws.sib.admin.internal.JsAdminConstants;
import com.ibm.ws.sib.common.service.CommonServiceFacade;
import com.ibm.ws.sib.msgstore.MessageStore;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.sib.core.SelectionCriteriaFactory;
import java.util.Map;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.cm.ConfigurationListener;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.ibm.ws.messaging.runtime"}, configurationPolicy=ConfigurationPolicy.REQUIRE, immediate=true, property={"service.vendor=IBM"})
public class JsMainAdminComponentImpl
implements ConfigurationListener {
    private static final String KEY_JS_ADMIN_SERVICE = "jsAdminService";
    private static final String KEY_DESTINATION_ADDRESS_FACTORY = "destinationAddressFactory";
    private static final String KEY_MESSAGE_STORE = "messageStore";
    private static final String KEY_CONFIG_ADMIN = "configAdmin";
    private static final TraceComponent tc = SibTr.register(JsMainAdminComponentImpl.class, (String)"SIBAdmin", (String)"com.ibm.ws.sib.admin.internal.CWSIDMessages");
    private static final String CLASS_NAME = "com.ibm.ws.sib.admin.internal.JsMainAdminComponentImpl";
    private JsMainAdminService service;
    public static final AtomicServiceReference<ConfigurationAdmin> configAdminRef = new AtomicServiceReference("configAdmin");
    public static final AtomicServiceReference<MessageStore> messageStoreRef = new AtomicServiceReference("messageStore");
    public static final AtomicServiceReference<SIDestinationAddressFactory> destinationAddressFactoryRef = new AtomicServiceReference("destinationAddressFactory");
    public static final AtomicServiceReference<JsAdminService> jsAdminServiceref = new AtomicServiceReference("jsAdminService");

    @Activate
    protected void activate(ComponentContext context, Map<String, Object> properties) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.sib.admin.internal.JsMainAdminComponentImplactivate", (Object)new Object[]{context, properties});
        }
        try {
            this.service = new JsMainAdminServiceImpl();
            configAdminRef.activate(context);
            messageStoreRef.activate(context);
            destinationAddressFactoryRef.activate(context);
            jsAdminServiceref.activate(context);
            this.service.activate(context, properties, (ConfigurationAdmin)configAdminRef.getService());
        }
        catch (Exception e) {
            SibTr.exception((TraceComponent)tc, (Exception)e);
            FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"133", (Object)this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.sib.admin.internal.JsMainAdminComponentImplactivate");
        }
    }

    @Modified
    protected void modified(ComponentContext context, Map<String, Object> properties) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.sib.admin.internal.JsMainAdminComponentImplmodified", (Object)new Object[]{context, properties});
        }
        try {
            if (this.service.getMeState().equals(JsAdminConstants.ME_STATE.STOPPED.toString())) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Starting ME", (Object)this.service.getMeState());
                }
                SibTr.info((TraceComponent)tc, (String)"RESTART_ME_SIAS0106");
                this.service.activate(context, properties, (ConfigurationAdmin)configAdminRef.getService());
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Modifying the configuration", (Object)this.service.getMeState());
                }
                this.service.modified(context, properties, (ConfigurationAdmin)configAdminRef.getService());
            }
        }
        catch (Exception e) {
            SibTr.exception((TraceComponent)tc, (Exception)e);
            FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"187", (Object)this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.sib.admin.internal.JsMainAdminComponentImplmodified");
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext context, Map<String, Object> properties) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.sib.admin.internal.JsMainAdminComponentImpldeactivate", (Object)new Object[]{context, properties});
        }
        try {
            this.service.deactivate(context, properties);
            this.service = null;
            configAdminRef.deactivate(context);
            messageStoreRef.deactivate(context);
            destinationAddressFactoryRef.deactivate(context);
            jsAdminServiceref.deactivate(context);
        }
        catch (Exception e) {
            SibTr.exception((TraceComponent)tc, (Exception)e);
            FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"227", (Object)this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.sib.admin.internal.JsMainAdminComponentImpldeactivate");
        }
    }

    @Reference(name="configAdmin", service=ConfigurationAdmin.class)
    protected void setConfigAdmin(ServiceReference<ConfigurationAdmin> ref) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setConfigAdmin", ref);
        }
        configAdminRef.setReference(ref);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setConfigAdmin");
        }
    }

    protected void unsetConfigAdmin(ServiceReference<ConfigurationAdmin> ref) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"unsetConfigAdmin", ref);
        }
        configAdminRef.unsetReference(ref);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"unsetConfigAdmin");
        }
    }

    @Reference(name="messageStore", service=MessageStore.class)
    protected void setMessageStore(ServiceReference<MessageStore> ref) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setMessageStore", ref);
        }
        messageStoreRef.setReference(ref);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setMessageStore");
        }
    }

    protected void unsetMessageStore(ServiceReference<MessageStore> ref) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"unsetMessageStore", ref);
        }
        messageStoreRef.unsetReference(ref);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"unsetMessageStore");
        }
    }

    @Reference(name="destinationAddressFactory", service=SIDestinationAddressFactory.class)
    protected void setDestinationAddressFactory(ServiceReference<SIDestinationAddressFactory> ref) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setDestinationAddressFactory", ref);
        }
        destinationAddressFactoryRef.setReference(ref);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setDestinationAddressFactory");
        }
    }

    protected void unsetDestinationAddressFactory(ServiceReference<SIDestinationAddressFactory> ref) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"unsetDestinationAddressFactory", ref);
        }
        destinationAddressFactoryRef.setReference(ref);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"unsetDestinationAddressFactory");
        }
    }

    @Reference(name="jsAdminService", service=JsAdminService.class)
    protected void setJsAdminService(ServiceReference<JsAdminService> ref) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setJsAdminService", ref);
        }
        jsAdminServiceref.setReference(ref);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setJsAdminService");
        }
    }

    protected void unsetJsAdminService(ServiceReference<JsAdminService> ref) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"unsetJsAdminService", ref);
        }
        jsAdminServiceref.setReference(ref);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"unsetJsAdminService");
        }
    }

    public static SIDestinationAddressFactory getSIDestinationAddressFactory() {
        return (SIDestinationAddressFactory)destinationAddressFactoryRef.getService();
    }

    public static SelectionCriteriaFactory getSelectionCriteriaFactory() {
        return CommonServiceFacade.getSelectionCriteriaFactory();
    }

    public static JsAdminService getJsAdminService() {
        return (JsAdminService)jsAdminServiceref.getService();
    }

    public void configurationEvent(ConfigurationEvent event) {
        this.service.configurationEvent(event, (ConfigurationAdmin)configAdminRef.getService());
    }
}

