/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.container.service.app.deploy.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.container.service.app.deploy.ContainerInfo;
import com.ibm.ws.container.service.app.deploy.ManifestClassPathUtils;
import com.ibm.ws.container.service.app.deploy.WebModuleClassesInfo;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.Entry;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.adaptable.module.adapters.ContainerAdapter;
import com.ibm.wsspi.artifact.ArtifactContainer;
import com.ibm.wsspi.artifact.overlay.OverlayContainer;
import java.util.ArrayList;
import java.util.List;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class WebModuleClassesInfoAdapter
implements ContainerAdapter<WebModuleClassesInfo> {
    private static final TraceComponent tc = Tr.register(WebModuleClassesInfoAdapter.class);
    static final long serialVersionUID = -5248018802681891119L;

    public WebModuleClassesInfo adapt(Container root, OverlayContainer rootOverlay, ArtifactContainer artifactContainer, Container containerToAdapt) throws UnableToAdaptException {
        Container libContainer;
        Entry libEntry;
        Container classesContainer;
        Entry classesEntry;
        WebModuleClassesInfo classesInfo = (WebModuleClassesInfo)rootOverlay.getFromNonPersistentCache(artifactContainer.getPath(), WebModuleClassesInfo.class);
        if (classesInfo != null) {
            return classesInfo;
        }
        ArrayList<String> resolved = new ArrayList<String>();
        final ArrayList<ContainerInfo> containerInfos = new ArrayList<ContainerInfo>();
        Entry moduleEntry = (Entry)containerToAdapt.adapt(Entry.class);
        if (moduleEntry != null && !moduleEntry.getPath().isEmpty()) {
            ManifestClassPathUtils.processMFClasspath(moduleEntry, containerInfos, resolved, true);
        }
        if ((classesEntry = containerToAdapt.getEntry("WEB-INF/classes")) != null && (classesContainer = (Container)classesEntry.adapt(Container.class)) != null) {
            ContainerInfo containerInfo = new ContainerInfo(){
                static final long serialVersionUID = -5558293505554148474L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public ContainerInfo.Type getType() {
                    return ContainerInfo.Type.WEB_INF_CLASSES;
                }

                @Override
                public String getName() {
                    return "WEB-INF/classes";
                }

                @Override
                public Container getContainer() {
                    return classesContainer;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class);
                }
            };
            containerInfos.add(containerInfo);
        }
        if ((libEntry = containerToAdapt.getEntry("WEB-INF/lib")) != null && (libContainer = (Container)libEntry.adapt(Container.class)) != null) {
            for (Entry entry : libContainer) {
                if (!entry.getName().toLowerCase().endsWith(".jar")) continue;
                final String jarEntryName = entry.getName();
                final Container jarContainer = (Container)entry.adapt(Container.class);
                if (jarContainer == null) continue;
                ContainerInfo containerInfo = new ContainerInfo(){
                    static final long serialVersionUID = -1041149913428663972L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public ContainerInfo.Type getType() {
                        return ContainerInfo.Type.WEB_INF_LIB;
                    }

                    @Override
                    public String getName() {
                        return "WEB-INF/lib/" + jarEntryName;
                    }

                    @Override
                    public Container getContainer() {
                        return jarContainer;
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register(2.class);
                    }
                };
                containerInfos.add(containerInfo);
                ManifestClassPathUtils.addCompleteJarEntryUrls(containerInfos, entry, resolved);
            }
        }
        classesInfo = new WebModuleClassesInfo(){
            static final long serialVersionUID = -4905740778223865174L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public List<ContainerInfo> getClassesContainers() {
                return containerInfos;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(3.class);
            }
        };
        rootOverlay.addToNonPersistentCache(artifactContainer.getPath(), WebModuleClassesInfo.class, (Object)classesInfo);
        return classesInfo;
    }
}

