/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.csi;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.yoko.orb.csi.CSIClientRequestInterceptor;
import org.apache.yoko.orb.csi.CSIPolicyFactory;
import org.apache.yoko.orb.csi.CSIServerRequestInterceptor;
import org.apache.yoko.orb.csi.GSSUPIORInterceptor;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.LocalObject;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecFactoryPackage.UnknownEncoding;
import org.omg.IOP.Encoding;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.IORInterceptor;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitInfoPackage.DuplicateName;
import org.omg.PortableInterceptor.ORBInitializer;
import org.omg.PortableInterceptor.PolicyFactory;
import org.omg.PortableInterceptor.ServerRequestInterceptor;

public class CSIInterceptorLoader
extends LocalObject
implements ORBInitializer {
    static Logger log = Logger.getLogger(CSIInterceptorLoader.class.getName());
    CSIClientRequestInterceptor client_interceptor;
    CSIServerRequestInterceptor server_interceptor;
    GSSUPIORInterceptor ior_interceptor;

    public void pre_init(ORBInitInfo info) {
        log.fine("********  Running PortableCSILoader ******** ");
        Codec codec = null;
        try {
            codec = info.codec_factory().create_codec(new Encoding(0, 1, 2));
        }
        catch (UnknownEncoding ex) {
            log.log(Level.SEVERE, "Could not get codec: ", ex);
            return;
        }
        this.client_interceptor = new CSIClientRequestInterceptor(codec);
        this.server_interceptor = new CSIServerRequestInterceptor(codec);
        this.ior_interceptor = new GSSUPIORInterceptor(codec);
        CSIPolicyFactory factory = new CSIPolicyFactory();
        info.register_policy_factory(12, (PolicyFactory)factory);
        info.register_policy_factory(13, (PolicyFactory)factory);
        info.register_policy_factory(15, (PolicyFactory)factory);
        info.register_policy_factory(39, (PolicyFactory)factory);
        info.register_policy_factory(8080, (PolicyFactory)factory);
        info.register_policy_factory(38, (PolicyFactory)factory);
        try {
            info.add_client_request_interceptor((ClientRequestInterceptor)this.client_interceptor);
            info.add_server_request_interceptor((ServerRequestInterceptor)this.server_interceptor);
            info.add_ior_interceptor((IORInterceptor)this.ior_interceptor);
        }
        catch (DuplicateName ex) {
            throw (INITIALIZE)new INITIALIZE(ex.getMessage()).initCause((Throwable)ex);
        }
    }

    public void post_init(ORBInitInfo info) {
    }
}

