/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OCI.IIOP;

import java.util.Vector;
import java.util.logging.Logger;
import org.apache.yoko.orb.CORBA.InputStream;
import org.apache.yoko.orb.CORBA.OutputStream;
import org.apache.yoko.orb.OB.Assert;
import org.apache.yoko.orb.OB.Net;
import org.apache.yoko.orb.OCI.AccFactory;
import org.apache.yoko.orb.OCI.AccFactoryInfo;
import org.apache.yoko.orb.OCI.Acceptor;
import org.apache.yoko.orb.OCI.Buffer;
import org.apache.yoko.orb.OCI.IIOP.AccFactoryInfo_impl;
import org.apache.yoko.orb.OCI.IIOP.Acceptor_impl;
import org.apache.yoko.orb.OCI.IIOP.ConnectionHelper;
import org.apache.yoko.orb.OCI.IIOP.ExtendedConnectionHelper;
import org.apache.yoko.orb.OCI.IIOP.ListenerMap;
import org.apache.yoko.orb.OCI.InvalidParam;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.IIOP.ProfileBody_1_0;
import org.omg.IIOP.ProfileBody_1_0Helper;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecFactory;
import org.omg.IOP.CodecFactoryPackage.UnknownEncoding;
import org.omg.IOP.Encoding;
import org.omg.IOP.IORHolder;
import org.omg.IOP.TaggedComponent;
import org.omg.IOP.TaggedComponentHelper;

final class AccFactory_impl
extends LocalObject
implements AccFactory {
    static final Logger logger = Logger.getLogger(AccFactory.class.getName());
    private static final Encoding CDR_1_2_ENCODING = new Encoding(0, 1, 2);
    private AccFactoryInfo_impl info_;
    private ORB orb_;
    private ConnectionHelper connectionHelper_;
    private ListenerMap listenMap_;
    private ExtendedConnectionHelper extendedConnectionHelper_;

    @Override
    public String id() {
        return "iiop";
    }

    @Override
    public int tag() {
        return 0;
    }

    @Override
    public AccFactoryInfo get_info() {
        return this.info_;
    }

    @Override
    public Acceptor create_acceptor(String[] params) throws InvalidParam {
        Codec codec;
        String bind = null;
        Object[] hosts = null;
        boolean keepAlive = true;
        boolean multiProfile = false;
        int port = 0;
        int backlog = 0;
        boolean numeric = false;
        int i = 0;
        while (i < params.length) {
            String arg;
            if (params[i].equals("--backlog")) {
                if (i + 1 >= params.length) {
                    throw new InvalidParam("argument expected for --backlog");
                }
                arg = params[i + 1];
                try {
                    backlog = Integer.valueOf(arg);
                }
                catch (NumberFormatException ex) {
                    throw new InvalidParam("invalid argument for backlog");
                }
                if (backlog < 1 || backlog > 65535) {
                    throw new InvalidParam("invalid backlog");
                }
                i += 2;
                continue;
            }
            if (params[i].equals("--bind")) {
                if (i + 1 >= params.length) {
                    throw new InvalidParam("argument expected for --bind");
                }
                bind = params[i + 1];
                i += 2;
                continue;
            }
            if (params[i].equals("--host")) {
                if (i + 1 >= params.length) {
                    throw new InvalidParam("argument expected for --host");
                }
                Vector<String> vec = new Vector<String>();
                int start = 0;
                String str = params[i + 1];
                while (true) {
                    if (start < str.length() && str.charAt(start) == ' ') {
                        ++start;
                        continue;
                    }
                    if (start >= str.length()) break;
                    int comma = str.indexOf(44, start);
                    if (comma == start) {
                        ++start;
                        continue;
                    }
                    if (comma == -1) {
                        comma = str.length();
                    }
                    int end = comma - 1;
                    while (str.charAt(end) == ' ') {
                        --end;
                    }
                    vec.addElement(str.substring(start, end + 1));
                    start = comma + 1;
                }
                if (vec.size() == 0) {
                    throw new InvalidParam("invalid argument for --host");
                }
                hosts = new String[vec.size()];
                vec.copyInto(hosts);
                i += 2;
                continue;
            }
            if (params[i].equals("--multi-profile")) {
                multiProfile = true;
                ++i;
                continue;
            }
            if (params[i].equals("--no-keepalive")) {
                keepAlive = false;
                ++i;
                continue;
            }
            if (params[i].equals("--numeric")) {
                numeric = true;
                ++i;
                continue;
            }
            if (params[i].equals("--port")) {
                if (i + 1 >= params.length) {
                    throw new InvalidParam("argument expected for --port");
                }
                arg = params[i + 1];
                try {
                    port = Integer.valueOf(arg);
                }
                catch (NumberFormatException ex) {
                    throw new InvalidParam("invalid argument for port");
                }
                if (port < 1 || port > 65535) {
                    throw new InvalidParam("invalid port");
                }
                i += 2;
                continue;
            }
            if (this.connectionHelper_ != null) {
                throw new InvalidParam("unknown parameter: " + params[i]);
            }
            ++i;
        }
        if (hosts == null) {
            hosts = new String[]{Net.getCanonicalHostname(numeric)};
        }
        logger.fine("Creating acceptor for port=" + port);
        try {
            codec = ((CodecFactory)this.orb_.resolve_initial_references("CodecFactory")).create_codec(CDR_1_2_ENCODING);
        }
        catch (InvalidName e) {
            throw new InvalidParam("Could not obtain codec factory using name 'CodecFactory'");
        }
        catch (UnknownEncoding e) {
            throw new InvalidParam("Could not obtain codec using encoding " + CDR_1_2_ENCODING);
        }
        return new Acceptor_impl(bind, (String[])hosts, multiProfile, port, backlog, keepAlive, this.connectionHelper_, this.extendedConnectionHelper_, this.listenMap_, params, codec);
    }

    @Override
    public void change_key(IORHolder ior, byte[] key) {
        for (int profile = 0; profile < ior.value.profiles.length; ++profile) {
            TaggedComponent[] components;
            if (ior.value.profiles[profile].tag != 0) continue;
            byte[] data = ior.value.profiles[profile].profile_data;
            Buffer buf = new Buffer(data, data.length);
            InputStream in = new InputStream(buf, 0, false, null, null);
            in._OB_readEndian();
            ProfileBody_1_0 body = ProfileBody_1_0Helper.read((org.omg.CORBA.portable.InputStream)in);
            if (body.iiop_version.major > 1 || body.iiop_version.minor > 0) {
                int len = in.read_ulong();
                components = new TaggedComponent[len];
                for (int j = 0; j < len; ++j) {
                    components[j] = TaggedComponentHelper.read((org.omg.CORBA.portable.InputStream)in);
                }
            } else {
                components = new TaggedComponent[]{};
            }
            body.object_key = key;
            Buffer buf2 = new Buffer();
            OutputStream out = new OutputStream(buf2);
            out._OB_writeEndian();
            ProfileBody_1_0Helper.write((org.omg.CORBA.portable.OutputStream)out, (ProfileBody_1_0)body);
            if (body.iiop_version.major > 1 || body.iiop_version.minor > 0) {
                out.write_ulong(components.length);
                for (int i = 0; i < components.length; ++i) {
                    TaggedComponentHelper.write((org.omg.CORBA.portable.OutputStream)out, (TaggedComponent)components[i]);
                }
            }
            ior.value.profiles[profile].profile_data = new byte[buf2.length()];
            System.arraycopy(buf2.data(), 0, ior.value.profiles[profile].profile_data, 0, buf2.length());
        }
    }

    public AccFactory_impl(ORB orb, ListenerMap lm, ConnectionHelper helper, ExtendedConnectionHelper extendedHelper) {
        Assert._OB_assert(helper == null ^ extendedHelper == null);
        this.orb_ = orb;
        this.info_ = new AccFactoryInfo_impl();
        this.listenMap_ = lm;
        this.connectionHelper_ = helper;
        this.extendedConnectionHelper_ = extendedHelper;
    }
}

