/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OB;

import org.apache.yoko.orb.CORBA.Any;
import org.apache.yoko.orb.CORBA.OutputStream;
import org.apache.yoko.orb.OB.Assert;
import org.apache.yoko.orb.OB.Client;
import org.apache.yoko.orb.OB.Downcall;
import org.apache.yoko.orb.OB.FailureException;
import org.apache.yoko.orb.OB.LocationForward;
import org.apache.yoko.orb.OB.MinorCodes;
import org.apache.yoko.orb.OB.ORBInstance;
import org.apache.yoko.orb.OB.PIManager;
import org.apache.yoko.orb.OB.RefCountPolicyList;
import org.apache.yoko.orb.OB.Util;
import org.apache.yoko.orb.OCI.ProfileInfo;
import org.apache.yoko.util.concurrent.AutoLock;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.UNKNOWNHelper;
import org.omg.CORBA.UnknownUserException;
import org.omg.CORBA.UserException;
import org.omg.IOP.IOR;
import org.omg.PortableInterceptor.ClientRequestInfo;

public class PIDowncall
extends Downcall {
    protected IOR IOR_;
    protected IOR origIOR_;
    protected PIManager piManager_;
    protected ClientRequestInfo requestInfo_;

    @Override
    void checkForException() throws LocationForward, FailureException {
        try (AutoLock lock = this.stateLock.getReadLock();){
            if (this.ex_ != null && this.exId_ == null) {
                this.exId_ = Util.getExceptionId(this.ex_);
            }
            switch (this.state) {
                case USER_EXCEPTION: {
                    if (this.ex_ == null && this.exId_ != null) {
                        Any any = new Any(this.orbInstance_);
                        UNKNOWN sys = new UNKNOWN(MinorCodes.describeUnknown(1330446337) + ": " + this.exId_, 1330446337, CompletionStatus.COMPLETED_YES);
                        UNKNOWNHelper.insert((org.omg.CORBA.Any)any, (UNKNOWN)sys);
                        UnknownUserException unk = new UnknownUserException((org.omg.CORBA.Any)any);
                        this.piManager_.clientReceiveException(this.requestInfo_, false, (Exception)unk, this.exId_);
                    }
                    if (this.ex_ == null) break;
                    this.piManager_.clientReceiveException(this.requestInfo_, false, this.ex_, this.exId_);
                    break;
                }
                case SYSTEM_EXCEPTION: {
                    Assert._OB_assert(this.ex_ != null);
                    this.piManager_.clientReceiveException(this.requestInfo_, true, this.ex_, this.exId_);
                    break;
                }
                case FAILURE_EXCEPTION: {
                    try {
                        Assert._OB_assert(this.ex_ != null);
                        this.piManager_.clientReceiveException(this.requestInfo_, true, this.ex_, this.exId_);
                    }
                    catch (SystemException systemException) {}
                    break;
                }
                case FORWARD: 
                case FORWARD_PERM: {
                    Assert._OB_assert(this.forwardIOR_ != null);
                    this.piManager_.clientReceiveLocationForward(this.requestInfo_, this.forwardIOR_);
                    break;
                }
            }
            super.checkForException();
        }
    }

    public PIDowncall(ORBInstance orbInstance, Client client, ProfileInfo profileInfo, RefCountPolicyList policies, String op, boolean resp, IOR IOR2, IOR origIOR, PIManager piManager) {
        super(orbInstance, client, profileInfo, policies, op, resp);
        this.IOR_ = IOR2;
        this.origIOR_ = origIOR;
        this.piManager_ = piManager;
    }

    @Override
    public OutputStream preMarshal() throws LocationForward, FailureException {
        this.requestInfo_ = this.piManager_.clientSendRequest(this.op_, this.responseExpected_, this.IOR_, this.origIOR_, this.profileInfo_, this.policies_.value, this.requestSCL_, this.replySCL_);
        return super.preMarshal();
    }

    @Override
    public void postUnmarshal() throws LocationForward, FailureException {
        try (AutoLock lock = this.stateLock.getReadLock();){
            if (this.state == Downcall.State.USER_EXCEPTION && this.ex_ == null && this.exId_ == null) {
                String id = this.unmarshalExceptionId();
                this.setSystemException((SystemException)new UNKNOWN(MinorCodes.describeUnknown(1330446337) + ": " + id, 1330446337, CompletionStatus.COMPLETED_YES));
                this.exId_ = id;
            }
            super.postUnmarshal();
            if (this.state == Downcall.State.USER_EXCEPTION) {
                return;
            }
            if (this.responseExpected_) {
                Assert._OB_assert(this.state == Downcall.State.NO_EXCEPTION);
            } else {
                Assert._OB_assert(this.state == Downcall.State.UNSENT || this.state == Downcall.State.NO_EXCEPTION);
            }
            this.piManager_.clientReceiveReply(this.requestInfo_);
        }
    }

    @Override
    public void setUserException(UserException ex, String exId) {
        super.setUserException(ex, exId);
        this.exId_ = exId;
    }
}

