/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OB;

import org.apache.yoko.orb.CORBA.InputStream;
import org.apache.yoko.orb.CORBA.OutputStream;
import org.apache.yoko.orb.OB.Assert;
import org.apache.yoko.orb.OB.CodeSetInfo;
import org.apache.yoko.orb.OB.CodeSetReader;
import org.apache.yoko.orb.OB.CodeSetWriter;
import org.apache.yoko.orb.OB.FixedWidth2Reader;
import org.apache.yoko.orb.OB.FixedWidth2Writer;
import org.apache.yoko.orb.OB.UTF16Reader;
import org.apache.yoko.orb.OB.UTF16Writer;
import org.apache.yoko.orb.OB.UTF8Reader;
import org.apache.yoko.orb.OB.UTF8Writer;
import org.omg.CORBA.DATA_CONVERSION;

public abstract class CodeConverterBase {
    protected CodeSetInfo from_;
    protected CodeSetInfo to_;
    private CodeSetReader reader_;
    private CodeSetWriter writer_;
    private static CodeSetInfo noneInstance_;

    CodeConverterBase(CodeSetInfo from, CodeSetInfo to) {
        if ((from == null || to == null) && noneInstance_ == null) {
            noneInstance_ = new CodeSetInfo("none", 0, 0, null, 2);
        }
        if (from == null) {
            from = noneInstance_;
        }
        if (to == null) {
            to = noneInstance_;
        }
        this.from_ = from;
        this.to_ = to;
        if (from.rgy_value == 0x5010001) {
            this.reader_ = new UTF8Reader();
        } else if (from.rgy_value == 65801) {
            this.reader_ = new UTF16Reader();
        } else if (from.max_bytes <= 2) {
            this.reader_ = new FixedWidth2Reader();
        } else {
            Assert._OB_assert(false);
        }
        if (to.rgy_value == 0x5010001) {
            this.writer_ = new UTF8Writer();
        } else if (to.rgy_value == 65801) {
            this.writer_ = new UTF16Writer();
        } else if (to.max_bytes <= 2) {
            this.writer_ = new FixedWidth2Writer();
        } else {
            Assert._OB_assert(false);
        }
    }

    public final boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        CodeConverterBase b = (CodeConverterBase)obj;
        return this.from_.rgy_value == b.from_.rgy_value && this.to_.rgy_value == b.to_.rgy_value;
    }

    public final int hashCode() {
        return this.from_.rgy_value + 29 * this.to_.rgy_value;
    }

    public final char read_char(InputStream in) throws DATA_CONVERSION {
        return this.reader_.read_char(in);
    }

    public char read_wchar(InputStream in, int len) throws DATA_CONVERSION {
        return this.reader_.read_wchar(in, len);
    }

    public void write_char(OutputStream out, char v) throws DATA_CONVERSION {
        this.writer_.write_char(out, v);
    }

    public void write_wchar(OutputStream out, char v) throws DATA_CONVERSION {
        this.writer_.write_wchar(out, v);
    }

    public int read_count_wchar(char v) {
        return this.reader_.count_wchar(v);
    }

    public int write_count_wchar(char v) {
        return this.writer_.count_wchar(v);
    }

    public final boolean readerRequired() {
        return this.from_.rgy_value == 0x5010001 || this.from_.rgy_value == 65801;
    }

    public final boolean writerRequired() {
        return this.to_.rgy_value == 0x5010001 || this.to_.rgy_value == 65801;
    }

    public final CodeSetInfo getFrom() {
        return this.from_;
    }

    public final CodeSetInfo getTo() {
        return this.to_;
    }

    public final void set_reader_flags(int flags) {
        this.reader_.set_flags(flags);
    }

    public final void set_writer_flags(int flags) {
        this.writer_.set_flags(flags);
    }

    public abstract boolean conversionRequired();

    public abstract char convert(char var1);
}

