/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbcontainer.timer.persistent.osgi.internal;

import com.ibm.ejs.container.BeanMetaData;
import com.ibm.ejs.container.EJBMethodInfoImpl;
import com.ibm.ejs.container.EJBNotFoundException;
import com.ibm.ejs.container.EJSContainer;
import com.ibm.ejs.container.PersistentTimer;
import com.ibm.ejs.container.PersistentTimerTaskHandler;
import com.ibm.websphere.concurrent.persistent.TaskIdAccessor;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.concurrent.persistent.ejb.TimerTrigger;
import com.ibm.ws.ejbcontainer.runtime.EJBRuntime;
import com.ibm.ws.ejbcontainer.util.ParsedScheduleExpression;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.Serializable;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.concurrent.LastExecution;
import javax.enterprise.concurrent.ManagedTaskListener;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
class PersistentTimerTaskHandlerImpl
extends PersistentTimerTaskHandler
implements TimerTrigger {
    private static final long serialVersionUID = -8200752857441853748L;
    private static final TraceComponent tc = Tr.register(PersistentTimerTaskHandlerImpl.class, (String)"EJBContainer", (String)"com.ibm.ejs.container.container");
    private static final String TIMER_NAME_PREFIX_AUTO = "!EJBTimerA!";
    private static final String TIMER_NAME_PREFIX_PROG = "!EJBTimerP!";
    private static final String TIMER_NAME_PREFIX_PATTERN = "!EJBTimer_!";

    @Trivial
    protected PersistentTimerTaskHandlerImpl(J2EEName j2eeName, @Sensitive Serializable info, Date expiration, long interval) {
        super(j2eeName, info, expiration, interval);
    }

    @Trivial
    protected PersistentTimerTaskHandlerImpl(J2EEName j2eeName, @Sensitive Serializable info, ParsedScheduleExpression parsedSchedule) {
        super(j2eeName, info, parsedSchedule);
    }

    @Trivial
    protected PersistentTimerTaskHandlerImpl(J2EEName j2eeName, @Sensitive Serializable info, ParsedScheduleExpression parsedSchedule, int methodId, String methodName, String className) {
        super(j2eeName, info, parsedSchedule, methodId, methodName, className);
    }

    protected PersistentTimer createTimer(EJBRuntime ejbRuntime) {
        return ejbRuntime.getPersistentTimer(TaskIdAccessor.get().longValue(), this.j2eeName, (PersistentTimerTaskHandler)this);
    }

    public Date getNextTimeout(Date lastExecution, Date timerCreationTime) {
        long nextTimeout;
        if (this.parsedSchedule == null) {
            if (lastExecution == null) {
                return new Date(this.expiration);
            }
            if (this.interval < 0L) {
                return null;
            }
            return new Date(lastExecution.getTime() + this.interval);
        }
        if (lastExecution != null) {
            nextTimeout = this.parsedSchedule.getNextTimeout(lastExecution.getTime());
        } else {
            nextTimeout = this.parsedSchedule.getFirstTimeout();
            if (nextTimeout == -1L) {
                GregorianCalendar cal = new GregorianCalendar();
                cal.setTime(timerCreationTime);
                cal.set(14, 0);
                cal.add(13, 1);
                return cal.getTime();
            }
        }
        if (nextTimeout == -1L) {
            return null;
        }
        return new Date(nextTimeout);
    }

    public Map<String, String> getExecutionProperties() {
        String taskOwner = this.j2eeName.getApplication() + "/" + this.j2eeName.getModule() + "/" + this.j2eeName.getComponent();
        BeanMetaData bmd = this.getBeanMetaData();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("javax.enterprise.concurrent.IDENTITY_NAME", this.getTaskName());
        props.put("javax.enterprise.concurrent.TRANSACTION", PersistentTimerTaskHandlerImpl.runInGlobalTransaction((EJBMethodInfoImpl)bmd.timedMethodInfos[this.methodId]) ? "USE_TRANSACTION_OF_EXECUTION_THREAD" : "SUSPEND");
        props.put("com.ibm.ws.concurrent.TASK_OWNER", taskOwner);
        props.put("com.ibm.ws.concurrent.TRANSACTION_TIMEOUT", Integer.toString(bmd._globalTran.getTransactionTimeout()));
        return props;
    }

    @Trivial
    public ManagedTaskListener getManagedTaskListener() {
        return null;
    }

    public Date getNextRunTime(LastExecution lastExecutionInfo, Date taskScheduledTime) {
        Date lastExecution = lastExecutionInfo == null ? null : lastExecutionInfo.getScheduledStart();
        return this.getNextTimeout(lastExecution, taskScheduledTime);
    }

    public boolean skipRun(LastExecution lastExecutionInfo, Date scheduledRunTime) {
        EJBRuntime ejbRuntime = EJSContainer.getDefaultContainer().getEJBRuntime();
        ejbRuntime.checkLateTimerThreshold(scheduledRunTime, TaskIdAccessor.get().toString(), this.j2eeName);
        return false;
    }

    public String getAppName() {
        return this.j2eeName.getApplication();
    }

    /*
     * WARNING - void declaration
     */
    public ClassLoader getClassLoader() {
        ClassLoader cl;
        try {
            cl = EJSContainer.getDefaultContainer().getInstalledHome((J2EEName)this.j2eeName).getBeanMetaData().ivContextClassLoader;
        }
        catch (EJBNotFoundException eJBNotFoundException) {
            void e;
            FFDCFilter.processException((Throwable)eJBNotFoundException, (String)"com.ibm.ws.ejbcontainer.timer.persistent.osgi.internal.PersistentTimerTaskHandlerImpl", (String)"250", (Object)((Object)this), (Object[])new Object[0]);
            Tr.warning((TraceComponent)tc, (String)"HOME_NOT_FOUND_CNTR0092W", (Object[])new Object[]{this.j2eeName.toString()});
            throw new IllegalStateException((Throwable)e);
        }
        return cl;
    }

    @Trivial
    String getTaskName() {
        return PersistentTimerTaskHandlerImpl.getTaskName(this.j2eeName, this.isAutomaticTimer() ? TIMER_NAME_PREFIX_AUTO : TIMER_NAME_PREFIX_PROG, false);
    }

    private static String getTaskName(J2EEName j2eeName, String timerNamePrefix, boolean escape) {
        StringBuffer sb = new StringBuffer();
        sb.append(timerNamePrefix);
        sb.append(escape ? PersistentTimerTaskHandlerImpl.escapePattern(j2eeName.getModule()) : j2eeName.getModule());
        sb.append('#');
        sb.append(escape ? PersistentTimerTaskHandlerImpl.escapePattern(j2eeName.getComponent()) : j2eeName.getComponent());
        return sb.toString();
    }

    @Trivial
    protected static String getTaskNameBeanPattern(J2EEName j2eeName) {
        return PersistentTimerTaskHandlerImpl.getTaskName(j2eeName, TIMER_NAME_PREFIX_PATTERN, true);
    }

    protected static String getAutomaticTimerTaskNameBeanPattern(J2EEName j2eeName) {
        return PersistentTimerTaskHandlerImpl.getTaskName(j2eeName, TIMER_NAME_PREFIX_AUTO, true);
    }

    protected static String getTaskNameModulePattern(String moduleName) {
        return PersistentTimerTaskHandlerImpl.getTaskNameModulePattern(moduleName, TIMER_NAME_PREFIX_PATTERN);
    }

    protected static String getAutomaticTimerTaskNameModulePattern(String moduleName) {
        return PersistentTimerTaskHandlerImpl.getTaskNameModulePattern(moduleName, TIMER_NAME_PREFIX_AUTO);
    }

    private static String getTaskNameModulePattern(String moduleName, String prefix) {
        StringBuffer sb = new StringBuffer();
        sb.append(prefix);
        sb.append(PersistentTimerTaskHandlerImpl.escapePattern(moduleName));
        sb.append("#%");
        return sb.toString();
    }

    public static String getAutomaticTimerPropertyName(String appName, String moduleName) {
        StringBuilder sb = new StringBuilder();
        sb.append(TIMER_NAME_PREFIX_AUTO);
        sb.append(appName);
        sb.append('#');
        sb.append(moduleName);
        return sb.toString();
    }

    @Trivial
    private static String escapePattern(String s) {
        return s.replace("\\", "\\\\").replace("_", "\\_").replace("%", "\\%");
    }

    public static String getAutomaticTimerPropertyPattern(String appName, String moduleName) {
        return PersistentTimerTaskHandlerImpl.getAutomaticTimerPropertyName(PersistentTimerTaskHandlerImpl.escapePattern(appName), moduleName != null ? PersistentTimerTaskHandlerImpl.escapePattern(moduleName) : "%");
    }
}

