/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxrs20.client.bus;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.jaxrs20.api.ExtensionProvider;
import com.ibm.ws.jaxrs20.bus.LibertyApplicationBus;
import com.ibm.ws.jaxrs20.bus.LibertyApplicationBusFactory;
import com.ibm.ws.jaxrs20.bus.LibertyApplicationBusListener;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.util.ThreadContextAccessor;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.extension.Extension;
import org.apache.cxf.bus.extension.ExtensionManager;
import org.apache.cxf.bus.extension.ExtensionManagerImpl;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class LibertyJAXRSClientBusFactory
extends LibertyApplicationBusFactory {
    private static final TraceComponent tc = Tr.register(LibertyJAXRSClientBusFactory.class);
    private static final LibertyJAXRSClientBusFactory factory = new LibertyJAXRSClientBusFactory();
    private static final ThreadContextAccessor THREAD_CONTEXT_ACCESSOR = (ThreadContextAccessor)AccessController.doPrivileged(ThreadContextAccessor.getPrivilegedAction());
    static final long serialVersionUID = -3542333046994364008L;

    public static LibertyJAXRSClientBusFactory getInstance() {
        return factory;
    }

    private LibertyJAXRSClientBusFactory() {
    }

    public LibertyApplicationBus createClientScopedBus(String baseURI, ClassLoader appContextClassLoader) {
        if (baseURI == null || "".equalsIgnoreCase(baseURI)) {
            return null;
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("org.apache.cxf.bus.id", "RS-Client-Bus-" + baseURI);
        HashMap<Class<LibertyApplicationBus.Type>, LibertyApplicationBus.Type> extensions = new HashMap<Class<LibertyApplicationBus.Type>, LibertyApplicationBus.Type>();
        extensions.put(LibertyApplicationBus.Type.class, LibertyApplicationBus.Type.CLIENT);
        LibertyApplicationBus bus = this.createBus(extensions, properties, appContextClassLoader);
        return bus;
    }

    public LibertyApplicationBus getClientScopeBus(String id) {
        LibertyApplicationBus bus = null;
        if (id == null || "".equalsIgnoreCase(id)) {
            return null;
        }
        bus = this.createClientScopedBus(id, THREAD_CONTEXT_ACCESSOR.getContextClassLoader(Thread.currentThread()));
        return bus;
    }

    protected void initializeBus(Bus bus) {
        ExtensionManager extensionManager;
        Object listenersCopy;
        if (this.listeners.isEmpty() && (listenersCopy = LibertyApplicationBusFactory.getInstance().getBusListenersCopy()) != null) {
            Iterator iterator = listenersCopy.iterator();
            while (iterator.hasNext()) {
                LibertyApplicationBusListener listener = (LibertyApplicationBusListener)iterator.next();
                this.listeners.add(listener);
            }
        }
        if (!this.listeners.isEmpty()) {
            for (LibertyApplicationBusListener listener : this.listeners) {
                listener.preInit(bus);
            }
        }
        if ((extensionManager = (ExtensionManager)bus.getExtension(ExtensionManager.class)) != null && extensionManager instanceof ExtensionManagerImpl) {
            List extensionProvidersCopy;
            ExtensionManagerImpl managerImpl = (ExtensionManagerImpl)extensionManager;
            if (this.extensionProviders.isEmpty() && (extensionProvidersCopy = LibertyApplicationBusFactory.getInstance().getExtensionProviderCopy()) != null) {
                for (ExtensionProvider extensionProvider : extensionProvidersCopy) {
                    this.extensionProviders.add(extensionProvider);
                }
            }
            if (this.extensionProviders.isEmpty()) {
                for (ExtensionProvider extensionProvider : this.extensionProviders) {
                    Extension extension = extensionProvider.getExtension(bus);
                    if (extension == null) continue;
                    managerImpl.add(extension);
                }
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)((extensionManager == null ? "Unable to locate extension manager " : "The extension manager is not of type ExtensionManagerImpl") + ", all the extensions from ExtensionProvider are ignored"), (Object[])new Object[0]);
        }
    }
}

