/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxrs20.appsecurity.component;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.ssl.SSLSupport;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocketFactory;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(name="com.ibm.ws.jaxrs20.appsecurity.component.SSLSupportService", property={"service.vendor=IBM"})
public class SSLSupportService {
    private static final TraceComponent tc = Tr.register(SSLSupportService.class);
    private static volatile SSLSupport sslSupport;
    private static final Map<String, SSLSocketFactory> socketFactories;
    static final long serialVersionUID = -6441954964670862633L;

    @Reference(name="SSLSupportService", service=SSLSupport.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setSSLSupportService(SSLSupport service) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"registerSSLSupportService", (Object[])new Object[0]);
        }
        sslSupport = service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unsetSSLSupportService(SSLSupport service) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"unregisterSSLSupportService", (Object[])new Object[0]);
        }
        Map<String, SSLSocketFactory> map = socketFactories;
        synchronized (map) {
            socketFactories.clear();
        }
        if (sslSupport == service) {
            sslSupport = null;
        }
    }

    public static boolean isSSLSupportServiceReady() {
        return sslSupport != null;
    }

    public static SSLSupport getSSLSupport() {
        return sslSupport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SSLSocketFactory getSSLSocketFactory(String sslRef) throws SSLException {
        SSLSocketFactory factory;
        Map<String, SSLSocketFactory> map = socketFactories;
        synchronized (map) {
            factory = socketFactories.get(sslRef);
            if (factory == null) {
                factory = sslSupport.getSSLSocketFactory(sslRef);
                socketFactories.put(sslRef, factory);
            }
        }
        return factory;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        socketFactories = new HashMap<String, SSLSocketFactory>();
    }
}

