/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.javaee.ddmodel.ejbbnd;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.javaee.dd.commonbnd.Interceptor;
import com.ibm.ws.javaee.dd.commonbnd.MessageDestination;
import com.ibm.ws.javaee.dd.ejb.EJBJar;
import com.ibm.ws.javaee.dd.ejbbnd.EJBJarBnd;
import com.ibm.ws.javaee.dd.ejbbnd.EnterpriseBean;
import com.ibm.ws.javaee.ddmodel.CrossComponentReferenceType;
import com.ibm.ws.javaee.ddmodel.DDParser;
import com.ibm.ws.javaee.ddmodel.StringType;
import com.ibm.ws.javaee.ddmodel.commonbnd.InterceptorType;
import com.ibm.ws.javaee.ddmodel.commonbnd.MessageDestinationType;
import com.ibm.ws.javaee.ddmodel.ejbbnd.EnterpriseBeanType;
import com.ibm.ws.javaee.ddmodel.ejbbnd.MessageDrivenType;
import com.ibm.ws.javaee.ddmodel.ejbbnd.SessionType;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class EJBJarBndType
extends DDParser.ElementContentParsable
implements EJBJarBnd,
DDParser.RootParsable {
    private static final TraceComponent tc = Tr.register(EJBJarBndType.class);
    private final String deploymentDescriptorPath;
    private DDParser.ComponentIDMap idMap;
    protected final boolean xmi;
    private CrossComponentReferenceType xmiRef;
    StringType version;
    DDParser.ParsableListImplements<EnterpriseBeanType, EnterpriseBean> enterpriseBeans;
    DDParser.ParsableListImplements<InterceptorType, Interceptor> interceptor;
    DDParser.ParsableListImplements<MessageDestinationType, MessageDestination> message_destination;
    DefaultCMPConnectionFactoryXMIIgnoredType defaultCMPConnectionFactory;
    DefaultDatasourceXMIIgnoredType defaultDatasource;
    StringType currentBackendId;
    static final long serialVersionUID = -3748153486385804456L;

    public EJBJarBndType(String ddPath) {
        this(ddPath, false);
    }

    public EJBJarBndType(String ddPath, boolean xmi) {
        this.xmi = xmi;
        this.deploymentDescriptorPath = ddPath;
    }

    public String getVersion() {
        return this.xmi ? "XMI" : (this.version != null ? this.version.getValue() : null);
    }

    public List<EnterpriseBean> getEnterpriseBeans() {
        if (this.enterpriseBeans != null) {
            return this.enterpriseBeans.getList();
        }
        return Collections.emptyList();
    }

    public List<Interceptor> getInterceptors() {
        if (this.interceptor != null) {
            return this.interceptor.getList();
        }
        return Collections.emptyList();
    }

    public List<MessageDestination> getMessageDestinations() {
        if (this.message_destination != null) {
            return this.message_destination.getList();
        }
        return Collections.emptyList();
    }

    public String getDeploymentDescriptorPath() {
        return this.deploymentDescriptorPath;
    }

    public Object getComponentForId(String id) {
        return this.idMap.getComponentForId(id);
    }

    public String getIdForComponent(Object ddComponent) {
        return this.idMap.getIdForComponent(ddComponent);
    }

    @Override
    public void finish(DDParser parser) throws DDParser.ParseException {
        EnterpriseBean existing;
        this.idMap = parser.idMap;
        HashMap<String, EnterpriseBean> beans = new HashMap<String, EnterpriseBean>(this.getEnterpriseBeans().size());
        for (EnterpriseBean bean : this.getEnterpriseBeans()) {
            existing = beans.put(bean.getName(), bean);
            if (existing == null) continue;
            throw new DDParser.ParseException(Tr.formatMessage((TraceComponent)tc, (String)"found.duplicate.ejbname", (Object[])new Object[]{parser.getDeploymentDescriptorPath(), existing.getName()}));
        }
        HashMap<String, Interceptor> interceptors = new HashMap<String, Interceptor>(this.getInterceptors().size());
        for (Interceptor interceptor : this.getInterceptors()) {
            existing = interceptors.put(interceptor.getClassName(), interceptor);
            if (existing == null) continue;
            throw new DDParser.ParseException(Tr.formatMessage((TraceComponent)tc, (String)"found.duplicate.attribute.value", (Object[])new Object[]{parser.getDeploymentDescriptorPath(), "<interceptor>", "class", existing.getClassName()}));
        }
        HashMap<String, MessageDestination> messageDestinations = new HashMap<String, MessageDestination>(this.getMessageDestinations().size());
        for (MessageDestination messageDestination : this.getMessageDestinations()) {
            existing = messageDestinations.put(messageDestination.getName(), messageDestination);
            if (existing == null) continue;
            throw new DDParser.ParseException(Tr.formatMessage((TraceComponent)tc, (String)"found.duplicate.attribute.value", (Object[])new Object[]{parser.getDeploymentDescriptorPath(), "<message-destination>", "name", existing.getName()}));
        }
    }

    @Override
    public boolean isIdAllowed() {
        return true;
    }

    @Override
    public boolean handleAttribute(DDParser parser, String nsURI, String localName, int index) throws DDParser.ParseException {
        if (nsURI == null) {
            if (!this.xmi && "version".equals(localName)) {
                this.version = parser.parseStringAttributeValue(index);
                return true;
            }
            if (this.xmi && "currentBackendId".equals(localName)) {
                this.currentBackendId = parser.parseStringAttributeValue(index);
                return true;
            }
        }
        return this.xmi && "http://www.omg.org/XMI".equals(nsURI) && "version".equals(localName);
    }

    @Override
    public boolean handleChild(DDParser parser, String localName) throws DDParser.ParseException {
        if (this.xmi && "ejbJar".equals(localName)) {
            this.xmiRef = new CrossComponentReferenceType("ejbJar", EJBJar.class);
            parser.parse(this.xmiRef);
            return true;
        }
        if (!this.xmi && "session".equals(localName)) {
            SessionType enterpriseBeans = new SessionType();
            parser.parse(enterpriseBeans);
            this.addEnterpriseBean(enterpriseBeans);
            return true;
        }
        if (!this.xmi && "message-driven".equals(localName)) {
            MessageDrivenType enterpriseBeans = new MessageDrivenType();
            parser.parse(enterpriseBeans);
            this.addEnterpriseBean(enterpriseBeans);
            return true;
        }
        if (this.xmi && "ejbBindings".equals(localName)) {
            EnterpriseBeanType enterpriseBeans;
            String xmiType = parser.getAttributeValue("http://www.omg.org/XMI", "type");
            if (xmiType == null) {
                enterpriseBeans = new SessionType(true);
            } else if (xmiType.endsWith(":MessageDrivenBeanBinding") && "ejbbnd.xmi".equals(parser.getNamespaceURI(xmiType.substring(0, xmiType.length() - ":MessageDrivenBeanBinding".length())))) {
                enterpriseBeans = new MessageDrivenType(true);
            } else {
                return false;
            }
            parser.parse(enterpriseBeans);
            this.addEnterpriseBean(enterpriseBeans);
            return true;
        }
        if (!this.xmi && "interceptor".equals(localName)) {
            InterceptorType interceptor = new InterceptorType();
            parser.parse(interceptor);
            this.addInterceptor(interceptor);
            return true;
        }
        if (!this.xmi && "message-destination".equals(localName)) {
            MessageDestinationType message_destination = new MessageDestinationType();
            parser.parse(message_destination);
            this.addMessageDestination(message_destination);
            return true;
        }
        if (this.xmi && "defaultCMPConnectionFactory".equals(localName)) {
            DefaultCMPConnectionFactoryXMIIgnoredType defaultCMPConnectionFactory = new DefaultCMPConnectionFactoryXMIIgnoredType(this.xmi);
            parser.parse(defaultCMPConnectionFactory);
            this.defaultCMPConnectionFactory = defaultCMPConnectionFactory;
            return true;
        }
        if (this.xmi && "defaultDatasource".equals(localName)) {
            DefaultDatasourceXMIIgnoredType defaultDatasource = new DefaultDatasourceXMIIgnoredType(this.xmi);
            parser.parse(defaultDatasource);
            this.defaultDatasource = defaultDatasource;
            return true;
        }
        return false;
    }

    void addEnterpriseBean(EnterpriseBeanType enterpriseBeans) {
        if (this.enterpriseBeans == null) {
            this.enterpriseBeans = new DDParser.ParsableListImplements();
        }
        this.enterpriseBeans.add(enterpriseBeans);
    }

    void addInterceptor(InterceptorType interceptor) {
        if (this.interceptor == null) {
            this.interceptor = new DDParser.ParsableListImplements();
        }
        this.interceptor.add(interceptor);
    }

    void addMessageDestination(MessageDestinationType message_destination) {
        if (this.message_destination == null) {
            this.message_destination = new DDParser.ParsableListImplements();
        }
        this.message_destination.add(message_destination);
    }

    @Override
    public void describe(DDParser.Diagnostics diag) {
        diag.describeIfSet("ejbJar", this.xmiRef);
        diag.describeIfSet("version", this.version);
        diag.describeIfSet("currentBackendId", this.currentBackendId);
        diag.describeIfSet(this.xmi ? "ejbBindings" : "enterpriseBeans", this.enterpriseBeans);
        diag.describeIfSet("interceptor", this.interceptor);
        diag.describeIfSet("message-destination", this.message_destination);
        diag.describeIfSet("defaultCMPConnectionFactory", this.defaultCMPConnectionFactory);
        diag.describeIfSet("defaultDatasource", this.defaultDatasource);
    }

    @Override
    public void describe(StringBuilder sb) {
        DDParser.Diagnostics diag = new DDParser.Diagnostics(this.idMap, sb);
        diag.describe(this.toTracingSafeString(), this);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    public static class DefaultDatasourceXMIIgnoredType
    extends DDParser.ElementContentParsable {
        protected final boolean xmi;
        static final long serialVersionUID = 4215447574611070883L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public DefaultDatasourceXMIIgnoredType() {
            this(false);
        }

        public DefaultDatasourceXMIIgnoredType(boolean xmi) {
            this.xmi = xmi;
        }

        @Override
        public boolean isIdAllowed() {
            return this.xmi;
        }

        @Override
        public boolean handleAttribute(DDParser parser, String nsURI, String localName, int index) throws DDParser.ParseException {
            return true;
        }

        @Override
        public boolean handleChild(DDParser parser, String localName) throws DDParser.ParseException {
            return true;
        }

        @Override
        public void describe(DDParser.Diagnostics diag) {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(DefaultDatasourceXMIIgnoredType.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    public static class DefaultCMPConnectionFactoryXMIIgnoredType
    extends DDParser.ElementContentParsable {
        protected final boolean xmi;
        static final long serialVersionUID = 5673077973696506557L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public DefaultCMPConnectionFactoryXMIIgnoredType() {
            this(false);
        }

        public DefaultCMPConnectionFactoryXMIIgnoredType(boolean xmi) {
            this.xmi = xmi;
        }

        @Override
        public boolean isIdAllowed() {
            return this.xmi;
        }

        @Override
        public boolean handleAttribute(DDParser parser, String nsURI, String localName, int index) throws DDParser.ParseException {
            return true;
        }

        @Override
        public boolean handleChild(DDParser parser, String localName) throws DDParser.ParseException {
            return true;
        }

        @Override
        public void describe(DDParser.Diagnostics diag) {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(DefaultCMPConnectionFactoryXMIIgnoredType.class);
        }
    }
}

