/*
 * Decompiled with CFR 0.152.
 */
package wlp.lib.extract;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import wlp.lib.extract.SelfExtract;
import wlp.lib.extract.SelfExtractUtils;
import wlp.lib.extract.StreamReader;

public class ShutdownHook
implements Runnable {
    private static final ResourceBundle resourceBundle = ResourceBundle.getBundle(SelfExtract.class.getName() + "Messages");
    int platformType;
    String dir;
    String serverName;
    Thread out;
    Thread err;

    private ShutdownHook() {
    }

    public ShutdownHook(int platformType, String dir, String serverName, StreamReader out, StreamReader err) {
        this();
        this.serverName = serverName;
        this.out = out;
        this.err = err;
        this.dir = dir;
        this.platformType = platformType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getPID(String dir, String serverName) {
        Object pid;
        block6: {
            pid = null;
            if (this.platformType == 3) {
                String string;
                String pidFile = dir + File.separator + "wlp" + File.separator + "usr" + File.separator + "servers" + File.separator + ".pid" + File.separator + serverName + ".pid";
                BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(pidFile), "UTF-8"));
                try {
                    string = br.readLine();
                }
                catch (Throwable throwable) {
                    try {
                        br.close();
                        throw throwable;
                    }
                    catch (IOException e) {
                        pid = null;
                        if (pid != null) break block6;
                        Object[] substitution = new Object[]{dir};
                        System.out.println(MessageFormat.format(resourceBundle.getString("UNABLE_TO_FIND_PID"), substitution));
                    }
                }
                br.close();
                return string;
            }
        }
        return pid;
    }

    private void stopServer() throws IOException {
        String cmd = this.dir + File.separator + "wlp" + File.separator + "bin" + File.separator + "server stop " + this.serverName;
        if (this.platformType != 1) {
            if (this.platformType == 2) {
                cmd = "cmd /k " + cmd;
            } else if (this.platformType == 3) {
                cmd = "bash -c  \"" + cmd.replace('\\', '/') + '\"';
            }
        }
        Runtime.getRuntime().exec(cmd, SelfExtractUtils.runEnv(this.dir), null);
    }

    private void startAsyncDelete() throws IOException {
        Runtime rt = Runtime.getRuntime();
        File scriptFile = null;
        if (this.platformType == 1) {
            scriptFile = this.writeCleanupFile(1);
            rt.exec("chmod 750 " + scriptFile.getAbsolutePath());
            rt.exec("sh -c " + scriptFile.getAbsolutePath() + " &");
        } else if (this.platformType == 2) {
            scriptFile = this.writeCleanupFile(2);
            rt.exec("cmd /k start /B " + scriptFile.getAbsolutePath() + " >/NUL 2>/NUL");
        } else if (this.platformType == 3) {
            scriptFile = this.writeCleanupFile(3);
            rt.exec("bash -c " + scriptFile.getAbsolutePath().replace('\\', '/') + " &");
        }
    }

    private void writeWindowsCleanup(File file, BufferedWriter bw) throws IOException {
        bw.write("set max=30\n");
        bw.write("set cnt=0\n");
        bw.write("set dir=" + this.dir + "\n");
        bw.write("echo delete %dir%\n");
        bw.write(":while\n");
        bw.write("   if exist %dir% (\n");
        bw.write("      rmdir /s /q %dir%\n");
        bw.write("      timeout 1\n");
        bw.write("      set /a cnt+=1\n");
        bw.write("      if %cnt% leq %max% (\n");
        bw.write("         goto :while \n");
        bw.write("      )\n");
        bw.write("   )\n");
        bw.write("erase " + file.getAbsoluteFile() + "\n");
    }

    private void writeUnixCleanup(File file, BufferedWriter bw) throws IOException {
        bw.write("echo begin delete\n");
        bw.write("n=0\n");
        bw.write("while [ $n -ne 1 ]; do\n");
        bw.write("  sleep 3\n");
        bw.write("  if [ -e " + this.dir.replace('\\', '/') + " ]; then\n");
        bw.write("    rm -rf " + this.dir.replace('\\', '/') + "\n");
        bw.write("  else\n");
        bw.write("    echo file not found - n=$n\n");
        bw.write("    n=1\n");
        bw.write("  fi\n");
        bw.write("done\n");
        bw.write("echo end delete\n");
        bw.write("rm " + file.getAbsolutePath().replace('\\', '/') + "\n");
    }

    private void writeCygwinCleanup(File file, BufferedWriter bw) throws IOException {
        String pid = this.getPID(this.dir, this.serverName);
        if (pid != null) {
            bw.write("kill " + pid + "\n");
        }
        this.writeUnixCleanup(file, bw);
    }

    private File writeCleanupFile(int platformType) throws IOException {
        boolean success;
        File file;
        String fileSuffix = ".sh";
        if (platformType == 2) {
            fileSuffix = ".bat";
        }
        if (!(file = File.createTempFile("wlpDelete", fileSuffix)).exists() && !(success = file.createNewFile())) {
            throw new IOException("Failed to create file " + file.getName());
        }
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file.getAbsoluteFile()), "UTF-8"));
        if (platformType == 1) {
            this.writeUnixCleanup(file, bw);
        } else if (platformType == 2) {
            this.writeWindowsCleanup(file, bw);
        } else if (platformType == 3) {
            this.writeCygwinCleanup(file, bw);
        }
        bw.close();
        return file;
    }

    @Override
    public void run() {
        try {
            this.stopServer();
            if (!System.getProperty("os.name").startsWith("Win")) {
                this.out.join();
                this.err.join();
            } else {
                this.out.join(500L);
                this.err.join(500L);
            }
            this.startAsyncDelete();
        }
        catch (Exception e) {
            throw new RuntimeException("Shutdown hook failed with exception " + e.getMessage());
        }
    }
}

