/*
 * Decompiled with CFR 0.152.
 */
package wlp.lib.extract;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.MessageFormat;
import java.util.List;
import java.util.ResourceBundle;
import wlp.lib.extract.ExtractProgress;
import wlp.lib.extract.LicenseProvider;
import wlp.lib.extract.ReturnCode;
import wlp.lib.extract.SelfExtractUtils;
import wlp.lib.extract.SelfExtractor;

public class SelfExtract {
    private static final ResourceBundle resourceBundle = ResourceBundle.getBundle(SelfExtract.class.getName() + "Messages");
    private static BufferedReader in;
    protected static boolean acceptLicense;
    protected static boolean downloadDependencies;
    protected static boolean verbose;
    protected static String targetString;
    static SelfExtractor extractor;
    private static ReturnCode createExtractor_rc;
    private static boolean extractorCreated;

    public static void main(String[] args) {
        System.exit(SelfExtract.doMain(args));
    }

    protected static ReturnCode createExtractor() {
        if (!extractorCreated) {
            createExtractor_rc = SelfExtractor.buildInstance();
            extractor = SelfExtractor.getInstance();
            extractorCreated = true;
        }
        return createExtractor_rc;
    }

    public static int doMain(String[] args) {
        int code;
        ReturnCode rc = SelfExtract.createExtractor();
        if (rc == ReturnCode.OK) {
            File wlpOutputDir;
            File outputDir;
            File outputDirFromUser;
            acceptLicense = false;
            if (extractor.isUserSample()) {
                acceptLicense = true;
            }
            downloadDependencies = false;
            extractor.setDoExternalDepsDownload(false);
            verbose = false;
            targetString = null;
            boolean archiveHasLicense = extractor.hasLicense();
            extractor.parseArguments(args, archiveHasLicense);
            if (archiveHasLicense) {
                extractor.handleLicenseAcceptance(extractor, acceptLicense);
            }
            if (targetString == null) {
                File workingDir = new File(System.getProperty("user.dir"));
                File defaultPath = SelfExtract.findValidWlpInstallPath(workingDir, extractor);
                SelfExtract.out(extractor.getExtractInstructionMessageKey());
                SelfExtract.out("extractDefault", defaultPath.getAbsolutePath());
                System.out.println();
                targetString = SelfExtract.getResponse(SelfExtract.format("extractPrompt") + " ");
                targetString = targetString.trim();
                outputDirFromUser = "".equals(targetString) ? defaultPath : new File(targetString);
            } else {
                outputDirFromUser = new File(targetString.trim());
            }
            String pathName = outputDirFromUser.getPath();
            if (pathName.startsWith("~")) {
                String pathNameToReturn = pathName.substring(1);
                String home = System.getenv("HOME");
                if (home == null) {
                    SelfExtract.err("invalidInstall", pathName);
                    System.exit(3);
                }
                outputDirFromUser = new File(home, pathNameToReturn);
            }
            if (!(outputDir = SelfExtract.findValidWlpInstallPath(outputDirFromUser = outputDirFromUser.getAbsoluteFile(), extractor)).exists() && !outputDir.mkdirs()) {
                SelfExtract.err("extractDirectoryError", outputDir.getAbsolutePath());
                System.exit(4);
            }
            if ((rc = extractor.validate(wlpOutputDir = new File(outputDir, extractor.getRoot()))) != ReturnCode.OK && rc.getMessageKey() != null && rc.getMessageKey().equalsIgnoreCase("missingRequiredFeatures")) {
                rc = extractor.installMissingRequiredFeatures(wlpOutputDir, rc);
            }
            if (rc == ReturnCode.OK && (rc = SelfExtract.checkUserWantsExternalDeps(extractor, downloadDependencies)) == ReturnCode.OK) {
                rc = extractor.extract(wlpOutputDir, verbose ? new VerboseExtractProgress() : null);
            }
        }
        if ((code = rc.getCode()) > 0) {
            System.err.println(rc.getErrorMessage());
        } else {
            SelfExtract.out(extractor.getExtractSuccessMessageKey());
        }
        return code;
    }

    protected static File findValidWlpInstallPath(File searchDirectory, SelfExtractor extractor) {
        if ((extractor.isProductAddon() || extractor.isUserSample()) && extractor.validate(searchDirectory) != ReturnCode.OK) {
            File wlpSubdir = new File(searchDirectory, "wlp");
            ReturnCode rc = extractor.validate(wlpSubdir);
            if (rc.getCode() == 4 && ("invalidInstall".equals(rc.getMessageKey()) || "LICENSE_invalidInstall".equals(rc.getMessageKey()))) {
                return searchDirectory;
            }
            return wlpSubdir;
        }
        return searchDirectory;
    }

    public static ReturnCode checkUserWantsExternalDeps(SelfExtractor extractor, boolean downloadDependencies) {
        if (extractor.hasExternalDepsFile()) {
            SelfExtractor.ExternalDependencies extDependencies;
            try {
                extDependencies = extractor.getExternalDependencies();
            }
            catch (Exception e) {
                return new ReturnCode(2, "readDepsError", e.getMessage());
            }
            String dependenciesDesc = extDependencies.getDescription();
            List allDependencies = extDependencies.getDependencies();
            boolean enableDependencyDownload = false;
            if (!downloadDependencies) {
                StringBuilder printableDepsList = new StringBuilder();
                printableDepsList.append(dependenciesDesc).append("\n");
                for (int i = 0; i < allDependencies.size(); ++i) {
                    SelfExtractor.ExternalDependency dependency = (SelfExtractor.ExternalDependency)allDependencies.get(i);
                    printableDepsList.append(dependency.getSourceUrl()).append("\n");
                }
                printableDepsList.append("\n");
                SelfExtract.out("externalDepsInstruction", printableDepsList.toString());
                enableDependencyDownload = SelfExtract.getResponse(SelfExtract.format("externalDepsPrompt", new Object[]{"[1]", "[2]"}), "1", "2", "1");
            } else {
                enableDependencyDownload = true;
            }
            extractor.setDoExternalDepsDownload(enableDependencyDownload);
        }
        return ReturnCode.OK;
    }

    public static String format(String key) {
        return SelfExtract.format(key, new Object[0]);
    }

    public static String format(String key, Object o) {
        return SelfExtract.format(key, new Object[]{o});
    }

    public static String format(String key, Object[] args) {
        return MessageFormat.format(resourceBundle.getString(key), args);
    }

    public static void wordWrappedOut(String fullLine) {
        List lines = SelfExtractUtils.wordWrap(fullLine, null);
        for (int i = 0; i < lines.size(); ++i) {
            System.out.println(lines.get(i));
        }
        System.out.flush();
        System.out.println();
    }

    public static void out(String key) {
        SelfExtract.out(key, new Object[0]);
    }

    public static void out(String key, Object o) {
        SelfExtract.out(key, new Object[]{o});
    }

    public static void out(String key, Object[] args) {
        System.out.println(SelfExtract.format(key, args));
    }

    public static void err(String key) {
        SelfExtract.err(key, new Object[0]);
    }

    public static void err(String key, Object o) {
        SelfExtract.err(key, new Object[]{o});
    }

    public static void err(String key, Object[] args) {
        System.err.println(SelfExtract.format(key, args));
    }

    public static BufferedReader in() {
        if (in == null) {
            in = new BufferedReader(new InputStreamReader(System.in));
        }
        return in;
    }

    public static String getResponse(String promptString) {
        String input = null;
        System.out.print(promptString);
        try {
            input = SelfExtract.in().readLine();
        }
        catch (IOException ioe) {
            SelfExtract.err("inputException", ioe.getMessage());
        }
        if (input == null) {
            System.exit(3);
        }
        return input;
    }

    public static boolean getResponse(String promptString, String yes, String no) {
        return SelfExtract.getResponse(promptString, yes, no, null);
    }

    public static boolean getResponse(String promptString, String yes, String no, String defaultValue) {
        promptString = promptString + " ";
        String input = null;
        while (true) {
            if ((input = SelfExtract.getResponse(promptString)).length() == 0) {
                if (defaultValue != null) {
                    input = defaultValue;
                } else {
                    if (yes.length() == 0) {
                        return true;
                    }
                    if (no.length() == 0) {
                        return false;
                    }
                }
            }
            if (input.length() != 1) continue;
            if (yes.indexOf(input.charAt(0)) > -1) {
                return true;
            }
            if (no.indexOf(input.charAt(0)) > -1) break;
        }
        return false;
    }

    public static void setAcceptLicense(boolean b) {
        acceptLicense = b;
    }

    public static void setVerbose(boolean b) {
        verbose = b;
    }

    public static void setDownloadDependencies(boolean b) {
        downloadDependencies = b;
    }

    public static void setTargetString(String string) {
        targetString = string;
    }

    public static void showLicenseFile(InputStream licenseFile) {
        SelfExtractor.buildInstance();
        SelfExtractor extractor = SelfExtractor.getInstance();
        extractor.showLicenseFile(licenseFile);
    }

    public static void handleLicenseAcceptance(LicenseProvider licenseProvider, boolean acceptLicense) {
        SelfExtractor.buildInstance();
        SelfExtractor extractor = SelfExtractor.getInstance();
        extractor.handleLicenseAcceptance(licenseProvider, acceptLicense);
    }

    static {
        acceptLicense = false;
        downloadDependencies = false;
        verbose = false;
        targetString = null;
        extractor = null;
        createExtractor_rc = null;
        extractorCreated = false;
    }

    public static final class VerboseExtractProgress
    implements ExtractProgress {
        @Override
        public void extractedFile(String f) {
            System.out.println("\t" + f);
        }

        @Override
        public void downloadingFile(URL sourceUrl, File targetFile) {
            SelfExtract.out("downloadingFileNotice", new Object[]{sourceUrl.toString(), targetFile.getAbsolutePath()});
        }

        @Override
        public void dataDownloaded(int numBytes) {
        }

        @Override
        public void setFilesToExtract(int count) {
        }

        @Override
        public void commandRun(List args) {
            StringBuffer cmdString = new StringBuffer();
            for (int i = 0; i < args.size(); ++i) {
                cmdString.append(args.get(i)).append(' ');
            }
            cmdString.setLength(cmdString.length() - 1);
            System.out.println(cmdString);
        }

        @Override
        public void commandsToRun(int count) {
        }

        @Override
        public boolean isCanceled() {
            return false;
        }

        @Override
        public void skippedFile() {
        }
    }
}

