/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.feature.resolver;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.feature.ProcessType;
import com.ibm.ws.kernel.feature.provisioning.ProvisioningFeatureDefinition;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.osgi.framework.Version;

public interface FeatureResolver {
    public Result resolveFeatures(Repository var1, Collection<String> var2, Set<String> var3, boolean var4);

    public Result resolveFeatures(Repository var1, Collection<ProvisioningFeatureDefinition> var2, Collection<String> var3, Set<String> var4, boolean var5);

    public Result resolveFeatures(Repository var1, Collection<ProvisioningFeatureDefinition> var2, Collection<String> var3, Set<String> var4, boolean var5, EnumSet<ProcessType> var6);

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    public static class Chain {
        private final List<String> _chain;
        private final List<String> _candidates;
        private final Version _preferredVersion;
        private final String _originalFeatureReq;
        static final long serialVersionUID = 4983334118172601695L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public Chain(Collection<String> chain, List<String> candidates, String preferredVersion, String originalFeatureReq) {
            Version v;
            this._chain = chain.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<String>(chain));
            this._candidates = Collections.unmodifiableList(candidates);
            try {
                v = Version.parseVersion((String)preferredVersion);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                FFDCFilter.processException((Throwable)illegalArgumentException, (String)"com.ibm.ws.kernel.feature.resolver.FeatureResolver$Chain", (String)"149", (Object)this, (Object[])new Object[]{chain, candidates, preferredVersion, originalFeatureReq});
                v = Version.emptyVersion;
            }
            this._preferredVersion = v;
            this._originalFeatureReq = originalFeatureReq;
        }

        public List<String> getChain() {
            return this._chain;
        }

        public List<String> getCandidates() {
            return this._candidates;
        }

        public Version getPreferredVersion() {
            return this._preferredVersion;
        }

        public String getFeatureRequirement() {
            return this._originalFeatureReq;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("ROOT->");
            for (String featureName : this._chain) {
                builder.append(featureName).append("->");
            }
            builder.append(this._candidates);
            builder.append(" ").append(this._preferredVersion);
            return builder.toString();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(Chain.class);
        }
    }

    public static interface Result {
        public Set<String> getResolvedFeatures();

        public Set<String> getMissing();

        public Set<String> getNonPublicRoots();

        public Map<String, Collection<Chain>> getConflicts();

        public Map<String, Chain> getWrongProcessTypes();

        public boolean hasErrors();
    }

    public static interface Repository {
        public Collection<ProvisioningFeatureDefinition> getAutoFeatures();

        public ProvisioningFeatureDefinition getFeature(String var1);

        public List<String> getConfiguredTolerates(String var1);
    }
}

