/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.instrument.serialfilter.validators;

import com.ibm.ws.kernel.instrument.serialfilter.config.Config;
import com.ibm.ws.kernel.instrument.serialfilter.util.MessageUtil;
import com.ibm.ws.kernel.instrument.serialfilter.validators.ClassValidator;
import java.io.InvalidClassException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;

class EnforcingClassValidator
extends ClassValidator {
    private final Logger log;
    private final Class<?>[] skipOnce = new Class[]{null};
    private final Config config;

    EnforcingClassValidator(Config config) {
        this.config = config;
        this.log = Logger.getLogger(EnforcingClassValidator.class.getName());
    }

    @Override
    protected Class<?> apply(Class<?> cls) throws InvalidClassException {
        if (cls == null) {
            return null;
        }
        if (cls.isArray()) {
            return cls;
        }
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest(String.format("log Validating class - loaded by [%s] with name [%s]%n", EnforcingClassValidator.getLoader(cls), cls.getName()));
        }
        if (this.config.allows(cls, this.skipOnce)) {
            return cls;
        }
        throw new InvalidClassException(MessageUtil.format("SF_ERROR_NOT_ON_WHITELIST", cls.getName()));
    }

    private static ClassLoader getLoader(final Class<?> cls) {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return cls.getClassLoader();
            }
        });
    }
}

