/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.instrument.serialfilter.validators;

import com.ibm.ws.kernel.instrument.serialfilter.config.Config;
import com.ibm.ws.kernel.instrument.serialfilter.validators.ClassValidator;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

class DiscoveringClassValidator
extends ClassValidator {
    private final Logger log;
    private static final AtomicInteger NEXT_INT = new AtomicInteger(1);
    private final Class<?>[] skipOnce = new Class[]{null};
    private final int id = NEXT_INT.getAndIncrement();
    private final Config config;

    DiscoveringClassValidator(Config config) {
        this.config = config;
        this.log = Logger.getLogger(DiscoveringClassValidator.class.getName());
    }

    @Override
    public Class<?> apply(Class<?> cls) {
        boolean whitelisted;
        if (cls == null) {
            return null;
        }
        if (cls.isArray()) {
            return cls;
        }
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest(String.format("Discovering. Class name : %s ClassLoader name : %s", cls.getName(), DiscoveringClassValidator.getLoader(cls)));
        }
        if (whitelisted = this.config.allows(cls, this.skipOnce, true)) {
            return cls;
        }
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest(String.format("The class is not on the whitelist. Class name : %s ClassLoader name : %s", cls.getName(), DiscoveringClassValidator.getLoader(cls)));
        }
        return cls;
    }

    private static ClassLoader getLoader(final Class<?> cls) {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return cls.getClassLoader();
            }
        });
    }

    @Override
    public void reset() {
        this.skipOnce[0] = null;
    }
}

