/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.instrument.serialfilter.util.trie;

import com.ibm.ws.kernel.instrument.serialfilter.util.trie.ChildNode;
import com.ibm.ws.kernel.instrument.serialfilter.util.trie.Trie;
import java.util.Map;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicReference;

abstract class Node<T>
extends AtomicReference<T> {
    final ConcurrentNavigableMap<Character, ChildNode<T>> children = new ConcurrentSkipListMap<Character, ChildNode<T>>();

    Node() {
    }

    abstract int depth();

    final ChildNode<T> getOrCreateChildNode(String key) {
        char c = key.charAt(this.depth());
        ChildNode result = (ChildNode)this.children.get(Character.valueOf(c));
        if (result != null) {
            return result;
        }
        ChildNode newChild = new ChildNode(this, key);
        result = this.children.putIfAbsent(Character.valueOf(c), newChild);
        return result == null ? newChild : result;
    }

    final ChildNode<T> getChildNode(String key) {
        char c = key.charAt(this.depth());
        return (ChildNode)this.children.get(Character.valueOf(c));
    }

    final ChildNode<T> firstChild() {
        Map.Entry e = this.children.firstEntry();
        return e == null ? null : (ChildNode)e.getValue();
    }

    abstract Node<T> getParent();

    abstract ChildNode<T> nextSibling();

    abstract String getStringSoFar();

    final Trie.Entry<T> getEntry() {
        Object t = this.get();
        return t == null ? null : new EntryImpl(t);
    }

    private final class EntryImpl
    implements Trie.Entry<T> {
        private volatile T t;

        EntryImpl(T t) {
            this.t = t;
        }

        @Override
        public String getKey() {
            return Node.this.getStringSoFar();
        }

        @Override
        public T getValue() {
            return this.t;
        }

        @Override
        public T setValue(T t) {
            this.t = t;
            return Node.this.getAndSet(this.t);
        }

        @Override
        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (!(other instanceof Map.Entry)) {
                return false;
            }
            Map.Entry that = (Map.Entry)other;
            return this.getKey().equals(that.getKey()) && this.t.equals(that.getValue());
        }

        @Override
        public int hashCode() {
            return this.getKey().hashCode() ^ this.t.hashCode();
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }
}

