/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.instrument.serialfilter.util.trie;

import com.ibm.ws.kernel.instrument.serialfilter.util.trie.ChildNode;
import com.ibm.ws.kernel.instrument.serialfilter.util.trie.Node;
import com.ibm.ws.kernel.instrument.serialfilter.util.trie.RootNode;
import com.ibm.ws.kernel.instrument.serialfilter.util.trie.Trie;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

public class ConcurrentTrie<V>
extends AbstractMap<String, V>
implements Trie<V>,
Iterable<Map.Entry<String, V>> {
    private static final Node<Void> EMPTY_NODE = new RootNode<Void>();
    private final Node<V> root;

    private ConcurrentTrie(Node<V> root) {
        this.root = root;
    }

    public ConcurrentTrie() {
        this(new RootNode());
    }

    private Node<V> getOrCreateNode(String key) {
        if (key.isEmpty()) {
            return this.root;
        }
        ChildNode<Object> childNode = this.root.getOrCreateChildNode(key);
        while (childNode.depth() < key.length()) {
            childNode = childNode.getOrCreateChildNode(key);
        }
        return childNode;
    }

    private Node<V> getLongestPrefixNode(String key) {
        Node<V> closest = this.root;
        Node<V> n = this.root;
        while (n.depth() < key.length() && (n = n.getChildNode(key)) != null) {
            if (n.get() == null) continue;
            closest = n;
        }
        return closest;
    }

    private AtomicReference<? extends V> getEffectiveNode(String key) {
        Node<V> n = this.root;
        while (n.depth() < key.length()) {
            if ((n = n.getChildNode(key)) != null) continue;
            return ConcurrentTrie.emptyNode();
        }
        return n;
    }

    private static <T> Node<? extends T> emptyNode() {
        return EMPTY_NODE;
    }

    @Override
    public V put(String key, V v) {
        return this.getOrCreateNode(key).getAndSet(v);
    }

    public V remove(String key) {
        return this.getEffectiveNode(key).getAndSet(null);
    }

    public V get(String key) {
        return this.getEffectiveNode(key).get();
    }

    @Override
    public V getLongestPrefixValue(String key) {
        return this.getLongestPrefixNode(key).get();
    }

    @Override
    public Trie.Entry<V> getLongestPrefixEntry(String key) {
        return this.getLongestPrefixNode(key).getEntry();
    }

    @Override
    public boolean isEmpty() {
        return !this.iterator().hasNext();
    }

    @Override
    public V get(Object key) {
        return key instanceof String ? (V)this.get((String)key) : null;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public V remove(Object key) {
        return key instanceof String ? (V)this.remove((String)key) : null;
    }

    @Override
    public Iterator<Map.Entry<String, V>> iterator() {
        return new TrieIterator();
    }

    @Override
    public Set<Map.Entry<String, V>> entrySet() {
        return new EntrySet();
    }

    private class TrieIterator
    implements Iterator<Map.Entry<String, V>> {
        Node<V> node;
        Map.Entry<String, V> prev;
        Map.Entry<String, V> next;

        private TrieIterator() {
            this.node = ConcurrentTrie.this.root;
        }

        @Override
        public synchronized boolean hasNext() {
            return this.next != null || this.findNextValue();
        }

        @Override
        public synchronized Map.Entry<String, V> next() {
            if (this.hasNext()) {
                this.prev = this.next;
                this.next = null;
                return this.prev;
            }
            throw new NoSuchElementException();
        }

        private boolean findNextValue() {
            do {
                if (this.hasCompleted()) {
                    return false;
                }
                this.next = this.node.getEntry();
                this.advanceNode();
            } while (this.next == null);
            return true;
        }

        boolean hasCompleted() {
            return this.node == null;
        }

        private void advanceNode() {
            Node p;
            ChildNode n = p.firstChild();
            for (p = this.node; n == null && p != null; p = p.getParent()) {
                n = p.nextSibling();
            }
            this.node = n;
        }

        @Override
        public synchronized void remove() {
            if (this.prev == null) {
                throw new IllegalStateException();
            }
            this.prev.setValue(null);
            this.prev = null;
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<String, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<String, V>> iterator() {
            return new TrieIterator();
        }

        @Override
        public int size() {
            int i = 0;
            for (Map.Entry o : this) {
                ++i;
            }
            return i;
        }
    }
}

