/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.instrument.serialfilter.util;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Deque;
import java.util.LinkedList;

public class CallStackWalker {
    private static final StackIntrospector SI = StackIntrospector.newInstance();
    private final Deque<Class<?>> classes = new LinkedList<Class>(Arrays.asList(SI.getClassContext()));
    private final Deque<StackTraceElement> elements = new LinkedList<StackTraceElement>(Arrays.asList(new Throwable().getStackTrace()));

    private CallStackWalker() {
        while (this.classes.size() > 0 && this.classes.peek() != CallStackWalker.class) {
            this.classes.pop();
        }
        while (this.classes.size() > 0 && this.classes.peek() == CallStackWalker.class) {
            this.classes.pop();
        }
        String name = CallStackWalker.class.getName();
        while (this.elements.size() > 0 && !name.equals(this.elements.peek().getClassName())) {
            this.elements.pop();
        }
        while (this.elements.size() > 0 && name.equals(this.elements.peek().getClassName())) {
            this.elements.pop();
        }
        this.skipClasslessStackFrames();
    }

    public static CallStackWalker forCurrentThread() {
        return new CallStackWalker();
    }

    private void skipClasslessStackFrames() {
        if (this.classes.isEmpty()) {
            return;
        }
        while (this.elements.size() > 0 && !this.elements.peek().getClassName().equals(this.classes.peek().getName())) {
            this.elements.pop();
        }
    }

    public CallStackWalker skipTo(Class<?> firstInterestingClass) {
        while (this.size() > 0 && this.topClass() != firstInterestingClass) {
            this.pop();
        }
        return this;
    }

    public boolean isEmpty() {
        return this.classes.isEmpty();
    }

    public int size() {
        return this.classes.size();
    }

    public Class<?> topClass() {
        return this.classes.peek();
    }

    public String topMethod() {
        return this.elements.isEmpty() ? null : this.elements.peek().getMethodName();
    }

    public void pop() {
        this.classes.pop();
        if (!this.classes.isEmpty() && this.classes.peek().getName().contains("$$Lambda$")) {
            this.classes.pop();
        }
        if (this.elements.isEmpty()) {
            return;
        }
        this.elements.pop();
        this.skipClasslessStackFrames();
    }

    private static final class StackIntrospector
    extends SecurityManager {
        private StackIntrospector() {
        }

        public Class[] getClassContext() {
            return super.getClassContext();
        }

        static StackIntrospector newInstance() {
            return AccessController.doPrivileged(Factory.INSTANCE);
        }

        private static enum Factory implements PrivilegedAction<StackIntrospector>
        {
            INSTANCE;


            @Override
            public StackIntrospector run() {
                return new StackIntrospector();
            }
        }
    }
}

