/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.instrument.serialfilter.util;

import com.ibm.ws.kernel.instrument.serialfilter.util.Encoder;
import java.util.regex.Pattern;

public final class Base64UrlEncoder
extends Enum<Base64UrlEncoder>
implements Encoder {
    public static final /* enum */ Base64UrlEncoder URL_AND_FILENAME_SAFE_ENCODING = new Base64UrlEncoder();
    private static final char[] BASE64URL_CHARS;
    private static final Pattern ENCODED_STRING;
    private static final char PAD_CHAR = '=';
    private static final /* synthetic */ Base64UrlEncoder[] $VALUES;

    public static Base64UrlEncoder[] values() {
        return (Base64UrlEncoder[])$VALUES.clone();
    }

    public static Base64UrlEncoder valueOf(String name) {
        return Enum.valueOf(Base64UrlEncoder.class, name);
    }

    @Override
    public String encode(byte[] bytes) {
        int len = Base64UrlEncoder.getEncodedLength(bytes.length);
        StringBuilder sb = new StringBuilder(len);
        int leftovers = 0;
        block10: for (int i = 0; i < bytes.length; ++i) {
            int b = 0xFF & bytes[i];
            switch (i % 3) {
                case 0: {
                    sb.append(BASE64URL_CHARS[b >>> 2]);
                    leftovers = (b & 3) << 4;
                    continue block10;
                }
                case 1: {
                    sb.append(BASE64URL_CHARS[leftovers | b >>> 4]);
                    leftovers = (b & 0xF) << 2;
                    continue block10;
                }
                case 2: {
                    sb.append(BASE64URL_CHARS[leftovers | b >>> 6]);
                    sb.append(BASE64URL_CHARS[b & 0x3F]);
                }
            }
        }
        switch (bytes.length % 3) {
            case 0: {
                break;
            }
            case 1: {
                sb.append(BASE64URL_CHARS[leftovers]).append('=').append('=');
                break;
            }
            case 2: {
                sb.append(BASE64URL_CHARS[leftovers]).append('=');
            }
        }
        assert (sb.length() == len);
        return sb.toString();
    }

    public static int getEncodedLength(int numBytes) {
        return (numBytes + 2) / 3 * 4;
    }

    public static boolean isEncodedString(String s) {
        return ENCODED_STRING.matcher(s).matches();
    }

    static {
        $VALUES = new Base64UrlEncoder[]{URL_AND_FILENAME_SAFE_ENCODING};
        BASE64URL_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_".toCharArray();
        ENCODED_STRING = Pattern.compile("([A-Za-z0-9\\-_]{4})*([A-Za-z0-9\\-_]{2}==|[A-Za-z0-9\\-_]{3}=)?");
    }
}

