/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.instrument.serialfilter.digest;

import com.ibm.ws.kernel.instrument.serialfilter.digest.Digester;
import com.ibm.ws.kernel.instrument.serialfilter.digest.DigesterSortedMap;
import com.ibm.ws.kernel.instrument.serialfilter.util.Base64UrlEncoder;
import com.ibm.ws.kernel.instrument.serialfilter.util.MessageUtil;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import org.objectweb.asm.Type;

class Processor {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private MessageDigest md = Processor.newMessageDigest();
    private byte[] digest;

    Processor() {
    }

    static MessageDigest newMessageDigest() {
        try {
            return MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnsupportedOperationException(MessageUtil.format("SF_ERROR_NO_SHA_SUPPORT", e));
        }
    }

    Processor consider(Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            this.md.update(entry.getKey().getBytes(UTF_8));
            Object value = entry.getValue();
            if (value == null) continue;
            Updater.forValue(value).update(this.md, value);
        }
        return this;
    }

    void considerValue(Object value) {
        Updater.forValue(value).update(this.md, value);
    }

    <D extends Digester> Processor consider(DigesterSortedMap<D> hashers) {
        for (Map.Entry<String, D> entry : hashers) {
            this.consider(entry.getKey()).consider((Digester)entry.getValue());
        }
        return this;
    }

    private void consider(Digester digester) {
        Updater.updateBytes(this.md, digester.getDigest());
    }

    Processor consider(int i) {
        Updater.updateInt(this.md, i);
        return this;
    }

    Processor consider(String string) {
        Updater.updateString(this.md, string);
        return this;
    }

    Processor consider(String ... strings) {
        Updater.updateStrings(this.md, strings);
        return this;
    }

    byte[] getDigest() {
        if (this.digest == null) {
            this.digest = this.md.digest();
            this.md = null;
        }
        return this.digest;
    }

    String getDigestAsString() {
        return Base64UrlEncoder.URL_AND_FILENAME_SAFE_ENCODING.encode(this.getDigest());
    }

    static enum Updater {
        NULL(null){

            @Override
            void update(MessageDigest md, Object o) {
            }
        }
        ,
        BOOLEAN((Class)Boolean.class){

            @Override
            void update(MessageDigest md, Object o) {
                Updater.updateBoolean(md, (Boolean)o);
            }
        }
        ,
        BYTE((Class)Byte.class){

            @Override
            void update(MessageDigest md, Object o) {
                Updater.updateByte(md, (Byte)o);
            }
        }
        ,
        CHAR((Class)Character.class){

            @Override
            void update(MessageDigest md, Object o) {
                Updater.updateChar(md, ((Character)o).charValue());
            }
        }
        ,
        SHORT((Class)Short.class){

            @Override
            void update(MessageDigest md, Object o) {
                Updater.updateShort(md, (Short)o);
            }
        }
        ,
        INT((Class)Integer.class){

            @Override
            void update(MessageDigest md, Object o) {
                Updater.updateInt(md, (Integer)o);
            }
        }
        ,
        LONG((Class)Long.class){

            @Override
            void update(MessageDigest md, Object o) {
                Updater.updateLong(md, (Long)o);
            }
        }
        ,
        FLOAT((Class)Float.class){

            @Override
            void update(MessageDigest md, Object o) {
                Updater.updateFloat(md, ((Float)o).floatValue());
            }
        }
        ,
        DOUBLE((Class)Double.class){

            @Override
            void update(MessageDigest md, Object o) {
                Updater.updateDouble(md, (Double)o);
            }
        }
        ,
        BOOLEAN_ARR((Class)Boolean[].class){

            @Override
            void update(MessageDigest md, Object o) {
                Updater.updateBooleans(md, (boolean[])o);
            }
        }
        ,
        BYTE_ARR((Class)byte[].class){

            @Override
            void update(MessageDigest md, Object o) {
                Updater.updateBytes(md, (byte[])o);
            }
        }
        ,
        CHAR_ARR((Class)char[].class){

            @Override
            void update(MessageDigest md, Object o) {
                Updater.updateChars(md, (char[])o);
            }
        }
        ,
        SHORT_ARR((Class)short[].class){

            @Override
            void update(MessageDigest md, Object o) {
                Updater.updateShorts(md, (short[])o);
            }
        }
        ,
        INT_ARR((Class)int[].class){

            @Override
            void update(MessageDigest md, Object o) {
                Updater.updateInts(md, (int[])o);
            }
        }
        ,
        LONG_ARR((Class)long[].class){

            @Override
            void update(MessageDigest md, Object o) {
                Updater.updateLongs(md, (long[])o);
            }
        }
        ,
        FLOAT_ARR((Class)float[].class){

            @Override
            void update(MessageDigest md, Object o) {
                Updater.updateFloats(md, (float[])o);
            }
        }
        ,
        DOUBLE_ARR((Class)double[].class){

            @Override
            void update(MessageDigest md, Object o) {
                Updater.updateDoubles(md, (double[])o);
            }
        }
        ,
        STRING((Class)String.class){

            @Override
            void update(MessageDigest md, Object o) {
                Updater.updateString(md, (String)o);
            }
        }
        ,
        STRING_ARR((Class)String[].class){

            @Override
            void update(MessageDigest md, Object o) {
                Updater.updateStrings(md, (String[])o);
            }
        }
        ,
        TYPE((Class)Type.class){

            @Override
            void update(MessageDigest md, Object o) {
                Updater.updateString(md, o.toString());
            }
        }
        ,
        DEFAULT(null){

            @Override
            void update(MessageDigest md, Object o) {
                throw new IllegalArgumentException("Map contains value of unexpected type: " + o.getClass() + " - value = " + o);
            }
        };

        private static final Map<Class<?>, Updater> LOOKUP_TABLE;
        final Class<?> type;

        static Updater forValue(Object o) {
            if (o == null) {
                return NULL;
            }
            Updater result = LOOKUP_TABLE.get(o.getClass());
            return result == null ? DEFAULT : result;
        }

        private Updater(Class<?> type) {
            this.type = type;
        }

        abstract void update(MessageDigest var1, Object var2);

        private static void updateBoolean(MessageDigest md, boolean val) {
            md.update(val ? (byte)-1 : 0);
        }

        private static void updateByte(MessageDigest md, byte val) {
            md.update(val);
        }

        private static void updateChar(MessageDigest md, char val) {
            md.update((byte)val);
            md.update((byte)(val >>> 8));
        }

        private static void updateShort(MessageDigest md, short val) {
            md.update((byte)val);
            md.update((byte)(val >>> 8));
        }

        private static void updateInt(MessageDigest md, int val) {
            md.update((byte)val);
            md.update((byte)(val >>> 8));
            md.update((byte)(val >>> 16));
            md.update((byte)(val >>> 24));
        }

        private static void updateLong(MessageDigest md, long val) {
            md.update((byte)val);
            md.update((byte)(val >>> 8));
            md.update((byte)(val >>> 16));
            md.update((byte)(val >>> 24));
            md.update((byte)(val >>> 32));
            md.update((byte)(val >>> 40));
            md.update((byte)(val >>> 48));
            md.update((byte)(val >>> 56));
        }

        private static void updateFloat(MessageDigest md, float val) {
            Updater.updateInt(md, Float.floatToIntBits(val));
        }

        private static void updateDouble(MessageDigest md, double val) {
            Updater.updateLong(md, Double.doubleToLongBits(val));
        }

        private static void updateBooleans(MessageDigest md, boolean[] elems) {
            for (boolean elem : elems) {
                Updater.updateBoolean(md, elem);
            }
        }

        private static void updateBytes(MessageDigest md, byte[] elems) {
            md.update(elems);
        }

        private static void updateChars(MessageDigest md, char[] elems) {
            for (char elem : elems) {
                Updater.updateChar(md, elem);
            }
        }

        private static void updateShorts(MessageDigest md, short[] elems) {
            for (short elem : elems) {
                Updater.updateShort(md, elem);
            }
        }

        private static void updateInts(MessageDigest md, int[] elems) {
            for (int elem : elems) {
                Updater.updateInt(md, elem);
            }
        }

        private static void updateLongs(MessageDigest md, long[] elems) {
            for (long elem : elems) {
                Updater.updateLong(md, elem);
            }
        }

        private static void updateFloats(MessageDigest md, float[] elems) {
            for (float elem : elems) {
                Updater.updateFloat(md, elem);
            }
        }

        private static void updateDoubles(MessageDigest md, double[] elems) {
            for (double elem : elems) {
                Updater.updateDouble(md, elem);
            }
        }

        private static void updateString(MessageDigest md, String s) {
            Updater.updateBytes(md, s.getBytes(UTF_8));
        }

        private static void updateStrings(MessageDigest md, String[] elems) {
            for (String elem : elems) {
                Updater.updateString(md, elem);
            }
        }

        static {
            LOOKUP_TABLE = new HashMap();
            for (Updater updater : Updater.values()) {
                if (updater.type == null) continue;
                LOOKUP_TABLE.put(updater.type, updater);
            }
        }
    }
}

