/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.instrument.serialfilter.digest;

import com.ibm.ws.kernel.instrument.serialfilter.digest.ClassDigester;
import com.ibm.ws.kernel.instrument.serialfilter.digest.Processor;
import com.ibm.ws.kernel.instrument.serialfilter.util.Base64UrlEncoder;
import java.io.IOException;
import java.io.InputStream;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

public enum Checksums {
    INSTANCE;

    private static final int CHECKSUM_LENGTH;

    public static Checksums getInstance() {
        return INSTANCE;
    }

    public String forClass(Class<?> cls) throws IOException {
        String resourceName = cls.getName().replaceFirst(".*\\.", "") + ".class";
        InputStream in = cls.getResourceAsStream(resourceName);
        ClassReader reader = new ClassReader(in);
        ClassDigester cd = new ClassDigester();
        reader.accept((ClassVisitor)cd, 6);
        return cd.getDigestAsString();
    }

    public static boolean isValidChecksum(String checksum) {
        return checksum.length() == CHECKSUM_LENGTH && Base64UrlEncoder.isEncodedString(checksum);
    }

    static {
        CHECKSUM_LENGTH = Base64UrlEncoder.getEncodedLength(Processor.newMessageDigest().getDigestLength());
    }
}

