/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.instrument.serialfilter.config;

import com.ibm.ws.kernel.instrument.serialfilter.digest.Checksums;
import java.util.logging.Logger;

enum SpecifierFormat {
    PREFIX,
    CLASS,
    DIGEST,
    METHOD,
    METHOD_PREFIX,
    UNKNOWN;

    static final char DIGEST_DELIM_CHAR = ':';
    static final char METHOD_DELIM_CHAR = '#';
    static final char INTERNAL_END_CHAR = '!';
    static final char WILDCARD_CHAR = '*';
    static final String DIGEST_DELIM = ":";
    static final String METHOD_DELIM = "#";
    static final String INTERNAL_DIGEST_DELIM = "!:";
    static final String INTERNAL_METHOD_DELIM = "!#";

    static String internalize(String s) {
        int endIndex;
        block4: for (int i = 0; i < s.length(); ++i) {
            switch (s.charAt(i)) {
                case ':': {
                    return s.substring(0, i) + '!' + s.substring(i);
                }
                case '#': {
                    s = s.substring(0, i) + '!' + s.substring(i);
                    break block4;
                }
                default: {
                    continue block4;
                }
            }
        }
        return s.charAt(endIndex = s.length() - 1) == '*' ? s.substring(0, endIndex) : s + '!';
    }

    static String externalize(String s) {
        int endIndex;
        block3: for (int i = 0; i < s.length() - 1; ++i) {
            switch (s.charAt(i)) {
                case '!': {
                    s = s.substring(0, i) + s.substring(i + 1);
                    if (s.charAt(i) != ':') break block3;
                    return s;
                }
                default: {
                    continue block3;
                }
            }
        }
        return (endIndex = s.length() - 1) >= 0 && s.charAt(endIndex) == '!' ? s.substring(0, endIndex) : s + '*';
    }

    static SpecifierFormat fromString(String s) {
        if (s.isEmpty()) {
            return UNKNOWN;
        }
        ParseState state = ParseState.BEFORE_IDENTIFIER;
        try {
            int offset = 0;
            while (offset < s.length() && !state.isTerminal) {
                int cp = s.codePointAt(offset);
                state = state.getNextState(cp);
                state.lookAhead(s, offset += Character.charCount(cp));
            }
            return state.format;
        }
        catch (ParseException e) {
            return UNKNOWN;
        }
    }

    private static class ParseException
    extends Exception {
        private ParseException() {
        }
    }

    private static enum ParseState {
        BEFORE_IDENTIFIER(UNKNOWN, false){

            @Override
            ParseState getNextState(int codepoint) {
                switch (codepoint) {
                    case 42: {
                        return AFTER_PREFIX;
                    }
                }
                return Character.isJavaIdentifierStart(codepoint) ? IN_IDENTIFIER : PARSE_ERROR;
            }
        }
        ,
        IN_IDENTIFIER(CLASS, false){

            @Override
            ParseState getNextState(int codepoint) {
                switch (codepoint) {
                    case 46: {
                        return BEFORE_IDENTIFIER;
                    }
                    case 58: {
                        return BEFORE_DIGEST;
                    }
                    case 42: {
                        return AFTER_PREFIX;
                    }
                    case 35: {
                        return BEFORE_METHOD;
                    }
                }
                return Character.isJavaIdentifierPart(codepoint) ? this : PARSE_ERROR;
            }
        }
        ,
        AFTER_PREFIX(PREFIX, true){

            @Override
            void lookAhead(String s, int offset) throws ParseException {
                if (offset != s.length()) {
                    Logger.getLogger(SpecifierFormat.class.getName()).severe("String contains unexpected content at offset " + offset + ": " + s);
                    throw new ParseException();
                }
            }
        }
        ,
        BEFORE_METHOD(UNKNOWN, false){

            @Override
            ParseState getNextState(int codepoint) {
                switch (codepoint) {
                    case 42: {
                        return AFTER_METHOD_PREFIX;
                    }
                    case 60: {
                        return SPECIAL_METHOD_CLINIT_OR_INIT;
                    }
                }
                return Character.isJavaIdentifierStart(codepoint) ? IN_METHOD : PARSE_ERROR;
            }
        }
        ,
        SPECIAL_METHOD_CLINIT_OR_INIT(UNKNOWN, false){

            @Override
            ParseState getNextState(int codepoint) {
                switch (codepoint) {
                    case 42: {
                        return AFTER_METHOD_PREFIX;
                    }
                    case 99: 
                    case 105: {
                        return SPECIAL_METHOD;
                    }
                }
                return PARSE_ERROR;
            }
        }
        ,
        SPECIAL_METHOD(METHOD, true){

            @Override
            void lookAhead(String s, int offset) throws ParseException {
                String method = s.substring(offset - 2);
                if (method.equals("<clinit>") || method.equals("<init>")) {
                    return;
                }
                throw new ParseException();
            }
        }
        ,
        IN_METHOD(METHOD, false){

            @Override
            ParseState getNextState(int codepoint) {
                switch (codepoint) {
                    case 42: {
                        return AFTER_METHOD_PREFIX;
                    }
                }
                return Character.isJavaIdentifierPart(codepoint) ? IN_METHOD : PARSE_ERROR;
            }
        }
        ,
        AFTER_METHOD_PREFIX(METHOD_PREFIX, true){

            @Override
            void lookAhead(String s, int offset) throws ParseException {
                if (offset != s.length()) {
                    Logger.getLogger(SpecifierFormat.class.getName()).severe("String contains unexpected content at offset " + offset + ": " + s);
                    throw new ParseException();
                }
            }
        }
        ,
        BEFORE_DIGEST(DIGEST, true){

            @Override
            void lookAhead(String s, int offset) throws ParseException {
                String checksum = s.substring(offset);
                if (!Checksums.isValidChecksum(checksum)) {
                    Logger.getLogger(SpecifierFormat.class.getName()).severe("String contains invalid checksum: " + s);
                    throw new ParseException();
                }
            }
        }
        ,
        PARSE_ERROR(UNKNOWN, true){

            @Override
            void lookAhead(String s, int offset) throws ParseException {
                throw new ParseException();
            }
        };

        final SpecifierFormat format;
        final boolean isTerminal;

        private ParseState(SpecifierFormat format, boolean isTerminal) {
            this.format = format;
            this.isTerminal = isTerminal;
        }

        ParseState getNextState(int codepoint) {
            return PARSE_ERROR;
        }

        void lookAhead(String s, int offset) throws ParseException {
        }
    }
}

