/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.instrument.serialfilter.agenthelper;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;

public class PreMainUtil {
    public static final String FACTORY_INIT_PROPERTY = "com.ibm.serialization.validators.factory.instance";
    public static final String KEY_SERIALFILTER_AGENT_ENABLE = "com.ibm.websphere.serialfilter.enable";
    public static final String KEY_SERIALFILTER_AGENT_ACTIVE = "com.ibm.websphere.serialfilter.active";
    public static final String DEBUG_PROPERTY = "com.ibm.websphere.kernel.instrument.serialfilter.debug";
    public static final String MESSAGE_PROPERTY = "com.ibm.websphere.kernel.instrument.serialfilter.message";
    private static final String BETA = "EARLY_ACCESS";
    private static final String PRODUCT_EDITION = "com.ibm.websphere.productEdition";
    private static final String WPI_FILE = "versions/WebSphereApplicationServer.properties";

    public static boolean isDebugEnabled() {
        String value = System.getProperty(DEBUG_PROPERTY);
        return value != null && "true".equalsIgnoreCase(value);
    }

    public static boolean isMessageEnabled() {
        String value = System.getProperty(MESSAGE_PROPERTY);
        return value == null || !"false".equalsIgnoreCase(value);
    }

    public static boolean isBeta() {
        try {
            File wasProductInfoFile = PreMainUtil.getWasProductInfoFile();
            if (PreMainUtil.isDebugEnabled()) {
                System.out.println("WAS Product Info File Location : " + wasProductInfoFile);
            }
            Properties props = new Properties();
            props.load(new FileInputStream(wasProductInfoFile));
            String edition = props.getProperty(PRODUCT_EDITION);
            if (PreMainUtil.isDebugEnabled()) {
                System.out.println("Edition : " + edition);
            }
            return edition != null && BETA.equals(edition);
        }
        catch (URISyntaxException e) {
            return false;
        }
        catch (FileNotFoundException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean isEnableAgentPropertySet() {
        String enableSerialFilter = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(PreMainUtil.KEY_SERIALFILTER_AGENT_ENABLE);
            }
        });
        boolean enabled = "true".equalsIgnoreCase(enableSerialFilter);
        if (PreMainUtil.isDebugEnabled()) {
            System.out.println("Enabling Serial Filter property is set : " + enabled);
        }
        return enabled;
    }

    private static File getWasProductInfoFile() throws URISyntaxException {
        URI installDirUri = PreMainUtil.class.getProtectionDomain().getCodeSource().getLocation().toURI();
        URI wasProductInfoUri = installDirUri.resolve(WPI_FILE);
        return new File(wasProductInfoUri);
    }
}

