/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.instrument.serialfilter.agenthelper;

import com.ibm.ws.kernel.instrument.serialfilter.agenthelper.PreMainUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

public class ObjectInputStreamClassInjector
extends ClassVisitor {
    private static final String FACTORY_FIELD = "serializationValidatorFactory";
    private static final String FACTORY_DESC = "Ljava/util/Map;";
    private static final String FACTORY_SIG = "Ljava/util/Map<Ljava/io/ObjectInputStream;Ljava/util/Map<Ljava/lang/Object;Ljava/lang/Object;>;>;";
    private static final int FACTORY_ACCESS = 9;
    private static final String VALIDATOR_FIELD = "serializationValidator";
    private static final String VALIDATOR_DESC = "Ljava/util/Map;";
    private static final String VALIDATOR_SIG = "Ljava/util/Map<Ljava/lang/Class<*>;Ljava/lang/Class<*>;>;";
    private static final int VALIDATOR_ACCESS = 66;
    private boolean validatorFieldAdded = false;
    private String currentClassName;

    public static Map<?, ?> getConfigMap() {
        final Class<ObjectInputStream> oisc = ObjectInputStream.class;
        return (Map)AccessController.doPrivileged(new PrivilegedAction<Map<?, ?>>(){

            @Override
            public Map<?, ?> run() {
                try {
                    Field factoryField = oisc.getDeclaredField(ObjectInputStreamClassInjector.FACTORY_FIELD);
                    factoryField.setAccessible(true);
                    return (Map)factoryField.get(null);
                }
                catch (NoSuchFieldException e) {
                    if (PreMainUtil.isDebugEnabled()) {
                        System.out.println("Unable to locate field " + oisc.getName() + "." + ObjectInputStreamClassInjector.FACTORY_FIELD + ".");
                    }
                    throw new Error("ObjectInputStream class has not been modified as expected.", e);
                }
                catch (IllegalAccessException e) {
                    if (PreMainUtil.isDebugEnabled()) {
                        System.out.println("Could not access field " + oisc.getName() + "." + ObjectInputStreamClassInjector.FACTORY_FIELD + ".");
                    }
                    throw new Error(e);
                }
                catch (SecurityException e) {
                    if (PreMainUtil.isDebugEnabled()) {
                        System.out.println("Could not access field " + oisc.getName() + "." + ObjectInputStreamClassInjector.FACTORY_FIELD + ". Ensure the code is suitably privileged.");
                    }
                    throw new Error(e);
                }
            }
        });
    }

    public static boolean injectionNeeded() {
        block8: {
            boolean debugEnabled = PreMainUtil.isDebugEnabled();
            InputStream is = String.class.getResourceAsStream("/java/io/ObjectInputStream.class");
            if (is == null) {
                if (debugEnabled) {
                    System.out.println("Could not locate /java/io/ObjectInputStream.class as a resource");
                }
            } else {
                try {
                    ClassReader cr = new ClassReader(is);
                    final HashSet<String> fieldsToLookFor = new HashSet<String>(Arrays.asList(FACTORY_FIELD, VALIDATOR_FIELD));
                    if (debugEnabled) {
                        System.out.println("Searching ObjectInputStream.class bytes for fields: " + fieldsToLookFor);
                    }
                    cr.accept(new ClassVisitor(458752){

                        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
                            if (PreMainUtil.isDebugEnabled()) {
                                System.out.println("Found field '" + name + "' with description '" + desc + "'");
                            }
                            fieldsToLookFor.remove(name);
                            return null;
                        }
                    }, 0);
                    if (fieldsToLookFor.isEmpty()) {
                        if (debugEnabled) {
                            System.out.println("Found all fields already in ObjectInputStream.class");
                        }
                        return false;
                    }
                }
                catch (IOException e) {
                    if (!debugEnabled) break block8;
                    System.out.println("Could not read /java/io/ObjectInputStream.class as a resource");
                }
            }
        }
        return true;
    }

    ObjectInputStreamClassInjector(ClassVisitor cv) {
        super(458752, cv);
    }

    private void addFieldsOnlyOnce() {
        if (this.validatorFieldAdded) {
            return;
        }
        this.cv.visitField(9, FACTORY_FIELD, "Ljava/util/Map;", FACTORY_SIG, null).visitEnd();
        this.cv.visitField(66, VALIDATOR_FIELD, "Ljava/util/Map;", VALIDATOR_SIG, null).visitEnd();
        this.validatorFieldAdded = true;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.currentClassName = name;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        this.addFieldsOnlyOnce();
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if ("<clinit>".equals(name)) {
            return new MakeStaticInitializerAssignField(mv);
        }
        if ("<init>".equals(name)) {
            return new MakeConstructorAssignFieldBeforeReturning(mv);
        }
        if (access == 1 && "()Ljava/lang/Object;".equals(desc) && ("readObject".equals(name) || "readUnshared".equals(name))) {
            return new MakeMethodCallValidatorReset(mv);
        }
        return new MakeMethodValidateResultOfResolveClass(mv);
    }

    public static boolean hasModified(Class<?> clazz) {
        try {
            return clazz.getDeclaredField(VALIDATOR_FIELD) != null;
        }
        catch (NoSuchFieldException e) {
            return false;
        }
    }

    private final class MakeMethodCallValidatorReset
    extends MakeMethodValidateResultOfResolveClass {
        MakeMethodCallValidatorReset(MethodVisitor mv) {
            super(mv);
        }

        public final void visitCode() {
            super.visitCode();
            this.invokeResetOnValidator();
        }

        public final void visitInsn(int opcode) {
            if (176 == opcode) {
                this.invokeResetOnValidator();
            }
            super.visitInsn(opcode);
        }

        private void invokeResetOnValidator() {
            this.mv.visitVarInsn(25, 0);
            this.mv.visitFieldInsn(180, ObjectInputStreamClassInjector.this.currentClassName, ObjectInputStreamClassInjector.VALIDATOR_FIELD, "Ljava/util/Map;");
            this.mv.visitMethodInsn(185, "java/util/Map", "clear", "()V", true);
        }
    }

    private class MakeMethodValidateResultOfResolveClass
    extends MethodVisitor {
        MakeMethodValidateResultOfResolveClass(MethodVisitor mv) {
            super(458752, mv);
        }

        public final void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            super.visitMethodInsn(opcode, owner, name, desc, itf);
            if (182 == opcode && "java/io/ObjectInputStream".equals(owner) && "resolveClass".equals(name)) {
                this.mv.visitVarInsn(25, 0);
                this.mv.visitFieldInsn(180, ObjectInputStreamClassInjector.this.currentClassName, ObjectInputStreamClassInjector.VALIDATOR_FIELD, "Ljava/util/Map;");
                this.mv.visitInsn(95);
                this.mv.visitMethodInsn(185, "java/util/Map", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", true);
                this.mv.visitTypeInsn(192, "java/lang/Class");
            }
        }
    }

    private final class MakeConstructorAssignFieldBeforeReturning
    extends MethodVisitor {
        MakeConstructorAssignFieldBeforeReturning(MethodVisitor mv) {
            super(458752, mv);
        }

        public void visitInsn(int opcode) {
            if (177 == opcode) {
                this.mv.visitVarInsn(25, 0);
                this.mv.visitFieldInsn(178, ObjectInputStreamClassInjector.this.currentClassName, ObjectInputStreamClassInjector.FACTORY_FIELD, "Ljava/util/Map;");
                this.mv.visitVarInsn(25, 0);
                this.mv.visitMethodInsn(185, "java/util/Map", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", true);
                this.mv.visitTypeInsn(192, "java/util/Map");
                this.mv.visitFieldInsn(181, ObjectInputStreamClassInjector.this.currentClassName, ObjectInputStreamClassInjector.VALIDATOR_FIELD, "Ljava/util/Map;");
            }
            super.visitInsn(opcode);
        }
    }

    private final class MakeStaticInitializerAssignField
    extends MethodVisitor {
        MakeStaticInitializerAssignField(MethodVisitor mv) {
            super(458752, mv);
        }

        public void visitCode() {
            super.visitCode();
            this.mv.visitMethodInsn(184, "java/lang/System", "getProperties", "()Ljava/util/Properties;", false);
            this.mv.visitLdcInsn((Object)"com.ibm.serialization.validators.factory.instance");
            this.mv.visitMethodInsn(182, "java/util/Properties", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", false);
            this.mv.visitTypeInsn(192, "java/util/Map");
            this.mv.visitFieldInsn(179, ObjectInputStreamClassInjector.this.currentClassName, ObjectInputStreamClassInjector.FACTORY_FIELD, "Ljava/util/Map;");
        }
    }
}

