/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.session.store.cache;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.ArrayList;
import java.util.Set;
import java.util.TreeSet;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
class SessionInfo {
    private static int CREATION_TIME;
    private static int LAST_ACCESS;
    private static int MAX_INACTIVE_TIME;
    private static int LISTENER_TYPES;
    private static int USER;
    private static int PROP_IDS;
    private static int SIZE;
    private final ArrayList<Object> list;
    static final long serialVersionUID = 8404791299924104509L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    SessionInfo(ArrayList<?> list) {
        this.list = list;
    }

    SessionInfo(long creationTime, int maxInactiveInterval, short listenerCount, String userName) {
        this.list = new ArrayList(SIZE);
        this.list.add(creationTime);
        this.list.add(creationTime);
        this.list.add(maxInactiveInterval);
        this.list.add(listenerCount);
        this.list.add(userName);
        this.list.add(null);
    }

    void addSessionPropertyIds(Set<String> propIdsToAdd) {
        Object o = this.list.get(PROP_IDS);
        if (o instanceof TreeSet) {
            TreeSet propIds = (TreeSet)o;
            propIds.addAll(propIdsToAdd);
        } else {
            this.list.set(PROP_IDS, new TreeSet<String>(propIdsToAdd));
        }
    }

    protected SessionInfo clone() {
        ArrayList newList = (ArrayList)this.list.clone();
        TreeSet propIds = (TreeSet)this.list.get(PROP_IDS);
        if (propIds != null) {
            newList.set(PROP_IDS, propIds.clone());
        }
        return new SessionInfo(newList);
    }

    @Trivial
    ArrayList<Object> getArrayList() {
        return this.list;
    }

    long getCreationTime() {
        return (Long)this.list.get(CREATION_TIME);
    }

    long getLastAccess() {
        return (Long)this.list.get(LAST_ACCESS);
    }

    short getListenerTypes() {
        return (Short)this.list.get(LISTENER_TYPES);
    }

    int getMaxInactiveTime() {
        return (Integer)this.list.get(MAX_INACTIVE_TIME);
    }

    Set<String> getSessionPropertyIds() {
        Object o = this.list.get(PROP_IDS);
        return o instanceof TreeSet ? (TreeSet)o : null;
    }

    String getUser() {
        return (String)this.list.get(USER);
    }

    void removeSessionPropertyIds(Set<String> propIdsToRemove) {
        Object o = this.list.get(PROP_IDS);
        if (o instanceof TreeSet) {
            TreeSet propIds = (TreeSet)o;
            propIds.removeAll(propIdsToRemove);
        }
    }

    void setLastAccess(long time) {
        this.list.set(LAST_ACCESS, time);
    }

    void setListenerTypes(short count) {
        this.list.set(LISTENER_TYPES, count);
    }

    void setMaxInactiveTime(int max) {
        this.list.set(MAX_INACTIVE_TIME, max);
    }

    void setUser(String user) {
        this.list.set(USER, user);
    }

    public String toString() {
        return "SessionInfo for " + this.list.get(USER) + " created " + this.list.get(CREATION_TIME) + " accessed " + this.list.get(LAST_ACCESS) + " listeners " + this.list.get(LISTENER_TYPES) + " maxInactive " + this.list.get(MAX_INACTIVE_TIME) + ' ' + this.list.get(PROP_IDS);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(SessionInfo.class);
        CREATION_TIME = 0;
        LAST_ACCESS = 1;
        MAX_INACTIVE_TIME = 2;
        LISTENER_TYPES = 3;
        USER = 4;
        PROP_IDS = 5;
        SIZE = 6;
    }
}

