/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxws.client.injection;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.javaee.dd.common.wsclient.ServiceRef;
import com.ibm.ws.jaxws.utils.StringUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.injectionengine.InjectionException;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.ws.Service;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class InjectionHelper {
    private static final TraceComponent tc = Tr.register(InjectionHelper.class);
    static final long serialVersionUID = -7313410844894083678L;

    static Class<?> getTypeFromMember(Member member) throws InjectionException {
        Class<?> memberType = null;
        if (member instanceof Field) {
            memberType = ((Field)member).getType();
        } else if (member instanceof Method) {
            Method method = (Method)member;
            if (method.getParameterTypes() == null || method.getParameterTypes().length != 1) {
                String msg = Tr.formatMessage((TraceComponent)tc, (String)"error.service.ref.member.level.annotation.wrong.method.name", (Object[])new Object[]{method.getName(), method.getDeclaringClass().getName()});
                throw new InjectionException(msg);
            }
            memberType = method.getParameterTypes()[0];
        }
        return memberType;
    }

    static List<ServiceRef> normalizeJaxWsServiceRefs(List<ServiceRef> allServiceRefs, ClassLoader classLoader) {
        if (allServiceRefs == null || allServiceRefs.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<ServiceRef> jaxwsServiceRefs = new ArrayList<ServiceRef>(allServiceRefs.size());
        for (ServiceRef serviceRef : allServiceRefs) {
            Class<?> srClass;
            if (serviceRef.getLookupName() != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("The service ref: " + serviceRef.getName() + " specifies lookup-name: " + serviceRef.getLookupName()), (Object[])new Object[0]);
                }
                jaxwsServiceRefs.add(serviceRef);
                continue;
            }
            String srClassName = serviceRef.getServiceInterfaceName();
            if (StringUtils.isEmpty(srClassName)) {
                Tr.warning((TraceComponent)tc, (String)"warn.service.ref.dd.service.interface.not.set", (Object[])new Object[]{serviceRef.getName()});
                continue;
            }
            try {
                srClass = Class.forName(srClassName, false, classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ws.jaxws.client.injection.InjectionHelper", (String)"91", null, (Object[])new Object[]{allServiceRefs, classLoader});
                Tr.warning((TraceComponent)tc, (String)"warn.service.ref.dd.service.interface.class.not.found", (Object[])new Object[]{serviceRef.getName(), srClassName});
                continue;
            }
            if (!Service.class.isAssignableFrom(srClass)) {
                Tr.warning((TraceComponent)tc, (String)"warn.service.ref.dd.service.interface.wrong.value", (Object[])new Object[]{serviceRef.getName(), srClassName});
                continue;
            }
            jaxwsServiceRefs.add(serviceRef);
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)("The service ref: " + serviceRef.getName() + " refers to the service: " + srClassName), (Object[])new Object[0]);
        }
        return jaxwsServiceRefs;
    }
}

