/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.boot.logging;

import com.ibm.ws.kernel.boot.logging.LoggerHandlerManager;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class WsLogManager
extends LogManager {
    private static final String CLASS_NAME = WsLogManager.class.getName();
    private static final String CONFIGURE_BY_SERVER_PROPERTY_NAME = "java.util.logging.configureByServer";
    private static final String CONFIGURE_BY_LOGGING_PROPERTIES_FILE = "java.util.logging.configureByLoggingPropertiesFile";
    private static final boolean configureByServer = "true".equalsIgnoreCase(System.getProperty("java.util.logging.configureByServer", "true"));
    private static final boolean configureByLoggingProperties = "true".equalsIgnoreCase(System.getProperty("java.util.logging.configureByLoggingPropertiesFile"));
    private static volatile Constructor<?> wsLogger;
    private boolean resetEnabled = true;
    private static boolean svBinaryLoggingEnable;

    @Override
    public void readConfiguration() throws IOException, SecurityException {
        if (!configureByServer || configureByLoggingProperties) {
            super.readConfiguration();
        } else {
            LoggerHandlerManager.initialize();
        }
    }

    @Override
    public Logger getLogger(String name) {
        Logger logger = super.getLogger(name);
        if (wsLogger == null) {
            return logger;
        }
        if (logger == null) {
            boolean createNewLogger = false;
            boolean foundCaller = false;
            Exception ex = new Exception();
            StackTraceElement[] ste = ex.getStackTrace();
            Class<?> caller = null;
            int i = 0;
            while (!foundCaller && i < ste.length) {
                StackTraceElement s;
                if (!(s = ste[i++]).getClassName().equals(CLASS_NAME) || !s.getMethodName().equals("getLogger")) continue;
                while (!foundCaller && i < ste.length) {
                    if ((s = ste[i++]).getClassName().equals("java.util.logging.Logger") && s.getMethodName().equals("getLogger")) {
                        createNewLogger = true;
                        continue;
                    }
                    if (!createNewLogger) continue;
                    caller = StackFinderSingleton.instance.getCaller(i, s.getClassName());
                    foundCaller = caller != null;
                }
            }
            if (createNewLogger) {
                try {
                    logger = (Logger)wsLogger.newInstance(name, caller, null);
                    Logger checkLogger = super.getLogger(name);
                    if (checkLogger != null) {
                        logger = checkLogger;
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return logger;
    }

    @Override
    public void reset() throws SecurityException {
        if (this.resetEnabled) {
            super.reset();
        }
    }

    public void enableReset() {
        this.resetEnabled = true;
    }

    public void disableReset() {
        this.resetEnabled = false;
    }

    public boolean isResetEnabled() {
        return this.resetEnabled;
    }

    public static boolean isConfiguredByLoggingProperties() {
        return configureByLoggingProperties;
    }

    public static boolean isBinaryLoggingEnabled() {
        return svBinaryLoggingEnable;
    }

    public static void setBinaryLoggingEnabled(boolean binaryLogEnable) {
        svBinaryLoggingEnable = binaryLogEnable;
    }

    public static void setWsLogger(Class<?> clazz) {
        try {
            Class[] classParams = new Class[]{String.class, Class.class, String.class};
            wsLogger = clazz == null ? null : clazz.getConstructor(classParams);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        svBinaryLoggingEnable = false;
    }

    public static class StackFinder
    extends SecurityManager {
        public Class<?> getCaller(int i, String className) {
            Class<?> aClass = null;
            Class<?>[] stack = this.getClassContext();
            aClass = stack[i];
            if (aClass.getName().equals(className)) {
                return aClass;
            }
            for (Class<?> bClass : stack) {
                String name = bClass.getName();
                if (!name.equals(className)) continue;
                aClass = bClass;
                break;
            }
            return aClass;
        }
    }

    private static class StackFinderSingleton {
        static final StackFinder instance = AccessController.doPrivileged(new PrivilegedAction<StackFinder>(){

            @Override
            public StackFinder run() {
                return new StackFinder();
            }
        });

        private StackFinderSingleton() {
        }
    }
}

