/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.http.dispatcher.internal.HttpDispatcher;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class HttpLocalFormat {
    static final long DEFAULT_TOLERANCE = 1000L;
    static final TimeZone gmt;
    private CachedTime c1123Time = null;
    private CachedTime c1036Time = null;
    private CachedTime cAsciiTime = null;
    private CachedTime cNCSATime = null;
    private CachedTime c2109Time = null;
    static final long serialVersionUID = 4198739767693812748L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    private CachedTime getC1123Time() {
        if (this.c1123Time == null) {
            this.c1123Time = new CachedTime("EEE, dd MMM yyyy HH:mm:ss z", true);
        }
        return this.c1123Time;
    }

    private CachedTime getC1036Time() {
        if (this.c1036Time == null) {
            this.c1036Time = new CachedTime("EEEEEEEEE, dd-MMM-yy HH:mm:ss z", true);
        }
        return this.c1036Time;
    }

    private CachedTime getCAsciiTime() {
        if (this.cAsciiTime == null) {
            this.cAsciiTime = new CachedTime("EEE MMM  d HH:mm:ss yyyy", true);
        }
        return this.cAsciiTime;
    }

    private CachedTime getCNCSATime() {
        if (this.cNCSATime == null) {
            this.cNCSATime = new CachedTime("dd/MMM/yyyy:HH:mm:ss Z", false);
        }
        return this.cNCSATime;
    }

    private CachedTime getC2109Time() {
        if (this.c2109Time == null) {
            this.c2109Time = new CachedTime("EEE, dd-MMM-yy HH:mm:ss z", true);
        }
        return this.c2109Time;
    }

    public byte[] get1123TimeAsBytes(long range) {
        return this.getC1123Time().getTimeAsBytes(range);
    }

    public String get1123TimeAsString(long range) {
        return this.getC1123Time().getTimeAsString(range);
    }

    public byte[] get1036TimeAsBytes(long range) {
        return this.getC1036Time().getTimeAsBytes(range);
    }

    public String get1036TimeAsString(long range) {
        return this.getC1036Time().getTimeAsString(range);
    }

    public byte[] getAsciiTimeAsBytes(long range) {
        return this.getCAsciiTime().getTimeAsBytes(range);
    }

    public String getAsciiTimeAsString(long range) {
        return this.getCAsciiTime().getTimeAsString(range);
    }

    public byte[] getNCSATimeAsBytes(long range) {
        return this.getCNCSATime().getTimeAsBytes(range);
    }

    public String getNCSATimeAsString(long range) {
        return this.getCNCSATime().getTimeAsString(range);
    }

    public byte[] get2109TimeAsBytes(long range) {
        return this.getC2109Time().getTimeAsBytes(range);
    }

    public String get2109TimeAsString(long range) {
        return this.getC2109Time().getTimeAsString(range);
    }

    public SimpleDateFormat get1123Format() {
        return this.getC1123Time().getFormat();
    }

    public SimpleDateFormat get1036Format() {
        return this.getC1036Time().getFormat();
    }

    public SimpleDateFormat getAsciiFormat() {
        return this.getCAsciiTime().getFormat();
    }

    public SimpleDateFormat getNCSAFormat() {
        return this.getCNCSATime().getFormat();
    }

    public SimpleDateFormat get2109Format() {
        return this.getC2109Time().getFormat();
    }

    public SimpleDateFormat get1123Parse() {
        return this.getC1123Time().getParse();
    }

    public SimpleDateFormat get1036Parse() {
        return this.getC1036Time().getParse();
    }

    public SimpleDateFormat getAsciiParse() {
        return this.getCAsciiTime().getParse();
    }

    public SimpleDateFormat getNCSAParse() {
        return this.getCNCSATime().getParse();
    }

    public SimpleDateFormat get2109Parse() {
        return this.getC2109Time().getParse();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(HttpLocalFormat.class);
        gmt = TimeZone.getTimeZone("GMT");
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static class CachedTime {
        private static final byte[] EMPTY_BYTE_ARRAY;
        private static final char[] EMPTY_CHAR_ARRAY;
        private final SimpleDateFormat myFormat;
        private final String pattern;
        private final boolean gmtTimeZone;
        private SimpleDateFormat myParse = null;
        private long lastTimeCheck = 0L;
        private String sTime = null;
        private byte[] baTime = EMPTY_BYTE_ARRAY;
        private char[] caTime = EMPTY_CHAR_ARRAY;
        private final Date myDate = new Date();
        private StringBuffer myBuffer = new StringBuffer(33);
        static final long serialVersionUID = -3126351588685594950L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        CachedTime(String format, boolean gmtTimeZone) {
            this.pattern = format;
            this.gmtTimeZone = gmtTimeZone;
            this.myFormat = new SimpleDateFormat(format, Locale.US);
            if (gmtTimeZone) {
                this.myFormat.setTimeZone(gmt);
            }
        }

        SimpleDateFormat getFormat() {
            return this.myFormat;
        }

        SimpleDateFormat getParse() {
            if (this.myParse == null) {
                this.myParse = new SimpleDateFormat(this.pattern, Locale.US);
                if (this.gmtTimeZone) {
                    this.myParse.setTimeZone(gmt);
                }
            }
            return this.myParse;
        }

        private void updateTime(long tolerance) {
            long now = HttpDispatcher.getApproxTime();
            if (now == this.lastTimeCheck) {
                return;
            }
            if (0L != tolerance) {
                long range;
                long l = range = -1L == tolerance ? 1000L : tolerance;
                if (now - this.lastTimeCheck <= range) {
                    return;
                }
            }
            this.myDate.setTime(now);
            this.myBuffer.setLength(0);
            this.myBuffer = this.myFormat.format(this.myDate, this.myBuffer, new FieldPosition(0));
            int len = this.myBuffer.length();
            if (this.caTime.length != len) {
                this.caTime = new char[len];
                this.baTime = new byte[len];
            }
            this.myBuffer.getChars(0, len, this.caTime, 0);
            for (int i = 0; i < len; ++i) {
                this.baTime[i] = (byte)this.caTime[i];
            }
            this.sTime = null;
            this.lastTimeCheck = now;
        }

        byte[] getTimeAsBytes(long tolerance) {
            this.updateTime(tolerance);
            return this.baTime;
        }

        String getTimeAsString(long tolerance) {
            this.updateTime(tolerance);
            if (null == this.sTime) {
                this.sTime = new String(this.caTime, 0, this.caTime.length);
            }
            return this.sTime;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(CachedTime.class);
            EMPTY_BYTE_ARRAY = new byte[0];
            EMPTY_CHAR_ARRAY = new char[0];
        }
    }
}

