/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.FFDCSelfIntrospectable;
import com.ibm.ws.genericbnf.internal.GenericUtils;
import com.ibm.ws.http.channel.h2internal.Constants;
import com.ibm.ws.http.channel.h2internal.H2HttpInboundLinkWrap;
import com.ibm.ws.http.channel.h2internal.H2StreamProcessor;
import com.ibm.ws.http.channel.h2internal.H2VirtualConnectionImpl;
import com.ibm.ws.http.channel.h2internal.exceptions.CompressionException;
import com.ibm.ws.http.channel.h2internal.exceptions.Http2Exception;
import com.ibm.ws.http.channel.h2internal.frames.Frame;
import com.ibm.ws.http.channel.h2internal.frames.FramePPHeaders;
import com.ibm.ws.http.channel.h2internal.frames.FramePushPromise;
import com.ibm.ws.http.channel.h2internal.hpack.H2HeaderTable;
import com.ibm.ws.http.channel.h2internal.hpack.H2Headers;
import com.ibm.ws.http.channel.h2internal.hpack.HpackConstants;
import com.ibm.ws.http.channel.internal.CancelIOWrapper;
import com.ibm.ws.http.channel.internal.HttpBaseMessageImpl;
import com.ibm.ws.http.channel.internal.HttpChannelConfig;
import com.ibm.ws.http.channel.internal.HttpObjectFactory;
import com.ibm.ws.http.channel.internal.HttpRequestMessageImpl;
import com.ibm.ws.http.channel.internal.HttpResponseMessageImpl;
import com.ibm.ws.http.channel.internal.HttpTrailersImpl;
import com.ibm.ws.http.channel.internal.TrailerCallback;
import com.ibm.ws.http.channel.internal.inbound.HttpInboundLink;
import com.ibm.ws.http.channel.internal.inbound.HttpInboundServiceContextImpl;
import com.ibm.ws.http.dispatcher.internal.HttpDispatcher;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import com.ibm.wsspi.bytebuffer.WsByteBufferUtils;
import com.ibm.wsspi.channelfw.InterChannelCallback;
import com.ibm.wsspi.channelfw.VirtualConnection;
import com.ibm.wsspi.genericbnf.BNFHeaders;
import com.ibm.wsspi.genericbnf.HeaderField;
import com.ibm.wsspi.genericbnf.HeaderKeys;
import com.ibm.wsspi.http.EncodingUtils;
import com.ibm.wsspi.http.HttpDateFormat;
import com.ibm.wsspi.http.channel.HttpRequestMessage;
import com.ibm.wsspi.http.channel.HttpResponseMessage;
import com.ibm.wsspi.http.channel.HttpServiceContext;
import com.ibm.wsspi.http.channel.compression.CompressionHandler;
import com.ibm.wsspi.http.channel.compression.DecompressionHandler;
import com.ibm.wsspi.http.channel.compression.DeflateInputHandler;
import com.ibm.wsspi.http.channel.compression.DeflateOutputHandler;
import com.ibm.wsspi.http.channel.compression.GzipInputHandler;
import com.ibm.wsspi.http.channel.compression.GzipOutputHandler;
import com.ibm.wsspi.http.channel.compression.IdentityInputHandler;
import com.ibm.wsspi.http.channel.error.HttpError;
import com.ibm.wsspi.http.channel.error.HttpErrorPageProvider;
import com.ibm.wsspi.http.channel.error.HttpErrorPageService;
import com.ibm.wsspi.http.channel.exception.BodyCompleteException;
import com.ibm.wsspi.http.channel.exception.IllegalHttpBodyException;
import com.ibm.wsspi.http.channel.exception.MessageTooLargeException;
import com.ibm.wsspi.http.channel.values.ContentEncodingValues;
import com.ibm.wsspi.http.channel.values.HttpHeaderKeys;
import com.ibm.wsspi.http.channel.values.MethodValues;
import com.ibm.wsspi.http.channel.values.StatusCodes;
import com.ibm.wsspi.http.channel.values.TransferEncodingValues;
import com.ibm.wsspi.http.channel.values.VersionValues;
import com.ibm.wsspi.http.logging.DebugLog;
import com.ibm.wsspi.tcpchannel.SSLConnectionContext;
import com.ibm.wsspi.tcpchannel.TCPConnectionContext;
import com.ibm.wsspi.tcpchannel.TCPReadCompletedCallback;
import com.ibm.wsspi.tcpchannel.TCPWriteCompletedCallback;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.zip.DataFormatException;

public abstract class HttpServiceContextImpl
implements HttpServiceContext,
FFDCSelfIntrospectable {
    private static final TraceComponent tc = Tr.register(HttpServiceContextImpl.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
    private static final int NOT_ENOUGH_DATA = -1;
    private static final int NO_MORE_DATA = -1;
    private static final byte[] HEX_BYTES = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    protected static final byte[] CHUNK_TRAILER_DATA = new byte[]{13, 10, 48, 13, 10, 13, 10};
    private static final int PENDING_BUFFER_INITIAL_SIZE = 10;
    private static final int PENDING_BUFFER_MIN_GROWTH_SIZE = 4;
    private static final int STATE_NONE = 0;
    private static final int STATE_FULL_HEADERS = 1;
    private static final int STATE_PARTIAL_BODY = 2;
    private static final int STATE_FULL_MESSAGE = 3;
    private static final int DEFAULT_REMOTE_PORT = 1024;
    private static final int DEFAULT_LOCAL_PORT = 9080;
    private static final ContentEncodingValues DEFAULT_ENCODING = ContentEncodingValues.IDENTITY;
    protected static final String EPS_KEY = "HttpChannel_ErrorPageService_Body";
    private TCPConnectionContext myTSC = null;
    private VirtualConnection myVC = null;
    private InterChannelCallback appWriteCB = null;
    private InterChannelCallback appReadCB = null;
    private WsByteBuffer[] myPendingBuffers = new WsByteBuffer[10];
    private int pendingBufferStart = 0;
    private int pendingBufferStop = 0;
    private WsByteBuffer[] myParseBuffers = null;
    private int parseBufferIndex = -1;
    private boolean bIsJITRead = true;
    private int msgParsedState = 0;
    private int msgSentState = 0;
    private boolean writingHeaders = false;
    private boolean isFinalWrite = false;
    private boolean bIsPersistent = true;
    private boolean bIsPartialBody = false;
    private boolean bIsOutgoingBodyValid = true;
    private boolean bIsIncomingBodyValid = false;
    private boolean bIsRawBody = false;
    private boolean bIsResponseOwner = true;
    private boolean bIsRequestOwner = true;
    private boolean bForceAsync = false;
    private boolean bParsingTrailers = false;
    private long unparsedDataRemaining = -1L;
    private boolean bIsChunked = false;
    private long myContentLength = -1L;
    private TCPReadCompletedCallback myBodyRC = null;
    private final LinkedList<WsByteBuffer> storage = new LinkedList();
    private final LinkedList<WsByteBuffer> tempBuffers = new LinkedList();
    private boolean bIsMultiRead = false;
    private int amountBeingRead = 0;
    private long numBytesWritten = 0L;
    private long incomingMsgSize = 0L;
    private int savedChunkLength = -1;
    private int oldLimit = 0;
    private int oldPosition = -1;
    private boolean shouldModify = true;
    private WsByteBuffer buffChunkHeader = null;
    private WsByteBuffer buffChunkTrailer = null;
    private HttpChannelConfig myChannelConfig = null;
    private int myReadTimeout = 0;
    private int myWriteTimeout = 0;
    private HttpRequestMessageImpl myRequest = null;
    private HttpResponseMessageImpl myResponse = null;
    private WsByteBuffer currentReadBB = null;
    private VersionValues reqVersion = null;
    private MethodValues reqMethod = null;
    private boolean bIsBodyExpected = false;
    private int chunkLengthParseState = 0;
    private ContentEncodingValues incomingMsgEncoding = DEFAULT_ENCODING;
    private ContentEncodingValues outgoingMsgEncoding = DEFAULT_ENCODING;
    private CancelIOWrapper cancelRead = null;
    private CancelIOWrapper cancelWrite = null;
    private InetAddress myRemoteAddr = null;
    private InetAddress myLocalAddr = null;
    private int myRemotePort = 1024;
    private int myLocalPort = 9080;
    private LinkedList<WsByteBuffer> allocatedBuffers = null;
    private int lastHeaderBuffer = -1;
    private CompressionHandler compressHandler = null;
    private DecompressionHandler decompressHandler = null;
    private long responseStartTime = 0L;
    private boolean isPushPromise = false;
    private boolean isH2Connection = false;
    private final CopyOnWriteArrayList<Frame> framesToWrite = new CopyOnWriteArrayList();

    protected HttpServiceContextImpl() {
        this.allocatedBuffers = new LinkedList();
    }

    public final void resetMsgSentState() {
        this.msgSentState = 0;
    }

    public final void resetMsgParsedState() {
        this.msgParsedState = 0;
    }

    protected final boolean isBodyComplete() {
        return 3 == this.msgParsedState;
    }

    private void setBodyComplete() {
        this.msgParsedState = 3;
    }

    public final boolean isPartialBodySendState() {
        return 2 == this.msgSentState;
    }

    @Override
    public final boolean isMessageSent() {
        return 3 == this.msgSentState;
    }

    protected final void setMessageSent() {
        this.msgSentState = 3;
    }

    @Override
    public boolean isIncomingMessageFullyRead() {
        if (!this.storage.isEmpty()) {
            return false;
        }
        if (!this.isBodyComplete()) {
            return !this.isIncomingBodyValid();
        }
        return true;
    }

    public final boolean headersSent() {
        return 1 <= this.msgSentState;
    }

    public boolean writingHeaders() {
        return this.writingHeaders;
    }

    protected final void setHeadersSent() {
        this.msgSentState = 1;
    }

    public final boolean isHeadersSentState() {
        return 1 == this.msgSentState;
    }

    public final boolean headersParsed() {
        return 1 <= this.msgParsedState;
    }

    public final void setHeadersParsed() {
        this.msgParsedState = 1;
    }

    protected boolean incomingBuffersReady() {
        return !this.storage.isEmpty();
    }

    protected final void setBodyRC(TCPReadCompletedCallback rc) {
        this.myBodyRC = rc;
    }

    private TCPReadCompletedCallback getBodyRC() {
        return this.myBodyRC;
    }

    @Override
    public final boolean isPersistent() {
        return this.bIsPersistent;
    }

    public final void setPersistent(boolean flag) {
        this.bIsPersistent = flag;
    }

    @Override
    public boolean isSecure() {
        return null != this.getSSLContext();
    }

    public abstract boolean isInboundConnection();

    private void setIncomingMsgEncoding(ContentEncodingValues val) {
        this.incomingMsgEncoding = val;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Incoming msg encoding: " + val.getName()), (Object[])new Object[0]);
        }
    }

    private void setOutgoingMsgEncoding(ContentEncodingValues val) {
        this.outgoingMsgEncoding = val;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Outgoing msg encoding: " + val.getName()), (Object[])new Object[0]);
        }
    }

    private boolean isOutgoingMsgEncoded() {
        return !DEFAULT_ENCODING.equals(this.outgoingMsgEncoding);
    }

    @Override
    public boolean isZlibEncoded() {
        return ContentEncodingValues.DEFLATE.equals(this.outgoingMsgEncoding);
    }

    @Override
    public boolean setZlibEncoded(boolean flag) {
        if (this.headersSent()) {
            return false;
        }
        if (flag) {
            this.setOutgoingMsgEncoding(ContentEncodingValues.DEFLATE);
        } else if (this.isZlibEncoded()) {
            this.setOutgoingMsgEncoding(DEFAULT_ENCODING);
        }
        return true;
    }

    @Override
    public boolean isZlibEncodingSupported() {
        return true;
    }

    @Override
    public boolean isGZipEncoded() {
        return ContentEncodingValues.GZIP.equals(this.outgoingMsgEncoding);
    }

    @Override
    public boolean setGZipEncoded(boolean flag) {
        if (this.headersSent()) {
            return false;
        }
        if (flag) {
            this.setOutgoingMsgEncoding(ContentEncodingValues.GZIP);
        } else if (this.isGZipEncoded()) {
            this.setOutgoingMsgEncoding(DEFAULT_ENCODING);
        }
        return true;
    }

    @Override
    public boolean isGZipEncodingSupported() {
        return true;
    }

    @Override
    public boolean isXGZipEncoded() {
        return ContentEncodingValues.XGZIP.equals(this.outgoingMsgEncoding);
    }

    @Override
    public boolean setXGZipEncoded(boolean flag) {
        if (this.headersSent()) {
            return false;
        }
        if (flag) {
            this.setOutgoingMsgEncoding(ContentEncodingValues.XGZIP);
        } else if (this.isXGZipEncoded()) {
            this.setOutgoingMsgEncoding(DEFAULT_ENCODING);
        }
        return true;
    }

    @Override
    public boolean isXGZipEncodingSupported() {
        return true;
    }

    protected final boolean isRawBody() {
        return this.bIsRawBody;
    }

    protected final void setRawBody(boolean flag) {
        this.bIsRawBody = flag;
    }

    public final boolean isPartialBody() {
        return this.bIsPartialBody;
    }

    protected final void setPartialBody(boolean flag) {
        this.bIsPartialBody = flag;
    }

    protected final boolean isOutgoingBodyValid() {
        return this.bIsOutgoingBodyValid;
    }

    private void setOutgoingBodyValid(boolean flag) {
        this.bIsOutgoingBodyValid = flag;
    }

    protected final boolean isForceAsync() {
        return this.bForceAsync;
    }

    protected final void setForceAsync(boolean flag) {
        this.bForceAsync = flag;
    }

    protected final boolean isResponseOwner() {
        return this.bIsResponseOwner;
    }

    protected final void setResponseOwner(boolean flag) {
        this.bIsResponseOwner = flag;
    }

    protected final void setMyResponse(HttpResponseMessageImpl msg) {
        this.myResponse = msg;
    }

    protected final HttpResponseMessageImpl getMyResponse() {
        return this.myResponse;
    }

    protected final boolean isRequestOwner() {
        return this.bIsRequestOwner;
    }

    protected final void setRequestOwner(boolean flag) {
        this.bIsRequestOwner = flag;
    }

    protected final void setMyRequest(HttpRequestMessageImpl msg) {
        this.myRequest = msg;
    }

    protected final HttpRequestMessageImpl getMyRequest() {
        return this.myRequest;
    }

    @Override
    public void resetRequestOwnership() {
        if (null != this.getMyRequest()) {
            this.getMyRequest().setOwner(this);
        }
    }

    @Override
    public void resetResponseOwnership() {
        if (null != this.getMyResponse()) {
            this.getMyResponse().setOwner(this);
        }
    }

    private int getChunkLengthParsingState() {
        return this.chunkLengthParseState;
    }

    private void setChunkLengthParsingState(int val) {
        this.chunkLengthParseState = val;
    }

    protected void init(TCPConnectionContext tsc, HttpChannelConfig hcc) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init", (Object[])new Object[0]);
        }
        this.setHttpConfig(hcc);
        if (null != tsc) {
            block5: {
                this.myTSC = tsc;
                try {
                    this.setLocalPort(this.getTSC().getLocalPort());
                    this.setRemotePort(this.getTSC().getRemotePort());
                    this.setLocalAddr(this.getTSC().getLocalAddress());
                    this.setRemoteAddr(this.getTSC().getRemoteAddress());
                }
                catch (Throwable t) {
                    FFDCFilter.processException((Throwable)t, (String)(this.getClass().getName() + ".init"), (String)"1", (Object)this);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block5;
                    Tr.event((TraceComponent)tc, (String)("Received exception from JDK socket calls; " + t), (Object[])new Object[0]);
                }
            }
            this.myReadTimeout = this.getHttpConfig().getReadTimeout();
            this.myWriteTimeout = this.getHttpConfig().getWriteTimeout();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init");
        }
    }

    public void reinit(TCPConnectionContext tcc) {
        block2: {
            this.myTSC = tcc;
            try {
                this.parsingComplete();
            }
            catch (Exception e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)tc, (String)("Exception caught during reinit: " + e), (Object[])new Object[0]);
            }
        }
    }

    public void destroy() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"destroy", (Object[])new Object[0]);
        }
        while (!this.allocatedBuffers.isEmpty()) {
            this.allocatedBuffers.removeFirst().release();
        }
        this.lastHeaderBuffer = -1;
        if (null != this.getMyRequest() && this.isRequestOwner()) {
            this.getMyRequest().destroy();
        }
        this.setMyRequest(null);
        if (null != this.getMyResponse() && this.isResponseOwner()) {
            this.getMyResponse().destroy();
        }
        this.setMyResponse(null);
        this.myTSC = null;
        this.setVC(null);
        this.setAppWriteCallback(null);
        this.setAppReadCallback(null);
        this.releaseReadBuffers();
        if (null != this.buffChunkHeader) {
            this.buffChunkHeader.release();
            this.buffChunkHeader = null;
        }
        if (null != this.buffChunkTrailer) {
            this.buffChunkTrailer.release();
            this.buffChunkTrailer = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"destroy");
        }
    }

    @Override
    public void clear() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"clear", (Object[])new Object[0]);
        }
        while (!this.allocatedBuffers.isEmpty()) {
            this.allocatedBuffers.removeFirst().release();
        }
        this.lastHeaderBuffer = -1;
        if (null != this.myRequest) {
            if (this.bIsRequestOwner) {
                this.myRequest.clear();
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Request not mine, skipping clear()", (Object[])new Object[0]);
                }
                this.myRequest = null;
            }
        }
        this.bIsRequestOwner = true;
        if (null != this.myResponse) {
            if (this.bIsResponseOwner) {
                this.myResponse.clear();
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Response not mine, skipping clear()", (Object[])new Object[0]);
                }
                this.myResponse = null;
            }
        }
        this.bIsResponseOwner = true;
        this.msgSentState = 0;
        this.msgParsedState = 0;
        this.writingHeaders = false;
        this.bIsPersistent = true;
        this.bIsOutgoingBodyValid = true;
        this.bIsIncomingBodyValid = false;
        this.bIsBodyExpected = false;
        this.bIsPartialBody = false;
        this.outgoingMsgEncoding = DEFAULT_ENCODING;
        this.incomingMsgEncoding = DEFAULT_ENCODING;
        this.bIsRawBody = false;
        this.unparsedDataRemaining = -1L;
        this.bIsChunked = false;
        this.myContentLength = -1L;
        this.clearStorage();
        this.clearTempStorage();
        this.amountBeingRead = 0;
        this.numBytesWritten = 0L;
        this.incomingMsgSize = 0L;
        this.savedChunkLength = -1;
        this.oldLimit = 0;
        this.shouldModify = true;
        this.clearPendingByteBuffers();
        this.bIsJITRead = false;
        this.reqMethod = null;
        this.reqVersion = null;
        this.chunkLengthParseState = 0;
        this.bParsingTrailers = false;
        if (null != this.decompressHandler) {
            this.decompressHandler.close();
            this.decompressHandler = null;
        }
        if (null != this.compressHandler) {
            Iterator<WsByteBuffer> it = this.compressHandler.finish().iterator();
            while (it.hasNext()) {
                it.next().release();
            }
            this.compressHandler = null;
        }
        this.isFinalWrite = false;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"clear");
        }
    }

    public VersionValues getRequestVersion() {
        if (null == this.reqVersion) {
            return this.getRequest().getVersionValue();
        }
        return this.reqVersion;
    }

    public long getResponseStartTime() {
        return this.responseStartTime;
    }

    public final void setRequestVersion(VersionValues val) {
        this.reqVersion = val;
    }

    public MethodValues getRequestMethod() {
        if (null == this.reqMethod) {
            return this.getRequest().getMethodValue();
        }
        return this.reqMethod;
    }

    public final void setRequestMethod(MethodValues val) {
        this.reqMethod = val;
    }

    @Override
    public void setReadTimeout(int time) throws IllegalArgumentException {
        if (time < 0) {
            throw new IllegalArgumentException("Timeout too low (" + time + ")");
        }
        this.myReadTimeout = time;
    }

    @Override
    public void setWriteTimeout(int time) throws IllegalArgumentException {
        if (time < 0) {
            throw new IllegalArgumentException("Timeout too low (" + time + ")");
        }
        this.myWriteTimeout = time;
    }

    @Override
    public final int getReadTimeout() {
        return this.myReadTimeout;
    }

    @Override
    public final int getWriteTimeout() {
        return this.myWriteTimeout;
    }

    protected void updatePersistence(HttpBaseMessageImpl msg) {
        String value;
        if (!this.isPersistent()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"updatePersistence: already false", (Object[])new Object[0]);
            }
            return;
        }
        if (this.myVC instanceof H2VirtualConnectionImpl) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"HTTP/2.0 connection: setting persistance to false", (Object[])new Object[0]);
            }
            this.setPersistent(false);
            return;
        }
        if (msg.isIncoming() && this.getHttpConfig().isServantRegion() && "false".equalsIgnoreCase(value = (String)this.getVC().getStateMap().get("SessionPersistence"))) {
            this.setPersistent(false);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"z/OS CR forced non-persistence", (Object[])new Object[0]);
            }
            return;
        }
        if (msg.isCloseSet()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Message contains Close value", (Object[])new Object[0]);
            }
            this.setPersistent(false);
        } else if (!msg.isKeepAliveSet()) {
            if (msg.isIncoming()) {
                if (msg.getVersionValue().equals(VersionValues.V10)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Incoming 1.0 msg has no connection header", (Object[])new Object[0]);
                    }
                    this.setPersistent(false);
                }
            } else {
                this.setPersistent(this.getHttpConfig().isKeepAliveEnabled());
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Setting persistence based on configuration: " + this.isPersistent()), (Object[])new Object[0]);
                }
            }
        }
        if (this.getHttpConfig().getDebugLog().isEnabled(DebugLog.Level.DEBUG)) {
            this.getHttpConfig().getDebugLog().log(DebugLog.Level.DEBUG, "Connection persistence updated to " + this.isPersistent(), (HttpServiceContext)this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("updatePersistence updated: " + this.isPersistent()), (Object[])new Object[0]);
        }
    }

    private void updateBodyFlags(HttpBaseMessageImpl msg) {
        if (!msg.isIncoming()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("updateBodyFlags skipping outgoing message: " + msg), (Object[])new Object[0]);
            }
            return;
        }
        this.setIsChunkedEncoding(msg.isChunkedEncodingSet());
        if (this.isChunkedEncoding() && -1L != msg.getContentLength()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Removing Content-Length header of " + msg.getContentLength() + " and only using chunked-encoding"), (Object[])new Object[0]);
            }
            msg.removeHeader(HttpHeaderKeys.HDR_CONTENT_LENGTH);
            if (this.getHttpConfig().isRequestSmugglingProtectionEnabled()) {
                this.setPersistent(false);
            }
        }
        this.setContentLength(msg.getContentLength());
        if (0L == this.getContentLength()) {
            this.setBodyComplete();
        }
        this.bIsIncomingBodyValid = msg.isBodyAllowed();
        this.bIsBodyExpected = msg.isBodyExpected();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("updateBodyFlags: CL: " + this.getContentLength() + " isChunked: " + this.isChunkedEncoding() + " bodyValid: " + this.isIncomingBodyValid() + " bodyExpected: " + this.bIsBodyExpected), (Object[])new Object[0]);
        }
    }

    protected void updateBodyLengthHeaders(HttpBaseMessageImpl msg) {
        if (!msg.shouldUpdateBodyHeaders()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Msg not allowing body header changes: " + msg), (Object[])new Object[0]);
            }
            return;
        }
        if (0L != msg.getContentLength()) {
            msg.setContentLength(0L);
        }
        if (msg.isChunkedEncodingSet()) {
            msg.removeTransferEncoding(TransferEncodingValues.CHUNKED);
            msg.commitTransferEncoding();
        }
        if (this.getHttpConfig().shouldRemoveCLHeaderInTempStatusRespRFC7230compat() && msg instanceof HttpResponseMessageImpl && (((HttpResponseMessageImpl)msg).isTemporaryStatusCode() || ((HttpResponseMessageImpl)msg).getStatusCode() == StatusCodes.NO_CONTENT)) {
            msg.removeHeader(HttpHeaderKeys.HDR_CONTENT_LENGTH);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Status code 1xx or 204 found, not sending content-length", (Object[])new Object[0]);
            }
        }
    }

    private void updateIncomingEncodingFlags(HttpBaseMessageImpl msg) {
        ContentEncodingValues enc = msg.getOutermostEncoding();
        if (null != enc) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Msg outermost encoding: " + enc), (Object[])new Object[0]);
            }
            if (ContentEncodingValues.DEFLATE.equals(enc) || ContentEncodingValues.GZIP.equals(enc) || ContentEncodingValues.XGZIP.equals(enc)) {
                this.setIncomingMsgEncoding(enc);
            } else {
                this.setIncomingMsgEncoding(DEFAULT_ENCODING);
            }
        } else {
            this.setIncomingMsgEncoding(DEFAULT_ENCODING);
        }
    }

    public boolean isChunkedEncoding() {
        return this.bIsChunked;
    }

    private void setIsChunkedEncoding(boolean flag) {
        this.bIsChunked = flag;
    }

    public boolean isContentLength() {
        return -1L != this.getContentLength();
    }

    protected final long getContentLength() {
        return this.myContentLength;
    }

    private void setContentLength(long length) {
        this.myContentLength = length;
    }

    protected final boolean isIncomingBodyValid() {
        return this.bIsIncomingBodyValid;
    }

    protected final boolean isIncomingBodyExpected() {
        return this.bIsBodyExpected;
    }

    private boolean loadReadBuffers() {
        boolean rc = false;
        WsByteBuffer[] list = this.getTSC().getReadInterface().getBuffers();
        if (null != list && 0 != list.length) {
            this.parseBufferIndex = 0;
            this.myParseBuffers = list;
            rc = true;
        } else {
            this.parseBufferIndex = -1;
            this.myParseBuffers = null;
        }
        this.getTSC().getReadInterface().setBuffers(null);
        return rc;
    }

    protected WsByteBuffer getNextReadBuffer() {
        boolean bTrace = TraceComponent.isAnyTracingEnabled();
        if (-1 == this.parseBufferIndex) {
            if (!this.loadReadBuffers()) {
                this.setReadBuffer(null);
                return null;
            }
            if (bTrace && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Read " + this.myParseBuffers.length + " buffers from device."), (Object[])new Object[0]);
            }
        }
        this.setReadBuffer(this.myParseBuffers[this.parseBufferIndex]);
        this.configurePostReadBuffer(this.getReadBuffer());
        if (this.isJITRead()) {
            if (bTrace && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Saving JIT buffer", (Object[])new Object[0]);
            }
            this.allocatedBuffers.add(this.getReadBuffer());
        }
        ++this.parseBufferIndex;
        if (this.parseBufferIndex == this.myParseBuffers.length) {
            this.parseBufferIndex = -1;
        }
        if (bTrace && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Read buffer: " + this.getReadBuffer()), (Object[])new Object[0]);
        }
        return this.getReadBuffer();
    }

    public boolean isReadDataAvailable() {
        if (null != this.getReadBuffer() && this.getReadBuffer().hasRemaining()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Data exists in buffer: " + this.getReadBuffer()), (Object[])new Object[0]);
            }
            this.disableBufferModification();
            return true;
        }
        if (-1 == this.parseBufferIndex) {
            return false;
        }
        if (this.parseBufferIndex < this.myParseBuffers.length) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Secondary read buffers exist.", (Object[])new Object[0]);
            }
            this.getNextReadBuffer();
            return true;
        }
        return false;
    }

    public boolean isReadSpaceAvailable(int size) {
        if (null != this.getReadBuffer()) {
            int min;
            int cap = this.getReadBuffer().capacity();
            int availSpace = cap - this.getReadBuffer().limit();
            if (0 == availSpace) {
                return false;
            }
            if (cap < size) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Ignoring smaller buffer, capacity=" + cap + " target size=" + size), (Object[])new Object[0]);
                }
                return false;
            }
            int n = min = 1024 > size ? size : 1024;
            if (min > availSpace) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Ignoring buffer with too little free: " + availSpace), (Object[])new Object[0]);
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public WsByteBuffer getReadBuffer() {
        return this.currentReadBB;
    }

    public void setReadBuffer(WsByteBuffer buffer) {
        this.currentReadBB = buffer;
    }

    public void configurePostReadBuffer(WsByteBuffer buffer) {
        if (!this.shouldModify) {
            return;
        }
        if (0 < this.getOldLimit()) {
            buffer.limit(buffer.position());
            buffer.position(this.getOldLimit());
            this.setOldLimit(0);
        } else {
            buffer.flip();
        }
        this.disableBufferModification();
    }

    public void configurePreReadBuffer(WsByteBuffer buffer) {
        this.setOldLimit(buffer.limit());
        buffer.position(this.getOldLimit());
        buffer.limit(buffer.capacity());
    }

    private void releaseReadBuffers() {
        if (-1 != this.parseBufferIndex) {
            for (int i = this.parseBufferIndex; i < this.myParseBuffers.length; ++i) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Releasing read buffer: " + this.myParseBuffers[i]), (Object[])new Object[0]);
                }
                this.myParseBuffers[i].release();
            }
            this.myParseBuffers = null;
            this.parseBufferIndex = -1;
        }
    }

    public final boolean isJITRead() {
        return this.bIsJITRead;
    }

    public void setupJITRead(int size) {
        this.bIsJITRead = true;
        this.enableBufferModification();
        this.setOldLimit(0);
        this.getTSC().getReadInterface().setJITAllocateSize(size);
        this.getTSC().getReadInterface().setBuffers(null);
        this.setReadBuffer(null);
    }

    public void setupNonJITRead() {
        this.bIsJITRead = false;
        this.enableBufferModification();
        this.getTSC().getReadInterface().setJITAllocateSize(0);
        this.getTSC().getReadInterface().setBuffer(this.getReadBuffer());
    }

    public final void disableBufferModification() {
        this.shouldModify = false;
    }

    public final void enableBufferModification() {
        this.shouldModify = true;
    }

    private void clearPendingByteBuffers() {
        for (int i = 0; i < this.pendingBufferStop; ++i) {
            this.myPendingBuffers[i] = null;
        }
        this.pendingBufferStart = 0;
        this.pendingBufferStop = 0;
    }

    protected final WsByteBuffer[] getPendingBuffers() {
        return this.myPendingBuffers;
    }

    protected final void setPendingBuffers(WsByteBuffer[] list) {
        this.myPendingBuffers = list;
    }

    protected final int getPendingStart() {
        return this.pendingBufferStart;
    }

    protected final void setPendingStart(int start) {
        this.pendingBufferStart = start;
    }

    protected final int getPendingStop() {
        return this.pendingBufferStop;
    }

    protected final void setPendingStop(int stop) {
        this.pendingBufferStop = stop;
    }

    @Override
    public long getNumBytesWritten() {
        return this.numBytesWritten;
    }

    protected final void addBytesWritten(long num) {
        this.numBytesWritten += num;
    }

    protected final void resetBytesWritten() {
        this.numBytesWritten = 0L;
    }

    protected long queryIncomingMsgSize() {
        return this.incomingMsgSize;
    }

    protected void addToIncomingMsgSize(long num) {
        this.incomingMsgSize += num;
    }

    protected void checkIncomingMessageLimit(long addition) throws MessageTooLargeException {
    }

    private void growPendingArray(int size) {
        WsByteBuffer[] tempNew = new WsByteBuffer[size];
        System.arraycopy(this.myPendingBuffers, 0, tempNew, 0, this.pendingBufferStop);
        this.myPendingBuffers = tempNew;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Increased pending list to " + size), (Object[])new Object[0]);
        }
    }

    private void addToPendingByteBuffer(WsByteBuffer wsbb) {
        if (this.pendingBufferStop == this.myPendingBuffers.length) {
            this.growPendingArray(this.pendingBufferStop + 4);
        }
        this.myPendingBuffers[this.pendingBufferStop] = wsbb;
        ++this.pendingBufferStop;
    }

    private void addToPendingByteBuffer(WsByteBuffer[] list, int length) {
        int newsize = this.pendingBufferStop + length;
        if (newsize >= this.myPendingBuffers.length) {
            if (length < 4) {
                newsize = this.myPendingBuffers.length + 4;
            }
            this.growPendingArray(newsize);
        }
        System.arraycopy(list, 0, this.myPendingBuffers, this.pendingBufferStop, length);
        this.pendingBufferStop += length;
    }

    private void formatBody(WsByteBuffer[] wsbb, HttpBaseMessageImpl msg) {
        boolean doChunkWork;
        HttpInboundServiceContextImpl context;
        int index;
        if (null == wsbb || null == msg) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Leaving formatBody, wsbb: " + wsbb + " msg: " + msg), (Object[])new Object[0]);
            }
            return;
        }
        int length = 0;
        for (index = 0; index < wsbb.length && null != wsbb[index]; ++index) {
            length += wsbb[index].remaining();
        }
        if (0 == length) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Ignoring empty body buffers", (Object[])new Object[0]);
            }
            return;
        }
        if (msg instanceof HttpResponseMessageImpl && (context = (HttpInboundServiceContextImpl)this).getLink() instanceof H2HttpInboundLinkWrap) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"formatBody: On an HTTP/2.0 connection, creating DATA frames", (Object[])new Object[0]);
            }
            H2HttpInboundLinkWrap link = (H2HttpInboundLinkWrap)context.getLink();
            this.addBytesWritten(length);
            boolean addEndOfStream = false;
            if (msg.getContentLength() == this.getNumBytesWritten()) {
                addEndOfStream = true;
            }
            ArrayList<Frame> bodyFrames = link.prepareBody(wsbb, length, addEndOfStream);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"formatBody: On an HTTP/2.0 connection, adding DATA frames to be written", (Object[])new Object[0]);
            }
            this.framesToWrite.addAll(bodyFrames);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("formatBody: total bytes now : " + this.getNumBytesWritten()), (Object[])new Object[0]);
            }
            return;
        }
        boolean bl = doChunkWork = !this.isRawBody() && msg.isChunkedEncodingSet();
        if (doChunkWork) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Creating a chunk of length " + length), (Object[])new Object[0]);
            }
            byte[] encodedLength = this.asChunkedLength(length);
            this.addToPendingByteBuffer(this.createChunkHeader(encodedLength));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("formatBody: Adding " + index + " app buffers to write queue"), (Object[])new Object[0]);
        }
        this.addToPendingByteBuffer(wsbb, index);
        if (doChunkWork) {
            WsByteBuffer trailer = this.createChunkTrailer();
            trailer.limit(BNFHeaders.EOL.length);
            this.addToPendingByteBuffer(trailer);
        }
        this.addBytesWritten(length);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("formatBody: total bytes now : " + this.getNumBytesWritten()), (Object[])new Object[0]);
        }
    }

    private void formatHeaders(HttpBaseMessageImpl msg, boolean complete) throws IOException {
        ContentEncodingValues ce;
        if (this.getHttpConfig().isAccessLoggingEnabled() && this.isInboundConnection()) {
            this.responseStartTime = System.nanoTime();
        }
        if (null != this.compressHandler && !(ce = this.compressHandler.getContentEncoding()).equals(msg.getOutermostEncoding())) {
            msg.appendContentEncoding(ce);
        }
        this.updatePersistence(msg);
        this.setOutgoingBodyValid(msg.isBodyAllowed());
        if (!this.isOutgoingBodyValid()) {
            this.updateBodyLengthHeaders(msg);
        }
        WsByteBuffer[] headerBuffers = null;
        try {
            if (this.isH2Connection) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"formatHeaders: On an HTTP/2.0 connection, encoding the headers", (Object[])new Object[0]);
                }
                headerBuffers = msg.encodeH2Message();
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"formatHeaders: On an non-HTTP/2.0 connection, marshalling the headers", (Object[])new Object[0]);
                }
                headerBuffers = this.getHttpConfig().isBinaryTransportEnabled() ? msg.marshallBinaryMessage() : msg.marshallMessage();
                this.addToPendingByteBuffer(headerBuffers, headerBuffers.length);
            }
            if (this.isH2Connection && msg instanceof HttpResponseMessageImpl) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"formatHeaders: On an HTTP/2.0 connection, converting the headers into a frame", (Object[])new Object[0]);
                }
                HttpInboundServiceContextImpl context = (HttpInboundServiceContextImpl)this;
                H2HttpInboundLinkWrap link = (H2HttpInboundLinkWrap)context.getLink();
                if (msg.isBodyExpected()) {
                    complete = false;
                }
                if (this.getRequestMethod().equals(MethodValues.HEAD)) {
                    complete = true;
                }
                ArrayList<Frame> headerFrames = link.prepareHeaders(WsByteBufferUtils.asByteArray((WsByteBuffer[])headerBuffers), complete);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("formatHeaders: On an HTTP/2.0 connection, adding header frames to be written : " + headerFrames), (Object[])new Object[0]);
                }
                this.framesToWrite.addAll(headerFrames);
            }
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)this.getClass().getName(), (String)"formatHeaders", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Marshalling headers failed; " + t), (Object[])new Object[0]);
            }
            this.setPersistent(false);
            this.logLegacyMessage();
            if (this.isInboundConnection()) {
                this.setOutgoingBodyValid(false);
                try {
                    HttpResponseMessage res = (HttpResponseMessage)((Object)msg);
                    res.clear();
                    res.setStatusCode(StatusCodes.INTERNAL_ERROR);
                    headerBuffers = this.isH2Connection ? msg.encodeH2Message() : (this.getHttpConfig().isBinaryTransportEnabled() ? msg.marshallBinaryMessage() : msg.marshallMessage());
                }
                catch (Throwable t2) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("Attempt to marshall 500 Error failed; " + t2), (Object[])new Object[0]);
                    }
                    throw new IOException("Marshall header failure", t);
                }
            }
            throw new IOException("Marshall header failure", t);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            if (headerBuffers != null) {
                Tr.debug((TraceComponent)tc, (String)("formatHeaders: Adding " + headerBuffers.length + " buffers to be written"), (Object[])new Object[0]);
            } else {
                Tr.debug((TraceComponent)tc, (String)"formatHeaders: headerBuffers is null", (Object[])new Object[0]);
            }
        }
        this.writingHeaders = true;
        this.setHeadersSent();
        if (this.getHttpConfig().getDebugLog().isEnabled(DebugLog.Level.DEBUG)) {
            this.getHttpConfig().getDebugLog().log(DebugLog.Level.DEBUG, "Sending headers to client", (HttpServiceContext)this);
        }
    }

    protected final void sendHeaders(HttpBaseMessageImpl msg) throws IOException {
        if (this.headersSent()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Invalid call to sendHeaders after already sent", (Object[])new Object[0]);
            }
            return;
        }
        this.setupCompressionHandler(msg);
        this.formatHeaders(msg, false);
        this.synchWrite();
    }

    protected final VirtualConnection sendHeaders(HttpBaseMessageImpl msg, TCPWriteCompletedCallback wc) {
        if (this.headersSent()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Invalid call to sendHeaders after already sent", (Object[])new Object[0]);
            }
            return null;
        }
        this.setupCompressionHandler(msg);
        try {
            this.formatHeaders(msg, false);
        }
        catch (IOException ioe) {
            wc.error(this.getVC(), this.getTSC().getWriteInterface(), ioe);
            return null;
        }
        return this.asynchWrite(wc);
    }

    protected boolean isCompressionAllowed() {
        return true;
    }

    private boolean isAutoCompression(HttpBaseMessageImpl msg) {
        String val;
        boolean rc = this.isOutgoingMsgEncoded();
        if (!rc && null != (val = msg.getHeader(HttpHeaderKeys.HDR_$WSZIP).asString())) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Header requests compression: [" + val + "]"), (Object[])new Object[0]);
            }
            if ("gzip".equalsIgnoreCase(val)) {
                this.setGZipEncoded(true);
                rc = true;
            } else if ("x-gzip".equalsIgnoreCase(val)) {
                this.setXGZipEncoded(true);
                rc = true;
            } else if ("zlib".equalsIgnoreCase(val) || "deflate".equalsIgnoreCase(val)) {
                this.setZlibEncoded(true);
                rc = true;
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Invalid WSZIP compression: " + val), (Object[])new Object[0]);
                }
                this.setOutgoingMsgEncoding(ContentEncodingValues.IDENTITY);
            }
            msg.removeSpecialHeader(HttpHeaderKeys.HDR_$WSZIP);
        }
        if (rc && !(rc = this.isCompressionAllowed())) {
            this.setOutgoingMsgEncoding(ContentEncodingValues.IDENTITY);
        }
        return rc;
    }

    private void prepareOutgoing(WsByteBuffer[] wsbb, HttpBaseMessageImpl msg) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Preparing to send message", (Object[])new Object[0]);
        }
        WsByteBuffer[] buffers = wsbb;
        this.writingHeaders = false;
        if (!this.isRawBody() && !this.headersSent()) {
            this.setupCompressionHandler(msg);
        }
        if (null != this.compressHandler) {
            List<WsByteBuffer> list = this.compressHandler.compress(buffers);
            if (this.isFinalWrite) {
                list.addAll(this.compressHandler.finish());
            }
            if (0 < list.size()) {
                buffers = new WsByteBuffer[list.size()];
                list.toArray(buffers);
                this.storeAllocatedBuffers(buffers);
            } else {
                buffers = null;
            }
        }
        if (!this.headersSent()) {
            HttpInboundLink link;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("prepareOutgoing: partial: " + this.isPartialBody() + " chunked: " + msg.isChunkedEncodingSet() + " cl: " + msg.getContentLength()), (Object[])new Object[0]);
            }
            boolean complete = false;
            if (!this.isPartialBody() && msg.shouldUpdateBodyHeaders()) {
                complete = true;
                msg.setContentLength(GenericUtils.sizeOf(buffers));
                if (msg.isChunkedEncodingSet()) {
                    msg.removeTransferEncoding(TransferEncodingValues.CHUNKED);
                    msg.commitTransferEncoding();
                }
            }
            if ((link = ((HttpInboundServiceContextImpl)this).getLink()) instanceof H2HttpInboundLinkWrap && ((H2HttpInboundLinkWrap)link).muxLink != null && ((H2HttpInboundLinkWrap)link).muxLink.getRemoteConnectionSettings() != null && ((H2HttpInboundLinkWrap)link).muxLink.getRemoteConnectionSettings().getEnablePush() == 1) {
                List<HeaderField> headers = msg.getAllHeaders();
                for (HeaderField header : headers) {
                    if (!header.getName().equalsIgnoreCase("link") || !header.asString().toLowerCase().contains("rel=preload") || header.asString().toLowerCase().contains("nopush")) continue;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"prepareOutgoing: Link header rel=preload found, push_promise will be sent", (Object[])new Object[0]);
                    }
                    this.handleH2LinkPreload(header, link);
                }
            }
            this.formatHeaders(msg, complete);
        }
        if (null != buffers) {
            if (this.isOutgoingBodyValid()) {
                this.formatBody(buffers, msg);
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Ignoring " + buffers.length + " body buffers"), (Object[])new Object[0]);
            }
        }
    }

    protected final void sendOutgoing(WsByteBuffer[] wsbb, HttpBaseMessageImpl msg) throws IOException {
        this.prepareOutgoing(wsbb, msg);
        this.synchWrite();
    }

    protected final VirtualConnection sendOutgoing(WsByteBuffer[] wsbb, HttpBaseMessageImpl msg, TCPWriteCompletedCallback wc) {
        try {
            this.prepareOutgoing(wsbb, msg);
        }
        catch (IOException ioe) {
            wc.error(this.getVC(), this.getTSC().getWriteInterface(), ioe);
            return null;
        }
        return this.asynchWrite(wc);
    }

    protected final void sendFullOutgoing(WsByteBuffer[] wsbb, HttpBaseMessageImpl msg) throws IOException {
        this.isFinalWrite = true;
        this.prepareOutgoing(wsbb, msg);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("sendFullOutgoing : " + this.isOutgoingBodyValid() + ", " + wsbb + ", " + this), (Object[])new Object[0]);
        }
        if (this.isOutgoingBodyValid()) {
            HttpInboundServiceContextImpl hisc = null;
            boolean needH2EOS = true;
            HttpInboundLink link = ((HttpInboundServiceContextImpl)this).getLink();
            if (this instanceof HttpInboundServiceContextImpl) {
                if (link instanceof H2HttpInboundLinkWrap) {
                    Frame lastFrame;
                    if (this.framesToWrite != null && this.framesToWrite.size() > 0 && (lastFrame = this.framesToWrite.get(this.framesToWrite.size() - 1)) != null && lastFrame.flagEndStreamSet()) {
                        needH2EOS = false;
                    }
                } else {
                    needH2EOS = false;
                }
                if (wsbb == null || needH2EOS) {
                    hisc = (HttpInboundServiceContextImpl)this;
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled() && hisc != null && hisc.getLink() != null) {
                Tr.debug((TraceComponent)tc, (String)("sendFullOutgoing : " + hisc + ", " + ((Object)((Object)hisc.getLink())).toString()), (Object[])new Object[0]);
            }
            if (hisc != null && link instanceof H2HttpInboundLinkWrap) {
                H2HttpInboundLinkWrap h2Link = (H2HttpInboundLinkWrap)link;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"sendFullOutgoing : preparing the final write", (Object[])new Object[0]);
                }
                if (msg.getTrailers() != null) {
                    WsByteBuffer[] trailers;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"sendFullOutgoing : creating trailers", (Object[])new Object[0]);
                    }
                    if ((trailers = this.marshallOutgoingH2Trailers(h2Link.getWriteTable())) != null) {
                        this.framesToWrite.addAll(h2Link.prepareHeaders(WsByteBufferUtils.asByteArray((WsByteBuffer[])trailers), true));
                    }
                } else if (needH2EOS) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"sendFullOutgoing : adding HTTP/2 EOS flag", (Object[])new Object[0]);
                    }
                    this.framesToWrite.addAll(h2Link.prepareBody(null, 0, this.isFinalWrite));
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("sendFullOutgoing : final write prepared : " + this.framesToWrite), (Object[])new Object[0]);
                }
            } else if (msg.isChunkedEncodingSet()) {
                this.createEndOfBodyChunk();
            }
        }
        this.setMessageSent();
        this.synchWrite();
    }

    protected final VirtualConnection sendFullOutgoing(WsByteBuffer[] wsbb, HttpBaseMessageImpl msg, TCPWriteCompletedCallback wc) {
        this.isFinalWrite = true;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("sendFullOutgoing : " + wsbb + ", " + this), (Object[])new Object[0]);
        }
        try {
            this.prepareOutgoing(wsbb, msg);
        }
        catch (IOException ioe) {
            wc.error(this.getVC(), this.getTSC().getWriteInterface(), ioe);
            return null;
        }
        if (this.isOutgoingBodyValid() && msg.isChunkedEncodingSet()) {
            HttpInboundServiceContextImpl hisc = null;
            if (this instanceof HttpInboundServiceContextImpl) {
                hisc = (HttpInboundServiceContextImpl)this;
            }
            if (hisc != null && !(hisc.getLink() instanceof H2HttpInboundLinkWrap)) {
                this.createEndOfBodyChunk();
            }
        }
        this.setMessageSent();
        return this.asynchWrite(wc);
    }

    protected WsByteBuffer createChunkHeader(byte[] length) {
        if (null == this.buffChunkHeader) {
            this.buffChunkHeader = this.newBuffer(32);
            this.buffChunkHeader.removeFromLeakDetection();
        } else {
            this.buffChunkHeader.clear();
        }
        this.buffChunkHeader.put(length);
        this.buffChunkHeader.put(BNFHeaders.EOL);
        this.buffChunkHeader.flip();
        return this.buffChunkHeader;
    }

    protected WsByteBuffer createChunkTrailer() {
        if (null == this.buffChunkTrailer) {
            this.buffChunkTrailer = this.newBuffer(32);
            this.buffChunkTrailer.removeFromLeakDetection();
            this.buffChunkTrailer.put(CHUNK_TRAILER_DATA);
            this.buffChunkTrailer.flip();
        } else {
            this.buffChunkTrailer.position(0);
        }
        return this.buffChunkTrailer;
    }

    private void createEndOfBodyChunk() {
        if (this.isRawBody()) {
            WsByteBuffer[] trailers = this.marshallOutgoingTrailers();
            if (null != trailers) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Adding trailers after raw body.", (Object[])new Object[0]);
                }
                this.addToPendingByteBuffer(trailers, trailers.length);
            }
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Creating end of body chunk", (Object[])new Object[0]);
        }
        WsByteBuffer trailer = null;
        if (null == this.buffChunkTrailer) {
            trailer = this.createChunkTrailer();
            trailer.position(2);
            this.addToPendingByteBuffer(trailer);
        } else {
            trailer = this.buffChunkTrailer;
            int pos = trailer.position();
            if (0 != pos) {
                if (2 != pos) {
                    trailer.position(2);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Zero chunk adding to pending list", (Object[])new Object[0]);
                }
                this.addToPendingByteBuffer(trailer);
            }
        }
        WsByteBuffer[] trailerData = this.marshallOutgoingTrailers();
        if (null != trailerData) {
            trailer.limit(5);
            this.addToPendingByteBuffer(trailerData, trailerData.length);
        } else {
            trailer.limit(7);
        }
    }

    private WsByteBuffer[] marshallOutgoingTrailers() {
        HttpTrailersImpl trailers = this.getMessageBeingSent().getTrailersImpl();
        WsByteBuffer[] buffers = null;
        if (null != trailers) {
            trailers.computeRemainingTrailers();
            if (0 < trailers.getNumberOfHeaders()) {
                buffers = this.getHttpConfig().isBinaryTransportEnabled() ? trailers.marshallBinaryHeaders(null) : trailers.marshallHeaders(null);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Trailers marshalled into " + buffers.length + " buffers."), (Object[])new Object[0]);
                }
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Warning: no actual trailers to marshall.", (Object[])new Object[0]);
            }
        }
        return buffers;
    }

    private WsByteBuffer[] marshallOutgoingH2Trailers(H2HeaderTable table) {
        HttpTrailersImpl trailers = this.getMessageBeingSent().getTrailersImpl();
        WsByteBuffer[] buffers = null;
        if (null != trailers) {
            trailers.computeRemainingTrailers();
            if (0 < trailers.getNumberOfHeaders()) {
                buffers = trailers.marshallHeaders(null, table);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Trailers marshalled into " + buffers.length + " buffers."), (Object[])new Object[0]);
                }
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Warning: no actual trailers to marshall.", (Object[])new Object[0]);
            }
        }
        return buffers;
    }

    protected final VirtualConnection asynchWrite(TCPWriteCompletedCallback callback) {
        WsByteBuffer[] writeBuffers = this.getBuffList();
        if (null != writeBuffers) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Writing (async) " + writeBuffers.length + " buffers."), (Object[])new Object[0]);
            }
            this.getTSC().getWriteInterface().setBuffers(writeBuffers);
            return this.getTSC().getWriteInterface().write(-1L, callback, this.isForceAsync(), this.getWriteTimeout());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Async write has no data to send.", (Object[])new Object[0]);
        }
        if (this.isForceAsync()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"App channel forcing callback usage.", (Object[])new Object[0]);
            }
            callback.complete(this.getVC(), this.getTSC().getWriteInterface());
            return null;
        }
        return this.getVC();
    }

    private void synchWrite() throws IOException {
        WsByteBuffer[] writeBuffers = this.getBuffList();
        if (null != writeBuffers) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Writing (sync) " + writeBuffers.length + " buffers."), (Object[])new Object[0]);
            }
            this.getTSC().getWriteInterface().setBuffers(writeBuffers);
            try {
                this.getTSC().getWriteInterface().write(-1L, this.getWriteTimeout());
            }
            catch (IOException ioe) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("IOException during sync write: " + ioe.getMessage()), (Object[])new Object[0]);
                }
                this.setPersistent(false);
                this.logLegacyMessage();
                if (this.isInboundConnection() && !this.getHttpConfig().throwIOEForInboundConnections()) {
                    return;
                }
                throw ioe;
            }
            finally {
                this.getTSC().getWriteInterface().setBuffers(null);
            }
        } else if (this.isH2Connection && !this.framesToWrite.isEmpty()) {
            HttpInboundServiceContextImpl context;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Writing out H2 Frames", (Object[])new Object[0]);
            }
            if ((context = (HttpInboundServiceContextImpl)this).getLink() instanceof H2HttpInboundLinkWrap) {
                H2HttpInboundLinkWrap link = (H2HttpInboundLinkWrap)context.getLink();
                try {
                    link.writeFramesSync(this.framesToWrite);
                }
                catch (IOException ioe) {
                    throw ioe;
                }
                finally {
                    this.framesToWrite.clear();
                }
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Sync write has no data to send.", (Object[])new Object[0]);
        }
    }

    public void logLegacyMessage() {
    }

    protected WsByteBuffer[] getBuffList() {
        int size = this.pendingBufferStop - this.pendingBufferStart;
        if (0 == size) {
            return null;
        }
        WsByteBuffer[] list = new WsByteBuffer[size];
        System.arraycopy(this.myPendingBuffers, this.pendingBufferStart, list, 0, size);
        this.clearPendingByteBuffers();
        return list;
    }

    protected abstract boolean reconnectAllowed();

    protected abstract HttpBaseMessageImpl getMessageBeingParsed();

    protected abstract HttpBaseMessageImpl getMessageBeingSent();

    public boolean parseMessage() throws Exception {
        boolean bTrace = TraceComponent.isAnyTracingEnabled();
        if (null == this.currentReadBB && null == this.getNextReadBuffer()) {
            this.setupJITRead(this.myChannelConfig.getIncomingHdrBufferSize());
            return false;
        }
        HttpBaseMessageImpl msg = this.getMessageBeingParsed();
        boolean rc = false;
        boolean newBuffer = false;
        if (-1 == msg.getBuffersIndex()) {
            if (bTrace && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("First buffer of message: " + this.currentReadBB), (Object[])new Object[0]);
            }
            if (this.isSecure()) {
                this.myChannelConfig.getDebugLog().log(DebugLog.Level.INFO, "Connection is secure", (HttpServiceContext)this);
            }
            this.myChannelConfig.getDebugLog().log(DebugLog.Level.DEBUG, "Starting to parse the message", (HttpServiceContext)this);
            newBuffer = true;
        } else if (this.isJITRead()) {
            newBuffer = true;
        }
        do {
            if (newBuffer) {
                if (bTrace && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Msg saving buffer: " + this.currentReadBB), (Object[])new Object[0]);
                }
                msg.addParseBuffer(this.currentReadBB);
            }
            this.configurePostReadBuffer(this.currentReadBB);
            rc = msg.parseMessage(this.currentReadBB, this.myChannelConfig.shouldExtractValue());
            if (rc) {
                this.parsingComplete();
                continue;
            }
            if (!this.isReadDataAvailable()) break;
            newBuffer = true;
        } while (!rc);
        if (bTrace && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("parseMessage() returning " + rc + " for " + msg), (Object[])new Object[0]);
        }
        return rc;
    }

    protected void parsingComplete() throws Exception {
        HttpBaseMessageImpl msg = this.getMessageBeingParsed();
        this.setHeadersParsed();
        this.setLastHeaderBuffer();
        this.updatePersistence(msg);
        this.updateBodyFlags(msg);
        this.updateIncomingEncodingFlags(msg);
        if (this.getHttpConfig().getDebugLog().isEnabled(DebugLog.Level.DEBUG)) {
            this.getHttpConfig().getDebugLog().log(DebugLog.Level.DEBUG, "Finished parsing the message", (HttpServiceContext)this);
        }
    }

    public boolean setupReadBuffers(int size, boolean bAllocate) {
        if (this.isReadDataAvailable()) {
            return true;
        }
        if (this.getHttpConfig().isJITOnlyReads()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Config forcing a JIT read.", (Object[])new Object[0]);
            }
            this.setupJITRead(size);
        } else if (this.isReadSpaceAvailable(size)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Reading into existing buffer: " + this.getReadBuffer()), (Object[])new Object[0]);
            }
            this.configurePreReadBuffer(this.getReadBuffer());
            this.setupNonJITRead();
        } else if (bAllocate) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Allocating read buffer, size=" + size), (Object[])new Object[0]);
            }
            this.setOldLimit(0);
            this.setReadBuffer(this.newBuffer(size));
            this.setupNonJITRead();
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Setting up a JIT read, size=" + size), (Object[])new Object[0]);
            }
            this.setupJITRead(size);
        }
        return false;
    }

    public void resetRead() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Resetting parsing variables", (Object[])new Object[0]);
        }
        this.resetMsgParsedState();
        this.getMessageBeingParsed().clear();
    }

    public void resetWrite() {
        this.resetMsgSentState();
        VersionValues version = this.getMessageBeingSent().getVersionValue();
        this.getMessageBeingSent().clear();
        this.getMessageBeingSent().setVersion(version);
    }

    public String[] introspectSelf() {
        ArrayList<String> output = new ArrayList<String>();
        HttpBaseMessageImpl msg = this.getMessageBeingParsed();
        if (null != msg) {
            output.add("Message parsed: " + msg.toString());
            for (HeaderField header : msg.getAllHeaders()) {
                output.add(header.getName() + "=" + header.asString());
            }
        } else {
            output.add("Message being parsed is null");
        }
        if (null != this.getReadBuffer()) {
            output.add("read buffer=" + this.getReadBuffer());
        }
        output.add("ReadBufferSize=" + this.getHttpConfig().getIncomingBodyBufferSize());
        output.add("ReadTimeout=" + this.getReadTimeout());
        output.add("WriteTimeout=" + this.getWriteTimeout());
        output.add("unparsedDataRemaining=" + this.getDataLength());
        return output.toArray(new String[output.size()]);
    }

    public final InterChannelCallback getAppWriteCallback() {
        return this.appWriteCB;
    }

    public final InterChannelCallback getAppReadCallback() {
        return this.appReadCB;
    }

    protected final void setAppWriteCallback(InterChannelCallback cb) {
        this.appWriteCB = cb;
    }

    protected final void setAppReadCallback(InterChannelCallback cb) {
        this.appReadCB = cb;
    }

    public abstract HttpObjectFactory getObjectFactory();

    public final void setHttpConfig(HttpChannelConfig hcc) {
        this.myChannelConfig = hcc;
    }

    public final HttpChannelConfig getHttpConfig() {
        return this.myChannelConfig;
    }

    public final TCPConnectionContext getTSC() {
        return this.myTSC;
    }

    public final VirtualConnection getVC() {
        return this.myVC;
    }

    protected final void setVC(VirtualConnection vc) {
        this.myVC = vc;
    }

    private byte[] asChunkedLength(int length) {
        int initSize = 16;
        byte[] chunkBuf = new byte[initSize];
        int off = chunkBuf.length;
        for (int count = length; 0 < count; count >>= 4) {
            int digit = count & 0xF;
            chunkBuf[--off] = HEX_BYTES[digit];
        }
        byte[] retVal = new byte[initSize - off];
        System.arraycopy(chunkBuf, off, retVal, 0, retVal.length);
        return retVal;
    }

    private WsByteBuffer newBuffer(int size) {
        return this.getHttpConfig().isDirectBufferType() ? HttpDispatcher.getBufferManager().allocateDirect(size) : HttpDispatcher.getBufferManager().allocate(size);
    }

    protected WsByteBuffer allocateBuffer(int size) {
        WsByteBuffer wsbb = this.newBuffer(size);
        this.allocatedBuffers.add(wsbb);
        return wsbb;
    }

    private void setDataLength(long len) {
        this.unparsedDataRemaining = len;
    }

    private long getDataLength() {
        return this.unparsedDataRemaining;
    }

    private boolean doTrailersFollow() throws IllegalHttpBodyException {
        if (this.getMessageBeingParsed().containsHeader(HttpHeaderKeys.HDR_TRAILER)) {
            return true;
        }
        int data_len = this.getReadBuffer().remaining();
        if (0 == data_len) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No data present, assuming no trailers exist", (Object[])new Object[0]);
            }
            return false;
        }
        byte b = this.getReadBuffer().get();
        boolean rc = true;
        if (13 == b) {
            this.addToIncomingMsgSize(1L);
            if (1 < data_len) {
                b = this.getReadBuffer().get();
                if (10 == b) {
                    this.addToIncomingMsgSize(1L);
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Error: Received " + b + " after the CR"), (Object[])new Object[0]);
                    }
                    throw new IllegalHttpBodyException("Missing chunk LF: " + b);
                }
            }
            rc = false;
        } else if (10 == b) {
            this.addToIncomingMsgSize(1L);
            rc = false;
        } else {
            int pos = this.getReadBuffer().position() - 1;
            this.getReadBuffer().position(pos);
            rc = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Peek ahead for trailers rc->" + rc), (Object[])new Object[0]);
        }
        return rc;
    }

    private void parseChunkCRLF(int excess) throws IllegalHttpBodyException {
        if (0 == excess) {
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Parsing past chunk CRLF, excess=" + excess), (Object[])new Object[0]);
        }
        byte b = this.getReadBuffer().get();
        this.addToIncomingMsgSize(1L);
        if (13 == b) {
            if (1 == excess) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"LF char not read yet.", (Object[])new Object[0]);
                }
                return;
            }
            b = this.getReadBuffer().get();
            this.addToIncomingMsgSize(1L);
        }
        if (10 != b) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Char expected to be LF but is ->" + b), (Object[])new Object[0]);
            }
            throw new IllegalHttpBodyException("Missing chunk LF: " + b);
        }
    }

    private boolean findBodyLength(HttpBaseMessageImpl msg, boolean async) throws BodyCompleteException, IllegalHttpBodyException, IOException {
        if (this.isChunkedEncoding()) {
            if (0 == this.getChunkLengthParsingState()) {
                this.setChunkLengthParsingState(15);
            }
            this.setDataLength(this.readChunkLength(this.getReadBuffer()));
            while (-1L == this.getDataLength()) {
                if (!this.isReadDataAvailable()) {
                    if (this.getHttpConfig().shouldWaitForEndOfMessage() && 18 == this.getChunkLengthParsingState() ? this.fillABuffer(1L, async, true) : this.fillABuffer(3L, async, true)) {
                        return true;
                    }
                    if (this.isBodyComplete()) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Failed to read chunk length", (Object[])new Object[0]);
                        }
                        throw new BodyCompleteException("Failed to read chunk length");
                    }
                }
                this.setDataLength(this.readChunkLength(this.getReadBuffer()));
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Read chunk size " + this.getDataLength()), (Object[])new Object[0]);
            }
            this.checkIncomingMessageLimit(this.getDataLength());
            if (this.getHttpConfig().getDebugLog().isEnabled(DebugLog.Level.DEBUG)) {
                this.getHttpConfig().getDebugLog().log(DebugLog.Level.DEBUG, "Parsed chunk size of " + this.getDataLength(), (HttpServiceContext)this);
            }
            if (0L == this.getDataLength()) {
                this.setBodyComplete();
                if (this.doTrailersFollow()) {
                    return this.parseTrailers(msg, async);
                }
                return false;
            }
        } else if (this.isContentLength()) {
            this.setDataLength(this.getContentLength());
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Got CL size " + this.getDataLength()), (Object[])new Object[0]);
            }
            if (this.getHttpConfig().getDebugLog().isEnabled(DebugLog.Level.DEBUG)) {
                this.getHttpConfig().getDebugLog().log(DebugLog.Level.DEBUG, "Parsed message content-length of " + this.getDataLength(), (HttpServiceContext)this);
            }
            if (0L == this.getDataLength()) {
                this.setBodyComplete();
                throw new BodyCompleteException("No more body to read");
            }
        }
        if (0L > this.getDataLength()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Invalid negative body length: " + this.getDataLength()), (Object[])new Object[0]);
            }
            this.setDataLength(0L);
            throw new IllegalHttpBodyException("Invalid body length");
        }
        return false;
    }

    private boolean findRawChunkLength(HttpBaseMessageImpl msg, boolean async) throws IllegalHttpBodyException, IOException {
        if (0 == this.getChunkLengthParsingState()) {
            this.setChunkLengthParsingState(15);
        }
        if (null == this.getReadBuffer() && this.fillABuffer(3L, async, true)) {
            return true;
        }
        this.setDataLength(this.readChunkLength(this.getReadBuffer()));
        while (-1L == this.getDataLength()) {
            if (!this.isReadDataAvailable()) {
                if (this.fillABuffer(3L, async, true)) {
                    return true;
                }
                if (this.isBodyComplete()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Failed to read chunk length", (Object[])new Object[0]);
                    }
                    throw new IllegalHttpBodyException("IOException while reading chunk");
                }
            }
            this.setDataLength(this.readChunkLength(this.getReadBuffer()));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Read raw chunk size " + this.getDataLength()), (Object[])new Object[0]);
        }
        this.checkIncomingMessageLimit(this.getDataLength());
        if (this.getHttpConfig().getDebugLog().isEnabled(DebugLog.Level.DEBUG)) {
            this.getHttpConfig().getDebugLog().log(DebugLog.Level.DEBUG, "Parsed chunk size of " + this.getDataLength(), (HttpServiceContext)this);
        }
        if (0L == this.getDataLength()) {
            this.setBodyComplete();
            boolean bTrailers = this.doTrailersFollow();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Slicing body up to zero chunk, trailers=" + bTrailers), (Object[])new Object[0]);
            }
            int position = this.getReadBuffer().position();
            int limit = this.getReadBuffer().limit();
            this.getReadBuffer().position(this.oldPosition);
            if (position == limit) {
                this.storeBuffer(this.getReadBuffer().slice());
            } else {
                this.getReadBuffer().limit(position);
                this.storeBuffer(this.getReadBuffer().slice());
                this.getReadBuffer().limit(limit);
            }
            this.getReadBuffer().position(position);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Post-slice: " + this.getReadBuffer()), (Object[])new Object[0]);
            }
            if (bTrailers) {
                return this.parseTrailers(msg, async);
            }
            return false;
        }
        return false;
    }

    private boolean readRawChunk(HttpBaseMessageImpl msg, boolean async) throws BodyCompleteException, IllegalHttpBodyException, IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Reading raw chunk buffer, len->" + this.getDataLength()), (Object[])new Object[0]);
        }
        if (this.isBodyComplete()) {
            return false;
        }
        if (null == this.getReadBuffer()) {
            this.getNextReadBuffer();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("current buffer: " + this.getReadBuffer()), (Object[])new Object[0]);
        }
        if (null == this.getReadBuffer() || this.getReadBuffer().position() == this.getReadBuffer().capacity()) {
            this.oldPosition = 0;
        } else if (-1 == this.oldPosition) {
            this.oldPosition = this.getReadBuffer().position();
        }
        if (-1L == this.getDataLength() && this.findRawChunkLength(msg, async)) {
            return true;
        }
        if (0L == this.getDataLength()) {
            return false;
        }
        if (!this.isReadDataAvailable()) {
            if (this.fillABuffer(this.getDataLength(), async, true)) {
                return true;
            }
            if (this.isBodyComplete()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Error while reading body data", (Object[])new Object[0]);
                }
                throw new IllegalHttpBodyException("Error while reading chunk body.");
            }
        }
        int position = this.getReadBuffer().position();
        int limit = this.getReadBuffer().limit();
        int amountAvail = limit - position;
        long excess = (long)amountAvail - this.getDataLength();
        if (0L < excess) {
            amountAvail = (int)this.getDataLength();
            this.unparsedDataRemaining = 0L;
        } else {
            this.unparsedDataRemaining -= (long)amountAvail;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Unparsed data remaining: " + this.getDataLength()), (Object[])new Object[0]);
        }
        if (0L >= excess && limit == this.getReadBuffer().capacity()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Buffer is full, position: " + this.oldPosition), (Object[])new Object[0]);
            }
            this.getReadBuffer().position(this.oldPosition);
            if (0 == this.oldPosition) {
                this.storeBuffer(this.returnLastBuffer());
            } else {
                this.storeBuffer(this.getReadBuffer().slice());
            }
            this.setReadBuffer(null);
            this.oldPosition = -1;
            if (0L == this.getDataLength()) {
                this.setDataLength(-1L);
            }
        } else {
            int excessInt = (int)excess;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Slicing part of a buffer", (Object[])new Object[0]);
            }
            this.getReadBuffer().position(this.oldPosition);
            if (excessInt > 0) {
                byte b;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Parsing CRLF for raw chunk, excess=" + excess), (Object[])new Object[0]);
                }
                if (13 == (b = this.getReadBuffer().get(limit - excessInt)) && 0 < --excessInt) {
                    b = this.getReadBuffer().get(limit - excessInt);
                }
                if (10 == b) {
                    --excessInt;
                }
                this.getReadBuffer().limit(limit - excessInt);
                this.storeBuffer(this.getReadBuffer().slice());
                this.getReadBuffer().limit(limit);
                this.getReadBuffer().position(limit - excessInt);
            } else {
                this.storeBuffer(this.getReadBuffer().slice());
                this.getReadBuffer().position(limit);
            }
            this.oldPosition = this.getReadBuffer().position();
            if (0L == this.getDataLength()) {
                this.setDataLength(-1L);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Post-slice: " + this.getReadBuffer()), (Object[])new Object[0]);
            }
        }
        return false;
    }

    private boolean readSingleBlock(HttpBaseMessageImpl msg, boolean async) throws BodyCompleteException, IllegalHttpBodyException, IOException {
        if (!this.isMultiRead() && !this.tempBuffers.isEmpty()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Buffer already available", (Object[])new Object[0]);
            }
            return false;
        }
        if (this.isBodyComplete()) {
            throw new BodyCompleteException("No more body to read");
        }
        if (null == this.getReadBuffer()) {
            this.getNextReadBuffer();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("current buffer: " + this.getReadBuffer()), (Object[])new Object[0]);
        }
        if (-1L == this.getDataLength() && this.findBodyLength(msg, async)) {
            return true;
        }
        if (0L == this.getDataLength()) {
            return false;
        }
        if (!this.isReadDataAvailable()) {
            if (this.fillABuffer(this.getDataLength(), async, true)) {
                return true;
            }
            if (this.isBodyComplete()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"End of body found during fillABuffer", (Object[])new Object[0]);
                }
                return false;
            }
        }
        int position = this.getReadBuffer().position();
        int limit = this.getReadBuffer().limit();
        int amountAvail = limit - position;
        long excess = (long)amountAvail - this.getDataLength();
        if (0L < excess) {
            if (this.isContentLength() && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Excess data received: " + excess), (Object[])new Object[0]);
            }
            amountAvail = (int)this.getDataLength();
            this.unparsedDataRemaining = 0L;
        } else {
            this.unparsedDataRemaining -= (long)amountAvail;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Unparsed data remaining: " + this.getDataLength()), (Object[])new Object[0]);
        }
        if (this.isContentLength() && 0L == this.getDataLength()) {
            this.setBodyComplete();
        }
        if (amountAvail == this.getReadBuffer().capacity()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Returning full buffer", (Object[])new Object[0]);
            }
            this.storeTempBuffer(this.returnLastBuffer());
            this.getNextReadBuffer();
        } else {
            int newPosition;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Slicing part of a buffer", (Object[])new Object[0]);
            }
            if ((newPosition = position + amountAvail) == limit) {
                this.storeTempBuffer(this.getReadBuffer().slice());
            } else {
                this.getReadBuffer().limit(newPosition);
                this.storeTempBuffer(this.getReadBuffer().slice());
                this.getReadBuffer().limit(limit);
            }
            this.getReadBuffer().position(newPosition);
            if (this.isChunkedEncoding() && 0L < excess) {
                this.parseChunkCRLF((int)excess);
            }
        }
        return false;
    }

    protected final boolean readBodyBuffer(HttpBaseMessageImpl msg, boolean async) throws IllegalHttpBodyException, BodyCompleteException, IOException {
        boolean bAsyncInProgress = false;
        this.setupDecompressionHandler();
        if (this.decompressHandler.isEnabled() && VersionValues.V10.equals(msg.getVersionValue())) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Reading encoded 1.0 body", (Object[])new Object[0]);
            }
            this.setMultiRead(true);
            return this.readBodyBuffers(msg, async);
        }
        if (this.isContentLength()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Reading body, content-length", (Object[])new Object[0]);
            }
            bAsyncInProgress = this.readSingleBlock(msg, async);
        } else if (this.isChunkedEncoding()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Reading body, chunked", (Object[])new Object[0]);
            }
            if (0L == this.getDataLength()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Reached end of chunk previously", (Object[])new Object[0]);
                }
                this.setDataLength(-1L);
            }
            bAsyncInProgress = !this.isRawBody() ? this.readSingleBlock(msg, async) : this.readRawChunk(msg, async);
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Reading until closure", (Object[])new Object[0]);
            }
            bAsyncInProgress = this.readUntilEnd(async);
        }
        if (!bAsyncInProgress && !this.moveBuffers()) {
            bAsyncInProgress = this.readBodyBuffer(msg, async);
        }
        return bAsyncInProgress;
    }

    protected final boolean readBodyBuffers(HttpBaseMessageImpl msg, boolean async) throws IllegalHttpBodyException, BodyCompleteException, IOException {
        if (this.isBodyComplete()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"BodyComplete is true, exiting", (Object[])new Object[0]);
            }
            return false;
        }
        boolean bAsyncInProgress = false;
        this.setupDecompressionHandler();
        if (this.isChunkedEncoding()) {
            if (this.isRawBody()) {
                bAsyncInProgress = this.readRawChunk(msg, async);
                while (!bAsyncInProgress && !this.isBodyComplete()) {
                    bAsyncInProgress = this.readRawChunk(msg, async);
                }
            } else {
                bAsyncInProgress = this.readFullChunk(msg, async);
                while (!bAsyncInProgress && !this.isBodyComplete()) {
                    bAsyncInProgress = this.readFullChunk(msg, async);
                }
            }
        } else {
            bAsyncInProgress = this.isContentLength() ? this.readFullCL(msg, async) : this.readFullBody(async);
        }
        if (!bAsyncInProgress) {
            this.setBodyComplete();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("readBodyBuffers returning " + bAsyncInProgress), (Object[])new Object[0]);
        }
        return bAsyncInProgress;
    }

    protected boolean readUntilEnd(boolean async) throws IllegalHttpBodyException, BodyCompleteException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Inbound request sending non-length delimited body, async:" + async + ", throwing exception"), (Object[])new Object[0]);
        }
        if (this.getHttpConfig().getDebugLog().isEnabled(DebugLog.Level.WARN)) {
            this.getHttpConfig().getDebugLog().log(DebugLog.Level.WARN, "Invalid non-delimited message body", (HttpServiceContext)this);
        }
        this.prepareClosure();
        throw new IllegalHttpBodyException("Non-length delimited body on request");
    }

    private boolean moveBuffers() throws IllegalHttpBodyException {
        if (this.tempBuffers.isEmpty()) {
            return true;
        }
        boolean rc = false;
        if (this.decompressHandler.isEnabled()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Removing encoding...", (Object[])new Object[0]);
            }
            while (!this.tempBuffers.isEmpty()) {
                WsByteBuffer buffer = this.tempBuffers.removeFirst();
                while (buffer.hasRemaining()) {
                    try {
                        List<WsByteBuffer> list = this.decompressHandler.decompress(buffer);
                        if (list.isEmpty()) continue;
                        this.storage.addAll(list);
                        rc = true;
                    }
                    catch (DataFormatException dfe) {
                        FFDCFilter.processException((Throwable)dfe, (String)(this.getClass().getName() + ".moveBuffers"), (String)"1");
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Received exception during decompress; " + dfe), (Object[])new Object[0]);
                        }
                        throw new IllegalHttpBodyException(dfe.getMessage());
                    }
                }
                buffer.release();
            }
            HttpBaseMessageImpl msg = this.getMessageBeingParsed();
            if (!msg.containsHeader(HttpHeaderKeys.HDR_$WSZIP)) {
                msg.removeOutermostEncoding();
                if (this.isContentLength()) {
                    msg.setHeader((HeaderKeys)HttpHeaderKeys.HDR_$WSORIGCL, Long.toString(this.getContentLength()));
                }
                if (this.isBodyComplete()) {
                    int newlen = (int)this.decompressHandler.getBytesWritten();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Setting decompressed Content-Length old: " + this.getContentLength() + " new: " + newlen), (Object[])new Object[0]);
                    }
                    msg.setContentLength(newlen);
                } else {
                    msg.removeHeader(HttpHeaderKeys.HDR_CONTENT_LENGTH);
                    msg.setTransferEncoding(TransferEncodingValues.CHUNKED);
                }
            }
        } else {
            this.storage.addAll(this.tempBuffers);
            this.tempBuffers.clear();
            rc = true;
        }
        return rc;
    }

    private boolean readFullCL(HttpBaseMessageImpl msg, boolean async) throws BodyCompleteException, IllegalHttpBodyException, IOException {
        boolean bAsyncInProgress = false;
        if (-1L == this.getDataLength()) {
            bAsyncInProgress = this.readSingleBlock(msg, async);
        }
        while (0L < this.getDataLength() && !bAsyncInProgress) {
            bAsyncInProgress = this.readSingleBlock(msg, async);
        }
        if (!bAsyncInProgress && !this.moveBuffers()) {
            bAsyncInProgress = this.readFullCL(msg, async);
        }
        return bAsyncInProgress;
    }

    private boolean readFullBody(boolean async) throws IllegalHttpBodyException, BodyCompleteException {
        boolean bAsyncInProgress = false;
        while (!bAsyncInProgress && !this.isBodyComplete()) {
            bAsyncInProgress = this.readUntilEnd(async);
        }
        if (!(bAsyncInProgress || this.isBodyComplete() || this.moveBuffers())) {
            bAsyncInProgress = this.readFullBody(async);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("readFullBody returning " + bAsyncInProgress), (Object[])new Object[0]);
        }
        return bAsyncInProgress;
    }

    private boolean readFullChunk(HttpBaseMessageImpl msg, boolean async) throws BodyCompleteException, IllegalHttpBodyException, IOException {
        boolean bAsyncInProgress = false;
        if (0L == this.getDataLength()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Reached end of chunk", (Object[])new Object[0]);
            }
            this.setDataLength(-1L);
        }
        if (-1L == this.getDataLength()) {
            bAsyncInProgress = this.readSingleBlock(msg, async);
        }
        while (0L < this.getDataLength() && !bAsyncInProgress) {
            bAsyncInProgress = this.readSingleBlock(msg, async);
        }
        if (!bAsyncInProgress && !this.moveBuffers()) {
            bAsyncInProgress = this.readFullChunk(msg, async);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("readFullChunk returning " + bAsyncInProgress), (Object[])new Object[0]);
        }
        return bAsyncInProgress;
    }

    private boolean parseTrailers(HttpBaseMessageImpl msg, boolean async) {
        try {
            this.bParsingTrailers = true;
            boolean rc = false;
            while (!rc) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Parsing a buffer for trailer headers", (Object[])new Object[0]);
                }
                HttpTrailersImpl trailers = msg.createTrailers();
                this.addToIncomingMsgSize(this.getReadBuffer().remaining());
                rc = this.getHttpConfig().isBinaryTransportEnabled() ? trailers.parseBinaryHeaders(this.getReadBuffer(), HttpHeaderKeys.HDR_$WSAT) : trailers.parseHeaders(this.getReadBuffer(), true);
                if (rc || this.isReadDataAvailable()) continue;
                this.setBodyRC(TrailerCallback.getRef());
                if (!this.fillABuffer(1L, async, false)) continue;
                return true;
            }
            long extra = this.getReadBuffer().remaining();
            if (0L < extra) {
                this.addToIncomingMsgSize(-extra);
            }
        }
        catch (Exception mhe) {
            FFDCFilter.processException((Throwable)mhe, (String)(this.getClass().getName() + ".parseTrailers"), (String)"1915", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("parseTrailers caught exception: " + mhe), (Object[])new Object[0]);
            }
            this.setPersistent(false);
        }
        this.bParsingTrailers = false;
        return false;
    }

    private int convertCharToLength(int ch, int inLen) throws IllegalHttpBodyException {
        int mod;
        int length = inLen;
        if (-1 == length) {
            length = 0;
        }
        if (48 <= ch && 57 >= ch) {
            mod = ch - 48;
        } else if (97 <= ch && 102 >= ch) {
            mod = ch - 97 + 10;
        } else if (65 <= ch && 70 >= ch) {
            mod = ch - 65 + 10;
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Client sent a bad chunk: " + ch), (Object[])new Object[0]);
            }
            throw new IllegalHttpBodyException("Illegal chunk length digit: " + ch);
        }
        length <<= 4;
        return length += mod;
    }

    private int getSavedChunkLength() {
        return this.savedChunkLength;
    }

    private void setSavedChunkLength(int length) {
        this.savedChunkLength = length;
    }

    private int readChunkLength(WsByteBuffer buff) throws IllegalHttpBodyException {
        int position;
        if (null == buff) {
            return -1;
        }
        int length = this.getSavedChunkLength();
        int limit = buff.limit();
        byte ch = 0;
        if (15 == this.getChunkLengthParsingState()) {
            for (position = buff.position(); position < limit; ++position) {
                ch = buff.get();
                this.addToIncomingMsgSize(1L);
                if (13 == ch || 10 == ch) {
                    if (-1 == length) continue;
                    this.setChunkLengthParsingState(17);
                    break;
                }
                if (59 == ch || 32 == ch || 9 == ch) {
                    this.setChunkLengthParsingState(16);
                    break;
                }
                length = this.convertCharToLength(ch, length);
            }
            ++position;
        }
        if (16 == this.getChunkLengthParsingState()) {
            if (-1 == length) {
                throw new IllegalHttpBodyException("Missing chunk length");
            }
            while (position < limit) {
                ch = buff.get();
                this.addToIncomingMsgSize(1L);
                if (13 == ch || 10 == ch) {
                    this.setChunkLengthParsingState(17);
                    break;
                }
                ++position;
            }
            ++position;
        }
        if (17 == this.getChunkLengthParsingState() && position < limit) {
            ch = buff.get();
            this.addToIncomingMsgSize(1L);
            if (13 != ch && 10 != ch) {
                buff.position(position);
                ++position;
            }
            if (this.getHttpConfig().shouldWaitForEndOfMessage() && length == 0) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Parsing End of Message", (Object[])new Object[0]);
                }
                this.setChunkLengthParsingState(18);
                ++position;
            } else {
                this.setChunkLengthParsingState(0);
                this.setSavedChunkLength(-1);
                return length;
            }
        }
        if (18 == this.getChunkLengthParsingState() && position < limit) {
            this.setChunkLengthParsingState(0);
            this.setSavedChunkLength(-1);
            return length;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("readChunkLength: Not enough data, storing [" + length + "]"), (Object[])new Object[0]);
        }
        this.setSavedChunkLength(length);
        return -1;
    }

    public final int getOldLimit() {
        return this.oldLimit;
    }

    public final void setOldLimit(int limit) {
        this.oldLimit = limit;
    }

    private int getAmountBeingRead() {
        return this.amountBeingRead;
    }

    private void setAmountBeingRead(int amount) {
        this.amountBeingRead = amount;
    }

    protected final boolean fillABuffer(long amount, boolean async, boolean throwException) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("fillABuffer(i,b) " + amount + " " + async), (Object[])new Object[0]);
        }
        int size = this.getHttpConfig().getIncomingBodyBufferSize();
        if (amount < 1024L) {
            size = 1024;
        } else if (amount < (long)size) {
            size = (int)amount;
        }
        if (this.getHttpConfig().isJITOnlyReads()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Config forcing JIT read", (Object[])new Object[0]);
            }
            if (null != this.getReadBuffer() && !this.lastBufferContainsHeaders()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Returning non-header buffer before JIT read: " + this.getReadBuffer()), (Object[])new Object[0]);
                }
                this.returnLastBuffer().release();
            }
            this.setupJITRead(size);
        } else {
            WsByteBuffer currentBuffer = this.getReadBuffer();
            if (null == currentBuffer || currentBuffer.limit() == currentBuffer.capacity()) {
                if (null != currentBuffer && !this.lastBufferContainsHeaders()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Returning non-header buffer: " + currentBuffer), (Object[])new Object[0]);
                    }
                    this.returnLastBuffer().release();
                }
                this.setReadBuffer(this.allocateBuffer(size));
                this.getReadBuffer().clear();
                this.setOldLimit(0);
            } else {
                this.configurePreReadBuffer(currentBuffer);
            }
            size = this.getReadBuffer().capacity() - this.getOldLimit();
            this.setupNonJITRead();
        }
        this.setAmountBeingRead(amount > (long)size ? size : (int)amount);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Filling buffer " + this.getReadBuffer() + " with amount " + this.getAmountBeingRead()), (Object[])new Object[0]);
        }
        if (async) {
            VirtualConnection vc = this.getTSC().getReadInterface().read((long)this.getAmountBeingRead(), this.getBodyRC(), this.isForceAsync(), this.getReadTimeout());
            if (null == vc) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"fillABuffer(i,b): async read in progress", (Object[])new Object[0]);
                }
                return true;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"fillABuffer(i,b) read() returned immediately", (Object[])new Object[0]);
            }
        } else {
            try {
                this.getTSC().getReadInterface().read((long)this.getAmountBeingRead(), this.getReadTimeout());
                this.setAmountBeingRead(0);
            }
            catch (IOException ioe) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("IOException, closing the reads: " + ioe), (Object[])new Object[0]);
                }
                this.prepareClosure();
                if (throwException) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Throwing exception back to caller.", (Object[])new Object[0]);
                    }
                    throw ioe;
                }
                return false;
            }
        }
        this.getNextReadBuffer();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("fillABuffer(i,b) data ready in " + this.getReadBuffer()), (Object[])new Object[0]);
        }
        return false;
    }

    protected void clearStorage() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Clearing buffer storage; size=" + this.storage.size()), (Object[])new Object[0]);
        }
        while (!this.storage.isEmpty()) {
            WsByteBuffer buffer = this.storage.removeFirst();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Releasing: " + buffer), (Object[])new Object[0]);
            }
            buffer.release();
        }
    }

    protected void clearTempStorage() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Clearing temp storage; size=" + this.tempBuffers.size()), (Object[])new Object[0]);
        }
        while (!this.tempBuffers.isEmpty()) {
            WsByteBuffer buffer = this.tempBuffers.removeFirst();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Releasing: " + buffer), (Object[])new Object[0]);
            }
            buffer.release();
        }
    }

    protected final void debugPrintStorage(WsByteBuffer[] buffers) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            for (int i = 0; i < buffers.length; ++i) {
                Tr.debug((TraceComponent)tc, (String)("debug: buffers[" + i + "]: " + (null != buffers[i] ? WsByteBufferUtils.asString((WsByteBuffer)buffers[i]) : "null")), (Object[])new Object[0]);
            }
        }
    }

    protected WsByteBuffer[] getAllStorageBuffers() {
        if (this.storage.isEmpty()) {
            return null;
        }
        WsByteBuffer[] output = new WsByteBuffer[this.storage.size()];
        this.storage.toArray(output);
        this.storage.clear();
        return output;
    }

    protected WsByteBuffer[] queryAllStorageBuffers() {
        if (this.storage.isEmpty()) {
            return null;
        }
        WsByteBuffer[] output = new WsByteBuffer[this.storage.size()];
        this.storage.toArray(output);
        return output;
    }

    protected void setupDecompressionHandler() {
        if (null != this.decompressHandler) {
            return;
        }
        this.decompressHandler = !this.getHttpConfig().isAutoDecompressionEnabled() || this.isRawBody() ? new IdentityInputHandler() : (ContentEncodingValues.GZIP.equals(this.incomingMsgEncoding) ? new GzipInputHandler() : (ContentEncodingValues.XGZIP.equals(this.incomingMsgEncoding) ? new GzipInputHandler() : (ContentEncodingValues.DEFLATE.equals(this.incomingMsgEncoding) ? new DeflateInputHandler() : new IdentityInputHandler())));
    }

    private void setupCompressionHandler(HttpBaseMessageImpl msg) {
        if (!this.isOutgoingBodyValid() && this.isOutgoingMsgEncoded()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Removing disallowed encoding request flag: " + this.outgoingMsgEncoding), (Object[])new Object[0]);
            }
            this.outgoingMsgEncoding = DEFAULT_ENCODING;
            return;
        }
        if (this.isAutoCompression(msg)) {
            if (this.isGZipEncoded() || this.isXGZipEncoded()) {
                this.compressHandler = new GzipOutputHandler(this.isXGZipEncoded());
            } else if (this.isZlibEncoded()) {
                this.compressHandler = this.isInboundConnection() ? new DeflateOutputHandler(this.getRequest().getHeader(HttpHeaderKeys.HDR_USER_AGENT).asBytes()) : new DeflateOutputHandler();
            }
        }
        if (null != this.compressHandler && msg.shouldUpdateBodyHeaders()) {
            msg.removeHeader(HttpHeaderKeys.HDR_CONTENT_LENGTH);
        }
    }

    public final void prepareClosure() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Preparing connection for closure", (Object[])new Object[0]);
        }
        this.setPersistent(false);
        this.setBodyComplete();
        this.setDataLength(0L);
        this.setAmountBeingRead(0);
        this.getTSC().getReadInterface().setBuffers(null);
        try {
            this.moveBuffers();
        }
        catch (IllegalHttpBodyException illegalHttpBodyException) {
            // empty catch block
        }
    }

    protected WsByteBuffer getNextBuffer() {
        WsByteBuffer buffer;
        WsByteBuffer wsByteBuffer = buffer = !this.storage.isEmpty() ? this.storage.removeFirst() : null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getNextBuffer returning " + buffer), (Object[])new Object[0]);
        }
        return buffer;
    }

    protected void storeTempBuffer(WsByteBuffer buffer) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Storing buffer: " + buffer), (Object[])new Object[0]);
        }
        if (null == this.decompressHandler || !this.decompressHandler.isEnabled()) {
            this.storage.add(buffer);
        } else {
            this.tempBuffers.add(buffer);
        }
    }

    private void storeBuffer(WsByteBuffer buffer) {
        this.storage.add(buffer);
    }

    protected final void setMultiRead(boolean bRead) {
        this.bIsMultiRead = bRead;
    }

    private boolean isMultiRead() {
        return this.bIsMultiRead;
    }

    public final void continueRead() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Continuing read...", (Object[])new Object[0]);
        }
        HttpBaseMessageImpl msg = this.getMessageBeingParsed();
        if (this.bParsingTrailers) {
            if (!this.parseTrailers(msg, true)) {
                this.getAppReadCallback().complete(this.getVC());
            }
            return;
        }
        if (!this.incomingBuffersReady() && this.isBodyComplete()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Nothing to read", (Object[])new Object[0]);
            }
            return;
        }
        this.getNextReadBuffer();
        try {
            boolean rc;
            boolean bl = rc = this.isMultiRead() ? this.readBodyBuffers(msg, true) : this.readBodyBuffer(msg, true);
            if (!rc) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Calling complete on application channel.", (Object[])new Object[0]);
                }
                this.getAppReadCallback().complete(this.getVC());
            }
        }
        catch (IOException ioe) {
            this.getAppReadCallback().error(this.getVC(), (Throwable)ioe);
            return;
        }
        catch (BodyCompleteException bce) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Unexpected exception: " + bce), (Object[])new Object[0]);
            }
            this.getAppReadCallback().error(this.getVC(), (Throwable)bce);
            return;
        }
    }

    @Override
    public SSLConnectionContext getSSLContext() {
        return this.myTSC.getSSLContext();
    }

    @Override
    public void abort() {
        block6: {
            block5: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("Attempting to abort current and future IO: " + this.getVC()), (Object[])new Object[0]);
                }
                try {
                    this.myTSC.getReadInterface().read(1L, -3);
                }
                catch (Throwable t) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block5;
                    Tr.event((TraceComponent)tc, (String)("Error aborting read: " + t), (Object[])new Object[0]);
                }
            }
            try {
                this.myTSC.getWriteInterface().write(1L, -3);
            }
            catch (Throwable t) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block6;
                Tr.event((TraceComponent)tc, (String)("Error aborting write: " + t), (Object[])new Object[0]);
            }
        }
    }

    @Override
    public boolean cancelOutstandingRead() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Attempting to cancel an outstanding read: " + this.getVC()), (Object[])new Object[0]);
        }
        try {
            this.myTSC.getReadInterface().read(1L, null, false, -2);
        }
        catch (IllegalArgumentException iae) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"cancelOutstandingRead: tcp layer does not support", (Object[])new Object[0]);
            }
            return false;
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)(this.getClass().getName() + ".cancelOutstandingRead"), (String)"1");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("cancelOutstandingRead: unexpected exception from tcp: " + t), (Object[])new Object[0]);
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean cancelOutstandingWrite() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Attempting to cancel an outstanding write: " + this.getVC()), (Object[])new Object[0]);
        }
        try {
            this.myTSC.getWriteInterface().write(1L, null, false, -2);
        }
        catch (IllegalArgumentException iae) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"cancelOutstandingWrite: tcp layer does not support", (Object[])new Object[0]);
            }
            return false;
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)(this.getClass().getName() + ".cancelOutstandingWrite"), (String)"1");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("cancelOutstandingWrite: unexpected exception from tcp: " + t), (Object[])new Object[0]);
            }
            return false;
        }
        return true;
    }

    public CancelIOWrapper getReadCancel() {
        if (null == this.cancelRead) {
            this.cancelRead = new CancelIOWrapper();
        }
        return this.cancelRead;
    }

    public CancelIOWrapper getWriteCancel() {
        if (null == this.cancelWrite) {
            this.cancelWrite = new CancelIOWrapper();
        }
        return this.cancelWrite;
    }

    public boolean markReadCancelSuccess() {
        if (this.getReadCancel().success()) {
            if (null != this.getReadBuffer()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Reset after canceled read is updating buffer: " + this.getReadBuffer()), (Object[])new Object[0]);
                }
                this.getReadBuffer().limit(this.getReadBuffer().position());
            }
            return true;
        }
        return false;
    }

    public boolean markWriteCancelSuccess() {
        return this.getWriteCancel().success();
    }

    public void markReadCancelFailure() {
        this.getReadCancel().failure();
    }

    public void markWriteCancelFailure() {
        this.getWriteCancel().failure();
    }

    protected WsByteBuffer[] loadErrorBody(HttpError error, HttpRequestMessage request, HttpResponseMessage response) {
        HttpErrorPageProvider provider;
        WsByteBuffer[] body = error.getErrorBody();
        if (null != body) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("HttpError returned body of length=" + body.length), (Object[])new Object[0]);
            }
            this.getVC().getStateMap().put(EPS_KEY, body);
            return body;
        }
        HttpErrorPageService eps = (HttpErrorPageService)HttpDispatcher.getFramework().lookupService(HttpErrorPageService.class);
        if (null == eps) {
            return null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Querying service for port=" + this.getLocalPort()), (Object[])new Object[0]);
        }
        if (null != (provider = eps.access(this.getLocalPort()))) {
            block10: {
                String host = this.getLocalAddr().getHostName();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Querying provider for host=" + host), (Object[])new Object[0]);
                }
                try {
                    body = provider.accessPage(host, this.getLocalPort(), request, response);
                }
                catch (Throwable t) {
                    FFDCFilter.processException((Throwable)t, (String)(this.getClass().getName() + ".loadErrorBody"), (String)"1");
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block10;
                    Tr.debug((TraceComponent)tc, (String)("Exception while calling into provider, t=" + t), (Object[])new Object[0]);
                }
            }
            if (null != body) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Received body of length=" + body.length), (Object[])new Object[0]);
                }
                this.getVC().getStateMap().put(EPS_KEY, body);
            }
        }
        return body;
    }

    @Override
    public final InetAddress getRemoteAddr() {
        return this.myRemoteAddr;
    }

    public final void setRemoteAddr(InetAddress addr) {
        this.myRemoteAddr = addr;
    }

    @Override
    public final InetAddress getLocalAddr() {
        return this.myLocalAddr;
    }

    public final void setLocalAddr(InetAddress addr) {
        this.myLocalAddr = addr;
    }

    @Override
    public final int getRemotePort() {
        return this.myRemotePort;
    }

    public final void setRemotePort(int port) {
        this.myRemotePort = port;
    }

    @Override
    public final int getLocalPort() {
        return this.myLocalPort;
    }

    public final void setLocalPort(int port) {
        this.myLocalPort = port;
    }

    public WsByteBuffer returnLastBuffer() {
        WsByteBuffer buffer = this.currentReadBB;
        this.allocatedBuffers.remove(buffer);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Returning " + buffer), (Object[])new Object[0]);
        }
        return buffer;
    }

    protected void setLastHeaderBuffer() {
        this.lastHeaderBuffer = this.allocatedBuffers.size();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Last header buffer: " + this.lastHeaderBuffer), (Object[])new Object[0]);
        }
    }

    protected boolean lastBufferContainsHeaders() {
        return -1 == this.lastHeaderBuffer || this.allocatedBuffers.size() <= this.lastHeaderBuffer;
    }

    public void storeAllocatedBuffer(WsByteBuffer buffer) {
        this.allocatedBuffers.add(buffer);
    }

    public void storeAllocatedBuffers(WsByteBuffer[] list) {
        for (int i = 0; i < list.length; ++i) {
            this.allocatedBuffers.add(list[i]);
        }
    }

    @Override
    public HttpDateFormat getDateFormatter() {
        return HttpDispatcher.getDateFormatter();
    }

    @Override
    public EncodingUtils getEncodingUtils() {
        return HttpDispatcher.getEncodingUtils();
    }

    @Override
    public abstract long getStartNanoTime();

    @Override
    public abstract void resetStartTime();

    @Override
    public abstract void setStartTime();

    public boolean isPushPromise() {
        return this.isPushPromise;
    }

    public void setPushPromise(boolean isPushPromise) {
        this.isPushPromise = isPushPromise;
    }

    public boolean isH2Connection() {
        return this.isH2Connection;
    }

    public void setH2Connection(boolean isH2Connection) {
        this.isH2Connection = isH2Connection;
    }

    private void handleH2LinkPreload(HeaderField header, HttpInboundLink link) {
        H2StreamProcessor existingSP;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"handleH2LinkPreload()", (Object[])new Object[0]);
        }
        int streamId = ((H2HttpInboundLinkWrap)link).getStreamId();
        String uri = header.asString().substring(header.asString().indexOf(60) + 1, header.asString().indexOf(62));
        H2HeaderTable h2WriteTable = ((H2HttpInboundLinkWrap)link).muxLink.getWriteTable();
        ByteArrayOutputStream ppHb = new ByteArrayOutputStream();
        try {
            ppHb.write(H2Headers.encodeHeader(h2WriteTable, ":method", "GET", HpackConstants.LiteralIndexType.NOINDEXING));
            String scheme = new String("https");
            if (!this.isSecure()) {
                scheme = new String("http");
            }
            ppHb.write(H2Headers.encodeHeader(h2WriteTable, ":scheme", scheme, HpackConstants.LiteralIndexType.NOINDEXING));
            ppHb.write(H2Headers.encodeHeader(h2WriteTable, ":path", uri, HpackConstants.LiteralIndexType.NOINDEXING));
            String auth = ((H2HttpInboundLinkWrap)link).muxLink.getAuthority();
            if (null == auth) {
                auth = this.getLocalAddr().getHostName();
                if (null != auth) {
                    if (0 <= this.getLocalPort()) {
                        auth = auth + ":" + Integer.toString(this.getLocalPort());
                    }
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"handleH2LinkPreload(): Cannot find hostname for required :authority pseudo header");
                    }
                    return;
                }
            }
            ppHb.write(H2Headers.encodeHeader(h2WriteTable, ":authority", auth, HpackConstants.LiteralIndexType.NOINDEXING));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("handleH2LinkPreload(): Method is GET, authority is " + auth + ", scheme is " + scheme), (Object[])new Object[0]);
            }
        }
        catch (IOException ioe) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("handleH2LinkPreload(): The attempt to write an HTTP/2 Push Promise frame resulted in an IOException. Exception {0}" + ioe));
            }
            return;
        }
        catch (CompressionException ce) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("handleH2LinkPreload(): The attempt to encode an HTTP/2 Push Promise frame resulted in a CompressionException. Exception {0}" + ce));
            }
            return;
        }
        int promisedStreamId = ((H2HttpInboundLinkWrap)link).muxLink.getNextPromisedStreamId();
        FramePushPromise pushPromiseFrame = new FramePushPromise(streamId, ppHb.toByteArray(), promisedStreamId, 0, true, false, false);
        FramePPHeaders headersFrame = new FramePPHeaders(streamId, ppHb.toByteArray());
        H2StreamProcessor promisedSP = ((H2HttpInboundLinkWrap)link).muxLink.createNewInboundLink(promisedStreamId);
        if (promisedSP == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("handleH2LinkPreload exit; cannot create new push stream - the max number of concurrent streams has already been reached on link: " + (Object)((Object)link)));
            }
            return;
        }
        ((H2HttpInboundLinkWrap)link).setPushPromise(true);
        promisedSP.initializePromisedStream();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("handleH2LinkPreload(): push_promise stream-id is " + promisedStreamId), (Object[])new Object[0]);
        }
        if ((existingSP = ((H2HttpInboundLinkWrap)link).muxLink.getStreamProcessor(streamId)) != null) {
            try {
                existingSP.processNextFrame(pushPromiseFrame, Constants.Direction.WRITING_OUT);
            }
            catch (Http2Exception e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)("handleH2LinkPreload(): Protocol exception when sending the push_promise frame: " + e));
                }
                return;
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("handleH2LinkPreload(): The push_promise stream-id " + streamId + " has been closed."));
            }
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("handleH2LinkPreload(): Push promise frame sent on stream-id " + streamId), (Object[])new Object[0]);
        }
        promisedSP.sendRequestToWc(headersFrame);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"handleH2LinkPreload()");
        }
    }
}

