/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.faulttolerance20.state.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.microprofile.faulttolerance.spi.MetricRecorder;
import com.ibm.ws.microprofile.faulttolerance.spi.TimeoutPolicy;
import com.ibm.ws.microprofile.faulttolerance20.state.TimeoutState;
import com.ibm.ws.microprofile.faulttolerance20.state.impl.DurationUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class TimeoutStateImpl
implements TimeoutState {
    private final ScheduledExecutorService executorService;
    private final TimeoutPolicy policy;
    private TimeoutResult result = TimeoutResult.NEW;
    private Runnable timeoutCallback;
    private Future<?> timeoutFuture;
    private long startTime;
    private final MetricRecorder metrics;
    static final long serialVersionUID = 200158777795143239L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public TimeoutStateImpl(ScheduledExecutorService executorService, TimeoutPolicy policy, MetricRecorder metrics) {
        this.executorService = executorService;
        this.policy = policy;
        this.metrics = metrics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        TimeoutStateImpl timeoutStateImpl = this;
        synchronized (timeoutStateImpl) {
            if (this.result != TimeoutResult.NEW) {
                throw new IllegalStateException("Start called twice on the same timeout");
            }
            this.startTime = System.nanoTime();
            this.result = TimeoutResult.STARTED;
            if (!this.policy.getTimeout().isZero()) {
                this.timeoutFuture = this.executorService.schedule(this::timeout, DurationUtils.asClampedNanos(this.policy.getTimeout()), TimeUnit.NANOSECONDS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTimeoutCallback(Runnable timeoutCallback) {
        TimeoutStateImpl timeoutStateImpl = this;
        synchronized (timeoutStateImpl) {
            if (timeoutCallback == null) {
                throw new NullPointerException("setTimeoutCallback called with null value");
            }
            if (this.timeoutCallback != null) {
                throw new IllegalStateException("setTimeoutCallback called more than once");
            }
            this.timeoutCallback = timeoutCallback;
            if (this.result == TimeoutResult.TIMEDOUT && timeoutCallback != null) {
                timeoutCallback.run();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        TimeoutStateImpl timeoutStateImpl = this;
        synchronized (timeoutStateImpl) {
            switch (this.result) {
                case NEW: 
                case STARTED: {
                    this.result = TimeoutResult.FINISHED;
                    this.metrics.incrementTimeoutFalseCount();
                    this.recordExecutionTime();
                    if (this.timeoutFuture == null) break;
                    this.timeoutFuture.cancel(false);
                    break;
                }
                case FINISHED: {
                    throw new IllegalStateException("Stop called twice on the same timeout");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTimedOut() {
        TimeoutStateImpl timeoutStateImpl = this;
        synchronized (timeoutStateImpl) {
            return this.result == TimeoutResult.TIMEDOUT;
        }
    }

    private void recordExecutionTime() {
        long endTime = System.nanoTime();
        this.metrics.recordTimeoutExecutionTime(endTime - this.startTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void timeout() {
        TimeoutStateImpl timeoutStateImpl = this;
        synchronized (timeoutStateImpl) {
            switch (this.result) {
                case NEW: {
                    throw new IllegalStateException("Timeout called on a timeout that was never started");
                }
                case STARTED: {
                    this.result = TimeoutResult.TIMEDOUT;
                    this.metrics.incrementTimeoutTrueCount();
                    this.recordExecutionTime();
                    if (this.timeoutCallback == null) break;
                    this.timeoutCallback.run();
                    break;
                }
                case FINISHED: 
                case TIMEDOUT: {
                    throw new IllegalStateException("Timeout called more than once on the same timeout");
                }
            }
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(TimeoutStateImpl.class);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static final class TimeoutResult
    extends Enum<TimeoutResult> {
        public static final /* enum */ TimeoutResult NEW;
        public static final /* enum */ TimeoutResult STARTED;
        public static final /* enum */ TimeoutResult FINISHED;
        public static final /* enum */ TimeoutResult TIMEDOUT;
        private static final /* synthetic */ TimeoutResult[] $VALUES;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public static TimeoutResult[] values() {
            return (TimeoutResult[])$VALUES.clone();
        }

        public static TimeoutResult valueOf(String name) {
            return Enum.valueOf(TimeoutResult.class, name);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(TimeoutResult.class);
            NEW = new TimeoutResult();
            STARTED = new TimeoutResult();
            FINISHED = new TimeoutResult();
            TIMEDOUT = new TimeoutResult();
            $VALUES = new TimeoutResult[]{NEW, STARTED, FINISHED, TIMEDOUT};
        }
    }
}

