/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.faulttolerance20.state.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.microprofile.faulttolerance.spi.CircuitBreakerPolicy;
import com.ibm.ws.microprofile.faulttolerance.spi.MetricRecorder;
import com.ibm.ws.microprofile.faulttolerance20.impl.MethodResult;
import com.ibm.ws.microprofile.faulttolerance20.state.CircuitBreakerState;
import com.ibm.ws.microprofile.faulttolerance20.state.impl.CircuitBreakerRollingWindow;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.concurrent.atomic.AtomicReference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class CircuitBreakerStateImpl
implements CircuitBreakerState {
    private static final TraceComponent tc = Tr.register(CircuitBreakerStateImpl.class);
    private final CircuitBreakerPolicy policy;
    private final MetricRecorder metricRecorder;
    private final AtomicReference<State> state;
    private final long policyDelayNanos;
    private final CircuitBreakerRollingWindow rollingWindow;
    private int halfOpenRunningExecutions;
    private int halfOpenSuccessfulExecutions;
    private long halfOpenLastExecutionStarted;
    private long openStateStartTime;
    static final long serialVersionUID = 6623915330072259846L;

    public CircuitBreakerStateImpl(CircuitBreakerPolicy policy, MetricRecorder metricRecorder) {
        this.policy = policy;
        this.metricRecorder = metricRecorder;
        this.policyDelayNanos = policy.getDelay().toNanos();
        this.state = new AtomicReference<State>(State.CLOSED);
        this.rollingWindow = new CircuitBreakerRollingWindow(policy.getRequestVolumeThreshold(), policy.getFailureRatio());
        this.halfOpenRunningExecutions = 0;
        this.halfOpenSuccessfulExecutions = 0;
        this.halfOpenLastExecutionStarted = 0L;
        this.openStateStartTime = 0L;
    }

    @Override
    public boolean requestPermissionToExecute() {
        boolean result;
        if (this.state.get() == State.CLOSED) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Allowing execution in closed state", (Object[])new Object[0]);
            }
            result = true;
        } else {
            result = this.synchronizedRequestPermissionToExecute();
        }
        if (!result) {
            this.metricRecorder.incrementCircuitBreakerCallsCircuitOpenCount();
        }
        return result;
    }

    @Override
    public void recordResult(MethodResult<?> result) {
        CircuitBreakerResult cbResult = this.getCircuitBreakerResult(result);
        if (this.state.get() == State.OPEN) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Recording result {0} in open state", (Object[])new Object[]{cbResult});
            }
        } else {
            this.synchronizedRecordResult(cbResult);
        }
        if (cbResult == CircuitBreakerResult.SUCCESS) {
            this.metricRecorder.incrementCircuitBreakerCallsSuccessCount();
        } else {
            this.metricRecorder.incrementCircuitBreakerCallsFailureCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean synchronizedRequestPermissionToExecute() {
        boolean result = false;
        CircuitBreakerStateImpl circuitBreakerStateImpl = this;
        synchronized (circuitBreakerStateImpl) {
            switch (this.state.get()) {
                case CLOSED: {
                    result = true;
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break;
                    Tr.debug((TraceComponent)tc, (String)"Allowing execution in closed state", (Object[])new Object[0]);
                    break;
                }
                case HALF_OPEN: {
                    if (this.halfOpenRunningExecutions < this.policy.getSuccessThreshold()) {
                        ++this.halfOpenRunningExecutions;
                        this.halfOpenLastExecutionStarted = System.nanoTime();
                        result = true;
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break;
                        Tr.debug((TraceComponent)tc, (String)"Allowing execution in half-open state. Now running ({0}/{1})", (Object[])new Object[]{this.halfOpenRunningExecutions, this.policy.getSuccessThreshold()});
                        break;
                    }
                    if (System.nanoTime() - this.halfOpenLastExecutionStarted > this.policyDelayNanos) {
                        this.halfOpenLastExecutionStarted = System.nanoTime();
                        result = true;
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break;
                        Tr.debug((TraceComponent)tc, (String)"Allowing execution in half-open state because enough time has passed without a trial executions completing", (Object[])new Object[0]);
                        break;
                    }
                    result = false;
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break;
                    Tr.debug((TraceComponent)tc, (String)"Denying execution in half-open state, trial execution limit reached", (Object[])new Object[0]);
                    break;
                }
                case OPEN: {
                    if (System.nanoTime() - this.openStateStartTime > this.policyDelayNanos) {
                        this.stateHalfOpen();
                        ++this.halfOpenRunningExecutions;
                        this.halfOpenLastExecutionStarted = System.nanoTime();
                        result = true;
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break;
                        Tr.debug((TraceComponent)tc, (String)"Allowing execution because we just changed to half-open state", (Object[])new Object[0]);
                        break;
                    }
                    result = false;
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break;
                    Tr.debug((TraceComponent)tc, (String)"Denying execution in open state", (Object[])new Object[0]);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void synchronizedRecordResult(CircuitBreakerResult result) {
        CircuitBreakerStateImpl circuitBreakerStateImpl = this;
        synchronized (circuitBreakerStateImpl) {
            switch (this.state.get()) {
                case CLOSED: {
                    this.rollingWindow.record(result);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Recording result {0} in closed state: {1}", (Object[])new Object[]{result, this.rollingWindow});
                    }
                    if (!this.rollingWindow.isOverThreshold()) break;
                    this.stateOpen();
                    break;
                }
                case HALF_OPEN: {
                    if (result == CircuitBreakerResult.FAILURE) {
                        this.stateOpen();
                        break;
                    }
                    --this.halfOpenRunningExecutions;
                    ++this.halfOpenSuccessfulExecutions;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Recording result {0} in half-open state. Running executions: {1}, Current results: ({2}/{3})", (Object[])new Object[]{result, this.halfOpenRunningExecutions, this.halfOpenSuccessfulExecutions, this.policy.getSuccessThreshold()});
                    }
                    if (this.halfOpenSuccessfulExecutions < this.policy.getSuccessThreshold()) break;
                    this.stateClosed();
                    break;
                }
                case OPEN: {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break;
                    Tr.debug((TraceComponent)tc, (String)"Recording result {0} in open state", (Object[])new Object[]{result});
                }
            }
        }
    }

    @Trivial
    private void stateClosed() {
        this.rollingWindow.clear();
        this.state.set(State.CLOSED);
        this.metricRecorder.reportCircuitClosed();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Transitioned to Closed state", (Object[])new Object[0]);
        }
    }

    @Trivial
    private void stateHalfOpen() {
        this.halfOpenRunningExecutions = 0;
        this.halfOpenSuccessfulExecutions = 0;
        this.state.set(State.HALF_OPEN);
        this.metricRecorder.reportCircuitHalfOpen();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Transitioned to Half Open state", (Object[])new Object[0]);
        }
    }

    @Trivial
    private void stateOpen() {
        this.openStateStartTime = System.nanoTime();
        this.state.set(State.OPEN);
        this.metricRecorder.reportCircuitOpen();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Transitioned to Open state", (Object[])new Object[0]);
        }
    }

    @Trivial
    private CircuitBreakerResult getCircuitBreakerResult(MethodResult<?> result) {
        CircuitBreakerResult cbResult = CircuitBreakerResult.SUCCESS;
        if (result.isFailure()) {
            for (Class exClazz : this.policy.getFailOn()) {
                if (!exClazz.isInstance(result.getFailure())) continue;
                cbResult = CircuitBreakerResult.FAILURE;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Circuit breaker considers {0} to be {1}", (Object[])new Object[]{result, cbResult});
        }
        return cbResult;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static final class State
    extends Enum<State> {
        public static final /* enum */ State OPEN;
        public static final /* enum */ State HALF_OPEN;
        public static final /* enum */ State CLOSED;
        private static final /* synthetic */ State[] $VALUES;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String name) {
            return Enum.valueOf(State.class, name);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(State.class);
            OPEN = new State();
            HALF_OPEN = new State();
            CLOSED = new State();
            $VALUES = new State[]{OPEN, HALF_OPEN, CLOSED};
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    public static final class CircuitBreakerResult
    extends Enum<CircuitBreakerResult> {
        public static final /* enum */ CircuitBreakerResult SUCCESS;
        public static final /* enum */ CircuitBreakerResult FAILURE;
        private static final /* synthetic */ CircuitBreakerResult[] $VALUES;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public static CircuitBreakerResult[] values() {
            return (CircuitBreakerResult[])$VALUES.clone();
        }

        public static CircuitBreakerResult valueOf(String name) {
            return Enum.valueOf(CircuitBreakerResult.class, name);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(CircuitBreakerResult.class);
            SUCCESS = new CircuitBreakerResult();
            FAILURE = new CircuitBreakerResult();
            $VALUES = new CircuitBreakerResult[]{SUCCESS, FAILURE};
        }
    }
}

