/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.faulttolerance20.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.microprofile.faulttolerance.spi.BulkheadPolicy;
import com.ibm.ws.microprofile.faulttolerance.spi.CircuitBreakerPolicy;
import com.ibm.ws.microprofile.faulttolerance.spi.ExecutionException;
import com.ibm.ws.microprofile.faulttolerance.spi.Executor;
import com.ibm.ws.microprofile.faulttolerance.spi.FTExecutionContext;
import com.ibm.ws.microprofile.faulttolerance.spi.FallbackPolicy;
import com.ibm.ws.microprofile.faulttolerance.spi.MetricRecorder;
import com.ibm.ws.microprofile.faulttolerance.spi.RetryPolicy;
import com.ibm.ws.microprofile.faulttolerance.spi.TimeoutPolicy;
import com.ibm.ws.microprofile.faulttolerance20.impl.MethodResult;
import com.ibm.ws.microprofile.faulttolerance20.impl.SyncExecutionContextImpl;
import com.ibm.ws.microprofile.faulttolerance20.state.CircuitBreakerState;
import com.ibm.ws.microprofile.faulttolerance20.state.FaultToleranceStateFactory;
import com.ibm.ws.microprofile.faulttolerance20.state.RetryState;
import com.ibm.ws.microprofile.faulttolerance20.state.SyncBulkheadState;
import com.ibm.ws.microprofile.faulttolerance20.state.TimeoutState;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.eclipse.microprofile.faulttolerance.ExecutionContext;
import org.eclipse.microprofile.faulttolerance.exceptions.CircuitBreakerOpenException;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceException;
import org.eclipse.microprofile.faulttolerance.exceptions.TimeoutException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class SyncExecutor<R>
implements Executor<R> {
    private static final TraceComponent tc = Tr.register(SyncExecutor.class);
    private final RetryPolicy retryPolicy;
    private final CircuitBreakerState circuitBreaker;
    private final ScheduledExecutorService executorService;
    private final TimeoutPolicy timeoutPolicy;
    private final FallbackPolicy fallbackPolicy;
    private final SyncBulkheadState bulkhead;
    private final MetricRecorder metricRecorder;
    static final long serialVersionUID = 5377827765251228530L;

    public SyncExecutor(RetryPolicy retry, CircuitBreakerPolicy cbPolicy, TimeoutPolicy timeoutPolicy, FallbackPolicy fallbackPolicy, BulkheadPolicy bulkheadPolicy, ScheduledExecutorService executorService, MetricRecorder metricRecorder) {
        this.retryPolicy = retry;
        this.circuitBreaker = FaultToleranceStateFactory.INSTANCE.createCircuitBreakerState(cbPolicy, metricRecorder);
        this.timeoutPolicy = timeoutPolicy;
        this.executorService = executorService;
        this.fallbackPolicy = fallbackPolicy;
        this.bulkhead = FaultToleranceStateFactory.INSTANCE.createSyncBulkheadState(bulkheadPolicy, metricRecorder);
        this.metricRecorder = metricRecorder;
    }

    /*
     * WARNING - void declaration
     */
    public R execute(Callable<R> callable, ExecutionContext context) {
        MethodResult<R> result;
        try {
            result = this.run(callable, context);
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.microprofile.faulttolerance20.impl.SyncExecutor", (String)"76", (Object)this, (Object[])new Object[]{callable, context});
            Tr.error((TraceComponent)tc, (String)"internal.error.CWMFT4998E", (Object[])new Object[]{e});
            throw new FaultToleranceException(Tr.formatMessage((TraceComponent)tc, (String)"internal.error.CWMFT4998E", (Object[])new Object[]{e}), (Throwable)e);
        }
        if (result.isFailure()) {
            if (result.getFailure() instanceof FaultToleranceException) {
                throw (FaultToleranceException)result.getFailure();
            }
            throw new ExecutionException(result.getFailure());
        }
        return result.getResult();
    }

    private MethodResult<R> run(Callable<R> callable, ExecutionContext context) {
        SyncExecutionContextImpl executionContext = (SyncExecutionContextImpl)context;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"Execution {0} Fault tolerance execution started for {1}", (Object[])new Object[]{executionContext.getId(), context.getMethod()});
        }
        Thread runningThread = Thread.currentThread();
        MethodResult<R> result = null;
        boolean done = false;
        RetryState retryContext = FaultToleranceStateFactory.INSTANCE.createRetryState(this.retryPolicy, this.metricRecorder);
        retryContext.start();
        while (!done) {
            RetryState.RetryResult retryResult;
            result = null;
            TimeoutState timeoutState = FaultToleranceStateFactory.INSTANCE.createTimeoutState(this.executorService, this.timeoutPolicy, this.metricRecorder);
            boolean circuitBreakerPermissionGiven = this.circuitBreaker.requestPermissionToExecute();
            if (!circuitBreakerPermissionGiven) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Execution {0} attempt Circuit Breaker open, not executing", (Object[])new Object[]{executionContext.getId()});
                }
                result = MethodResult.failure(new CircuitBreakerOpenException());
            }
            if (result == null) {
                timeoutState.setTimeoutCallback(() -> runningThread.interrupt());
                timeoutState.start();
                result = this.bulkhead.run(callable);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Execution {0} attempt result: {1}", (Object[])new Object[]{executionContext.getId(), result});
                }
                timeoutState.stop();
            }
            if (timeoutState.isTimedOut()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Execution {0} finished but has timed out, result changed to TimeoutException", (Object[])new Object[]{executionContext.getId()});
                }
                result = MethodResult.failure((Throwable)new TimeoutException());
                Thread.interrupted();
            }
            if (circuitBreakerPermissionGiven) {
                this.circuitBreaker.recordResult(result);
            }
            if (!(retryResult = retryContext.recordResult(result)).shouldRetry()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Execution {0} not retrying: {1}", (Object[])new Object[]{executionContext.getId(), retryResult});
                }
                done = true;
                continue;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Execution {0} retrying with delay: {1} {2}", (Object[])new Object[]{executionContext.getId(), retryResult.getDelay(), retryResult.getDelayUnit()});
            }
            try {
                Thread.sleep(TimeUnit.MILLISECONDS.convert(retryResult.getDelay(), retryResult.getDelayUnit()));
            }
            catch (InterruptedException interruptedException) {
                FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.microprofile.faulttolerance20.impl.SyncExecutor", (String)"166", (Object)this, (Object[])new Object[]{callable, context});
                done = true;
            }
        }
        if (this.fallbackPolicy != null && result.isFailure()) {
            result = this.runFallback(result, executionContext);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"Execution {0} final fault tolerance result: {1}", (Object[])new Object[]{executionContext.getId(), result});
        }
        this.metricRecorder.incrementInvocationCount();
        if (result.isFailure()) {
            this.metricRecorder.incrementInvocationFailedCount();
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private MethodResult<R> runFallback(MethodResult<R> result, SyncExecutionContextImpl executionContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"Execution {0} calling fallback", (Object[])new Object[]{executionContext.getId()});
        }
        this.metricRecorder.incrementFallbackCalls();
        executionContext.setFailure(result.getFailure());
        try {
            result = MethodResult.success(this.fallbackPolicy.getFallbackFunction().execute((Object)executionContext));
        }
        catch (Throwable throwable) {
            void ex;
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.microprofile.faulttolerance20.impl.SyncExecutor", (String)"199", (Object)this, (Object[])new Object[]{result, executionContext});
            result = MethodResult.failure((Throwable)ex);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"Execution {0} fallback result: {1}", (Object[])new Object[]{executionContext.getId(), result});
        }
        return result;
    }

    public FTExecutionContext newExecutionContext(String id, Method method, Object ... parameters) {
        SyncExecutionContextImpl executionContext = new SyncExecutionContextImpl(id, method, parameters);
        return executionContext;
    }

    public void close() {
    }
}

