/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsoc;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.wsoc.BaseCallback;
import com.ibm.ws.wsoc.ParametersOfInterest;
import com.ibm.wsspi.channelfw.VirtualConnection;
import com.ibm.wsspi.tcpchannel.TCPWriteCompletedCallback;
import com.ibm.wsspi.tcpchannel.TCPWriteRequestContext;
import java.io.IOException;
import java.util.concurrent.Executor;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class WsocWriteCallback
extends BaseCallback
implements TCPWriteCompletedCallback {
    private static final TraceComponent tc = Tr.register(WsocWriteCallback.class);
    static final long serialVersionUID = -3955461472315638294L;

    public void complete(VirtualConnection vc, final TCPWriteRequestContext wsc) {
        if (this.connLink != null) {
            ParametersOfInterest things = this.connLink.getParametersOfInterest();
            Executor executor = things.getExecutor();
            if (executor != null) {
                executor.execute(new Runnable(){
                    static final long serialVersionUID = -1615484593254309251L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public void run() {
                        WsocWriteCallback.this.completeLogic(wsc);
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register(1.class);
                    }
                });
            } else {
                this.completeLogic(wsc);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"No connection link found", (Object[])new Object[0]);
        }
    }

    protected void completeLogic(TCPWriteRequestContext wsc) {
        ClassLoader originalCL = this.pushContexts();
        try {
            this.connLink.processWrite(wsc);
        }
        finally {
            this.popContexts(originalCL);
        }
    }

    public void error(VirtualConnection vc, final TCPWriteRequestContext wsc, final IOException ioe) {
        if (this.connLink != null) {
            ParametersOfInterest things = this.connLink.getParametersOfInterest();
            Executor executor = things.getExecutor();
            if (executor != null) {
                executor.execute(new Runnable(){
                    static final long serialVersionUID = 3588979001774307318L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public void run() {
                        WsocWriteCallback.this.errorLogic(wsc, ioe);
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register(2.class);
                    }
                });
            } else {
                this.errorLogic(wsc, ioe);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"No connection link found", (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void errorLogic(TCPWriteRequestContext wsc, IOException ioe) {
        ClassLoader originalCL = this.pushContexts();
        try {
            this.connLink.processWriteError(wsc, ioe);
        }
        finally {
            this.popContexts(originalCL);
        }
    }

    @Override
    protected ClassLoader pushContexts() {
        this.connLink.waitWritePush();
        return super.pushContexts();
    }

    @Override
    protected void popContexts(ClassLoader originalCL) {
        super.popContexts(originalCL);
        this.connLink.notifyWritePush();
    }
}

