/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsoc;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.wsoc.OpcodeType;
import com.ibm.ws.wsoc.ServiceManager;
import com.ibm.ws.wsoc.WebSocketContainerManager;
import com.ibm.ws.wsoc.util.Utils;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import com.ibm.wsspi.bytebuffer.WsByteBufferPoolManager;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class FrameWriteProcessor {
    private static final TraceComponent tc = Tr.register(FrameWriteProcessor.class);
    private WsByteBuffer[] frameBuffers = null;
    private long frameLength = 0L;
    private int payloadLength7bit;
    private long payloadLength;
    private byte controlByte1 = 0;
    private byte controlByte2 = 0;
    private static final int SIZE_FORMAT_64_NO_MASK = 10;
    private static final int SIZE_FORMAT_16_NO_MASK = 4;
    private static final int SIZE_FORMAT_8_NO_MASK = 2;
    private final WebSocketContainerManager wcManager = WebSocketContainerManager.getRef();
    private WsByteBuffer formatBuffer = null;
    private final Object safetySync = new Object(){
        static final long serialVersionUID = -6933099587937750993L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(1.class);
        }
    };
    static final long serialVersionUID = 6124882467251300158L;

    @Sensitive
    public WsByteBuffer[] formatForFrameMessage(@Sensitive WsByteBuffer[] bufs, OpcodeType op, boolean shouldMaskData) {
        if (bufs == null) {
            return null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("writing frame with opcode of: " + (Object)((Object)op)), (Object[])new Object[0]);
        }
        switch (op) {
            case TEXT_WHOLE: {
                this.controlByte1 = (byte)-127;
                break;
            }
            case TEXT_PARTIAL_FIRST: {
                this.controlByte1 = 1;
                break;
            }
            case TEXT_PARTIAL_CONTINUATION: 
            case BINARY_PARTIAL_CONTINUATION: {
                this.controlByte1 = 0;
                break;
            }
            case TEXT_PARTIAL_LAST: 
            case BINARY_PARTIAL_LAST: {
                this.controlByte1 = (byte)-128;
                break;
            }
            case BINARY_WHOLE: {
                this.controlByte1 = (byte)-126;
                break;
            }
            case BINARY_PARTIAL_FIRST: {
                this.controlByte1 = (byte)2;
                break;
            }
            case PING: {
                this.controlByte1 = (byte)-119;
                break;
            }
            case PONG: {
                this.controlByte1 = (byte)-118;
                break;
            }
            case CONNECTION_CLOSE: {
                this.controlByte1 = (byte)-120;
                break;
            }
        }
        this.payloadLength = this.bytesRemaining(bufs);
        this.payloadLength7bit = this.payloadLength < 126L ? (int)this.payloadLength : (this.payloadLength >> 16 == 0L ? 126 : 127);
        this.controlByte2 = (byte)this.payloadLength7bit;
        if (shouldMaskData) {
            this.controlByte2 = (byte)(this.controlByte2 ^ 0x80);
        }
        int maskSize = 0;
        if (shouldMaskData) {
            maskSize = 4;
        }
        WsByteBufferPoolManager mgr = this.getBufferManager();
        if (this.payloadLength7bit == 127) {
            this.formatBuffer = mgr.allocate(10 + maskSize);
            this.frameLength = this.payloadLength + 10L + (long)maskSize;
        } else if (this.payloadLength7bit == 126) {
            this.formatBuffer = mgr.allocate(4 + maskSize);
            this.frameLength = this.payloadLength + 4L + (long)maskSize;
        } else {
            this.formatBuffer = mgr.allocate(2 + maskSize);
            this.frameLength = this.payloadLength + 2L + (long)maskSize;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("frameLength set to: " + this.frameLength), (Object[])new Object[0]);
        }
        this.formatBuffer.put(this.controlByte1);
        this.formatBuffer.put(this.controlByte2);
        if (this.payloadLength7bit == 127) {
            this.formatBuffer.putLong(this.payloadLength);
        } else if (this.payloadLength7bit == 126) {
            int temp = (int)this.payloadLength;
            byte byte1 = (byte)(temp >> 8 & 0xFF);
            byte byte2 = (byte)(temp & 0xFF);
            this.formatBuffer.put(byte1);
            this.formatBuffer.put(byte2);
        }
        byte[] maskBytes = null;
        if (shouldMaskData) {
            maskBytes = this.wcManager.generateNewMaskKey();
            this.formatBuffer.put(maskBytes);
        }
        this.formatBuffer.position(0);
        int bufsCount = bufs.length;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("frame buf count is: " + bufsCount), (Object[])new Object[0]);
        }
        this.frameBuffers = new WsByteBuffer[bufs.length + 1];
        this.frameBuffers[0] = this.formatBuffer;
        if (shouldMaskData) {
            Utils.maskPayload(maskBytes, bufs, bufsCount);
        }
        for (int i = 0; i < bufsCount; ++i) {
            this.frameBuffers[i + 1] = bufs[i];
        }
        return this.frameBuffers;
    }

    public long getFrameLength() {
        return this.frameLength;
    }

    private long bytesRemaining(@Sensitive WsByteBuffer[] bufs) {
        long count = 0L;
        int length = bufs.length;
        for (int i = 0; i < length; ++i) {
            count += (long)bufs[i].remaining();
        }
        return count;
    }

    private WsByteBufferPoolManager getBufferManager() {
        return ServiceManager.getBufferPoolManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        Object object = this.safetySync;
        synchronized (object) {
            if (this.formatBuffer != null) {
                this.formatBuffer.release();
                this.formatBuffer = null;
            }
        }
    }
}

