/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionOperator;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.databaseaccess.FieldTypeDefinition;
import org.eclipse.persistence.internal.expressions.ExpressionSQLPrinter;
import org.eclipse.persistence.internal.expressions.FunctionExpression;
import org.eclipse.persistence.internal.expressions.RelationExpression;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.queries.DataModifyQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.SQLCall;
import org.eclipse.persistence.queries.ValueReadQuery;

public class OraclePlatform
extends DatabasePlatform {
    protected static DataModifyQuery vpdSetIdentifierQuery;
    protected static DataModifyQuery vpdClearIdentifierQuery;
    protected boolean supportsIdentity;
    protected String SELECT = "SELECT * FROM (SELECT ";
    protected String HINT_START = "/*+ FIRST_ROWS";
    protected String HINT_END = " */ ";
    protected String FROM = "a.*, ROWNUM rnum  FROM (";
    protected String END_FROM = ") a ";
    protected String MAX_ROW = "WHERE ROWNUM <= ";
    protected String MIN_ROW = ") WHERE rnum > ";

    public OraclePlatform() {
        this.pingSQL = "SELECT 1 FROM DUAL";
        this.storedProcedureTerminationToken = "";
    }

    @Override
    public void initializeConnectionData(Connection connection) throws SQLException {
        DatabaseMetaData dmd = connection.getMetaData();
        this.driverSupportsNationalCharacterVarying = Helper.compareVersions(dmd.getDriverVersion(), "11.1") >= 0;
    }

    @Override
    public boolean allowsSizeInProcedureArguments() {
        return false;
    }

    @Override
    protected void appendByteArray(byte[] bytes, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            writer.write(39);
            Helper.writeHexString(bytes, writer);
            writer.write(39);
        } else {
            super.appendByteArray(bytes, writer);
        }
    }

    @Override
    protected void appendDate(Date date, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            writer.write("to_date('");
            writer.write(Helper.printDate(date));
            writer.write("','yyyy-mm-dd')");
        } else {
            super.appendDate(date, writer);
        }
    }

    @Override
    protected void appendTime(Time time, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            writer.write("to_date('");
            writer.write(Helper.printTime(time));
            writer.write("','hh24:mi:ss')");
        } else {
            super.appendTime(time, writer);
        }
    }

    @Override
    protected void appendTimestamp(Timestamp timestamp, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            writer.write("to_date('");
            writer.write(Helper.printTimestampWithoutNanos(timestamp));
            writer.write("','yyyy-mm-dd hh24:mi:ss')");
        } else {
            super.appendTimestamp(timestamp, writer);
        }
    }

    @Override
    protected void appendCalendar(Calendar calendar, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            writer.write("to_date('");
            writer.write(Helper.printCalendarWithoutNanos(calendar));
            writer.write("','yyyy-mm-dd hh24:mi:ss')");
        } else {
            super.appendCalendar(calendar, writer);
        }
    }

    public ExpressionOperator atan2Operator() {
        return ExpressionOperator.simpleTwoArgumentFunction(91, "ATAN2");
    }

    @Override
    protected Hashtable buildFieldTypes() {
        Hashtable<Class<java.util.Date>, FieldTypeDefinition> fieldTypeMapping = new Hashtable<Class<java.util.Date>, FieldTypeDefinition>();
        fieldTypeMapping.put(Boolean.class, new FieldTypeDefinition("NUMBER(1) default 0", false));
        fieldTypeMapping.put(Integer.class, new FieldTypeDefinition("NUMBER", 10));
        fieldTypeMapping.put(Long.class, new FieldTypeDefinition("NUMBER", 19));
        fieldTypeMapping.put(Float.class, new FieldTypeDefinition("NUMBER", 19, 4));
        fieldTypeMapping.put(Double.class, new FieldTypeDefinition("NUMBER", 19, 4));
        fieldTypeMapping.put(Short.class, new FieldTypeDefinition("NUMBER", 5));
        fieldTypeMapping.put(Byte.class, new FieldTypeDefinition("NUMBER", 3));
        fieldTypeMapping.put(BigInteger.class, new FieldTypeDefinition("NUMBER", 38));
        fieldTypeMapping.put(BigDecimal.class, new FieldTypeDefinition("NUMBER", 38).setLimits(38, -38, 38));
        fieldTypeMapping.put(Number.class, new FieldTypeDefinition("NUMBER", 38).setLimits(38, -38, 38));
        if (this.getUseNationalCharacterVaryingTypeForString()) {
            fieldTypeMapping.put(String.class, new FieldTypeDefinition("NVARCHAR2", 255));
        } else {
            fieldTypeMapping.put(String.class, new FieldTypeDefinition("VARCHAR2", 255));
        }
        fieldTypeMapping.put(Character.class, new FieldTypeDefinition("CHAR", 1));
        fieldTypeMapping.put(Byte[].class, new FieldTypeDefinition("BLOB", false));
        fieldTypeMapping.put(Character[].class, new FieldTypeDefinition("CLOB", false));
        fieldTypeMapping.put(byte[].class, new FieldTypeDefinition("BLOB", false));
        fieldTypeMapping.put(char[].class, new FieldTypeDefinition("CLOB", false));
        fieldTypeMapping.put(Blob.class, new FieldTypeDefinition("BLOB", false));
        fieldTypeMapping.put(Clob.class, new FieldTypeDefinition("CLOB", false));
        fieldTypeMapping.put(Date.class, new FieldTypeDefinition("DATE", false));
        fieldTypeMapping.put(Time.class, new FieldTypeDefinition("TIMESTAMP", false));
        fieldTypeMapping.put(Timestamp.class, new FieldTypeDefinition("TIMESTAMP", false));
        fieldTypeMapping.put(Calendar.class, new FieldTypeDefinition("TIMESTAMP"));
        fieldTypeMapping.put(java.util.Date.class, new FieldTypeDefinition("TIMESTAMP"));
        return fieldTypeMapping;
    }

    protected String buildFirstRowsHint(int max) {
        return String.valueOf(this.HINT_START) + this.HINT_END;
    }

    @Override
    public DatabaseCall buildCallWithReturning(SQLCall sqlCall, Vector returnFields) {
        SQLCall call = new SQLCall();
        call.setParameters(sqlCall.getParameters());
        call.setParameterTypes(sqlCall.getParameterTypes());
        CharArrayWriter writer = new CharArrayWriter(200);
        try {
            DatabaseField field;
            writer.write("BEGIN ");
            writer.write(sqlCall.getSQLString());
            writer.write(" RETURNING ");
            int i = 0;
            while (i < returnFields.size()) {
                field = (DatabaseField)returnFields.elementAt(i);
                writer.write(field.getNameDelimited(this));
                if (i + 1 < returnFields.size()) {
                    writer.write(", ");
                }
                ++i;
            }
            writer.write(" INTO ");
            i = 0;
            while (i < returnFields.size()) {
                field = (DatabaseField)returnFields.elementAt(i);
                call.appendOut(writer, field);
                if (i + 1 < returnFields.size()) {
                    writer.write(", ");
                }
                ++i;
            }
            writer.write("; END;");
            call.setQueryString(((Object)writer).toString());
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
        return call;
    }

    @Override
    public boolean canBuildCallWithReturning() {
        return true;
    }

    public void clearOracleConnectionCache(Connection conn) {
    }

    @Override
    public String getAssignmentString() {
        return ":= ";
    }

    public String getDeclareBeginString() {
        return "DECLARE ";
    }

    @Override
    public String getBatchBeginString() {
        return "BEGIN ";
    }

    @Override
    public String getBatchEndString() {
        return "END;";
    }

    @Override
    public String getBatchRowCountDeclareString() {
        return "DECLARE EL_COUNTER NUMBER := 0; ";
    }

    @Override
    public boolean isRowCountOutputParameterRequired() {
        return true;
    }

    @Override
    public String getBatchRowCountReturnString() {
        return "? := EL_COUNTER; ";
    }

    @Override
    public String getDropDatabaseSchemaString(String schema) {
        return "DROP SCHEMA " + schema + " RESTRICT";
    }

    @Override
    public String getBatchRowCountAssignString() {
        return "EL_COUNTER := EL_COUNTER + SQL%ROWCOUNT; ";
    }

    @Override
    public int getMaxFieldNameSize() {
        return 30;
    }

    public Vector getNativeTableInfo(String table, String creator, AbstractSession session) {
        String query = "SELECT * FROM ALL_TABLES WHERE OWNER NOT IN ('SYS', 'SYSTEM')";
        if (table != null) {
            query = table.indexOf(37) != -1 ? String.valueOf(query) + " AND TABLE_NAME LIKE " + table : String.valueOf(query) + " AND TABLE_NAME = " + table;
        }
        if (creator != null) {
            query = creator.indexOf(37) != -1 ? String.valueOf(query) + " AND OWNER LIKE " + creator : String.valueOf(query) + " AND OWNER = " + creator;
        }
        return session.executeSelectingCall(new SQLCall(query));
    }

    @Override
    public String getProcedureArgumentSetter() {
        return "=>";
    }

    @Override
    public String getProcedureCallHeader() {
        return this.useJDBCStoredProcedureSyntax() ? "{CALL " : "BEGIN ";
    }

    @Override
    public String getProcedureCallTail() {
        return this.useJDBCStoredProcedureSyntax() ? "}" : "; END;";
    }

    @Override
    public String getDropCascadeString() {
        return " CASCADE CONSTRAINTS";
    }

    @Override
    public String getSelectForUpdateString() {
        return " FOR UPDATE";
    }

    @Override
    public String getSelectForUpdateWaitString(Integer waitTimeout) {
        return " FOR UPDATE WAIT " + waitTimeout;
    }

    @Override
    public String getStoredProcedureParameterPrefix() {
        return "P_";
    }

    public ValueReadQuery getSystemChangeNumberQuery() {
        ValueReadQuery sCNQuery = new ValueReadQuery();
        sCNQuery.setSQLString("SELECT DBMS_FLASHBACK.GET_SYSTEM_CHANGE_NUMBER FROM DUAL");
        return sCNQuery;
    }

    @Override
    public ValueReadQuery getTimestampQuery() {
        if (this.timestampQuery == null) {
            this.timestampQuery = new ValueReadQuery();
            this.timestampQuery.setSQLString("SELECT SYSDATE FROM DUAL");
            this.timestampQuery.setAllowNativeSQLQuery(true);
        }
        return this.timestampQuery;
    }

    @Override
    public DatabaseQuery getVPDClearIdentifierQuery(String vpdIdentifier) {
        if (vpdClearIdentifierQuery == null) {
            vpdClearIdentifierQuery = new DataModifyQuery("CALL DBMS_SESSION.CLEAR_IDENTIFIER()");
        }
        return vpdClearIdentifierQuery;
    }

    @Override
    public String getVPDCreationFunctionString(String tableName, String tenantFieldName) {
        String functionName = String.valueOf(tableName) + "_ident_func";
        return "CREATE OR REPLACE FUNCTION " + functionName + " (p_schema in VARCHAR2 default NULL, p_object in VARCHAR2 default NULL) RETURN VARCHAR2 AS BEGIN return '" + tenantFieldName + " = sys_context(''userenv'', ''client_identifier'')'; END;";
    }

    @Override
    public String getVPDCreationPolicyString(String tableName, AbstractSession session) {
        String functionName = String.valueOf(tableName) + "_ident_func";
        String schemaName = session.getDatasourceLogin().getUserName();
        String policyName = String.valueOf(tableName) + "_todo_list_policy";
        return "\nCALL DBMS_RLS.ADD_POLICY ('" + schemaName + "', '" + tableName + "', '" + policyName + "', '" + schemaName + "', '" + functionName + "', 'select, update, delete')\n";
    }

    @Override
    public String getVPDDeletionString(String tableName, AbstractSession session) {
        String schemaName = session.getDatasourceLogin().getUserName();
        String policyName = String.valueOf(tableName) + "_todo_list_policy";
        return "\nCALL DBMS_RLS.DROP_POLICY ('" + schemaName + "', '" + tableName + "', '" + policyName + "')";
    }

    @Override
    public DatabaseQuery getVPDSetIdentifierQuery(String vpdIdentifier) {
        if (vpdSetIdentifierQuery == null) {
            vpdSetIdentifierQuery = new DataModifyQuery("CALL DBMS_SESSION.SET_IDENTIFIER(#" + vpdIdentifier + ")");
        }
        return vpdSetIdentifierQuery;
    }

    @Override
    public Object getObjectFromResultSet(ResultSet resultSet, int columnNumber, int type, AbstractSession session) throws SQLException {
        if (type == 93 || type == 91) {
            return resultSet.getTimestamp(columnNumber);
        }
        return super.getObjectFromResultSet(resultSet, columnNumber, type, session);
    }

    @Override
    protected void initializePlatformOperators() {
        super.initializePlatformOperators();
        this.addOperator(this.operatorOuterJoin());
        this.addOperator(this.logOperator());
        this.addOperator(ExpressionOperator.simpleTwoArgumentFunction(31, "CONCAT"));
        this.addOperator(this.todayOperator());
        this.addOperator(this.currentDateOperator());
        this.addOperator(this.currentTimeOperator());
        this.addOperator(ExpressionOperator.truncateDate());
        this.addOperator(ExpressionOperator.newTime());
        this.addOperator(ExpressionOperator.ifNull());
        this.addOperator(this.atan2Operator());
        this.addOperator(ExpressionOperator.oracleDateName());
        this.addOperator(this.operatorLocate());
        this.addOperator(this.operatorLocate2());
        this.addOperator(OraclePlatform.regexpOperator());
        this.addOperator(OraclePlatform.exceptOperator());
    }

    public static ExpressionOperator exceptOperator() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(5);
        exOperator.setSelector(146);
        exOperator.printsAs("MINUS ");
        exOperator.bePostfix();
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    public static ExpressionOperator regexpOperator() {
        ExpressionOperator result = new ExpressionOperator();
        result.setSelector(141);
        result.setType(5);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(3);
        ((Vector)v).add("REGEXP_LIKE(");
        ((Vector)v).add(", ");
        ((Vector)v).add(")");
        result.printsAs(v);
        result.bePrefix();
        result.setNodeClass(ClassConstants.FunctionExpression_Class);
        v = NonSynchronizedVector.newInstance(2);
        ((Vector)v).add(".regexp(");
        ((Vector)v).add(")");
        result.printsJavaAs(v);
        return result;
    }

    public boolean isNativeConnectionRequiredForLobLocator() {
        return false;
    }

    @Override
    public boolean isOracle() {
        return true;
    }

    protected ExpressionOperator logOperator() {
        ExpressionOperator result = new ExpressionOperator();
        result.setSelector(66);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(2);
        ((Vector)v).addElement("LOG(10,");
        ((Vector)v).addElement(")");
        result.printsAs(v);
        result.bePrefix();
        result.setNodeClass(FunctionExpression.class);
        return result;
    }

    @Override
    public Hashtable maximumNumericValues() {
        Hashtable<Class, Number> values = new Hashtable<Class, Number>();
        values.put(Integer.class, Integer.MAX_VALUE);
        values.put(Long.class, Long.MAX_VALUE);
        values.put(Double.class, 9.9999E125);
        values.put(Short.class, (short)Short.MAX_VALUE);
        values.put(Byte.class, (byte)127);
        values.put(Float.class, Float.valueOf(Float.MAX_VALUE));
        values.put(BigInteger.class, new BigInteger("0"));
        values.put(BigDecimal.class, new BigDecimal(new BigInteger("0"), 38));
        return values;
    }

    @Override
    public Hashtable minimumNumericValues() {
        Hashtable<Class, Number> values = new Hashtable<Class, Number>();
        values.put(Integer.class, Integer.MIN_VALUE);
        values.put(Long.class, Long.MIN_VALUE);
        values.put(Double.class, -1.0E-129);
        values.put(Short.class, (short)Short.MIN_VALUE);
        values.put(Byte.class, (byte)-128);
        values.put(Float.class, Float.valueOf(Float.MIN_VALUE));
        values.put(BigInteger.class, new BigInteger("0"));
        values.put(BigDecimal.class, new BigDecimal(new BigInteger("0"), 38));
        return values;
    }

    @Override
    public ValueReadQuery buildSelectQueryForSequenceObject(String qualifiedSeqName, Integer size) {
        return new ValueReadQuery("SELECT " + qualifiedSeqName + ".NEXTVAL FROM DUAL");
    }

    @Override
    public ValueReadQuery buildSelectQueryForIdentity(String qualifiedSeqName, Integer size) {
        return new ValueReadQuery("SELECT " + qualifiedSeqName + ".CURRVAL FROM DUAL");
    }

    protected ExpressionOperator operatorOuterJoin() {
        ExpressionOperator result = new ExpressionOperator();
        result.setSelector(6);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(2);
        ((Vector)v).addElement(" (+) = ");
        result.printsAs(v);
        result.bePostfix();
        result.setNodeClass(RelationExpression.class);
        return result;
    }

    protected ExpressionOperator operatorLocate() {
        ExpressionOperator result = new ExpressionOperator();
        result.setSelector(112);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(2);
        ((Vector)v).addElement("INSTR(");
        ((Vector)v).addElement(", ");
        ((Vector)v).addElement(")");
        result.printsAs(v);
        result.bePrefix();
        result.setNodeClass(RelationExpression.class);
        return result;
    }

    protected ExpressionOperator operatorLocate2() {
        ExpressionOperator result = new ExpressionOperator();
        result.setSelector(113);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(2);
        ((Vector)v).addElement("INSTR(");
        ((Vector)v).addElement(", ");
        ((Vector)v).addElement(", ");
        ((Vector)v).addElement(")");
        result.printsAs(v);
        result.bePrefix();
        result.setNodeClass(RelationExpression.class);
        return result;
    }

    @Override
    public void printFieldNullClause(Writer writer) throws ValidationException {
        try {
            writer.write(" NULL");
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
    }

    public String serverTimestampString() {
        return "SYSDATE";
    }

    @Override
    public boolean shouldPrintStoredProcedureArgumentNameInCall() {
        return !this.useJDBCStoredProcedureSyntax();
    }

    @Override
    public boolean shouldUseJDBCOuterJoinSyntax() {
        return false;
    }

    @Override
    public boolean supportsAutoConversionToNumericForArithmeticOperations() {
        return true;
    }

    @Override
    public boolean supportsSequenceObjects() {
        return true;
    }

    @Override
    public boolean supportsIdentity() {
        return this.supportsIdentity;
    }

    public void setSupportsIdentity(boolean supportsIdentity) {
        this.supportsIdentity = supportsIdentity;
    }

    @Override
    public boolean supportsStoredFunctions() {
        return true;
    }

    @Override
    public boolean supportsVPD() {
        return true;
    }

    public boolean supportsSelectForUpdateNoWait() {
        return true;
    }

    protected ExpressionOperator todayOperator() {
        return ExpressionOperator.simpleFunctionNoParentheses(54, "SYSDATE");
    }

    protected ExpressionOperator currentDateOperator() {
        return ExpressionOperator.simpleFunctionNoParentheses(123, "TO_DATE(CURRENT_DATE)");
    }

    protected ExpressionOperator currentTimeOperator() {
        return ExpressionOperator.simpleFunctionNoParentheses(128, "SYSDATE");
    }

    public boolean canUnwrapOracleConnection() {
        return false;
    }

    public Connection unwrapOracleConnection(Connection connection) {
        return connection;
    }

    public boolean useJDBCStoredProcedureSyntax() {
        if (this.useJDBCStoredProcedureSyntax == null) {
            this.useJDBCStoredProcedureSyntax = this.driverName != null && this.driverName.equals("Oracle");
        }
        return this.useJDBCStoredProcedureSyntax;
    }

    @Override
    public void printSQLSelectStatement(DatabaseCall call, ExpressionSQLPrinter printer, SQLSelectStatement statement) {
        short lockMode;
        int max = 0;
        int firstRow = 0;
        if (statement.getQuery() != null) {
            max = statement.getQuery().getMaxRows();
            firstRow = statement.getQuery().getFirstResult();
        }
        if (!this.shouldUseRownumFiltering() || max <= 0 && firstRow <= 0) {
            super.printSQLSelectStatement(call, printer, statement);
            return;
        }
        if (max > 0) {
            statement.setUseUniqueFieldAliases(true);
            printer.printString(this.SELECT);
            printer.printString(this.buildFirstRowsHint(max));
            printer.printString(this.FROM);
            call.setFields(statement.printSQL(printer));
            printer.printString(this.END_FROM);
            printer.printString(this.MAX_ROW);
            printer.printParameter(DatabaseCall.MAXROW_FIELD);
            printer.printString(this.MIN_ROW);
            printer.printParameter(DatabaseCall.FIRSTRESULT_FIELD);
        } else {
            statement.setUseUniqueFieldAliases(true);
            printer.printString(this.SELECT);
            printer.printString(this.FROM);
            call.setFields(statement.printSQL(printer));
            printer.printString(this.END_FROM);
            printer.printString(this.MIN_ROW);
            printer.printParameter(DatabaseCall.FIRSTRESULT_FIELD);
        }
        if (statement.getQuery().isObjectBuildingQuery() && ((lockMode = ((ObjectBuildingQuery)statement.getQuery()).getLockMode()) == 1 || lockMode == 2)) {
            throw new UnsupportedOperationException(ExceptionLocalization.buildMessage("ora_pessimistic_locking_with_rownum"));
        }
        call.setIgnoreFirstRowSetting(true);
        call.setIgnoreMaxResultsSetting(true);
    }

    @Override
    public boolean isAlterSequenceObjectSupported() {
        return true;
    }

    @Override
    public boolean isForUpdateCompatibleWithDistinct() {
        return false;
    }

    @Override
    public boolean isLobCompatibleWithDistinct() {
        return false;
    }

    @Override
    public boolean isLockTimeoutException(DatabaseException e) {
        return e.getInternalException() instanceof SQLException && ((SQLException)e.getInternalException()).getErrorCode() == 30006;
    }

    @Override
    public boolean wasFailureCommunicationBased(SQLException exception, Connection connection, AbstractSession sessionForProfile) {
        if (exception != null) {
            if (exception.getErrorCode() == 17410) {
                return true;
            }
            if (exception.getErrorCode() == 17002) {
                return true;
            }
            if (exception.getErrorCode() == 2399) {
                return true;
            }
            if (exception.getErrorCode() == 2396) {
                return true;
            }
        }
        return super.wasFailureCommunicationBased(exception, connection, sessionForProfile);
    }

    @Override
    public Expression createExpressionFor(DatabaseField field, Expression builder) {
        if (field.getType() == Clob.class || field.getType() == Blob.class) {
            Expression subExp1 = builder.getField(field);
            Expression subExp2 = builder.getParameter(field);
            subExp1 = subExp1.getFunction("dbms_lob.compare", subExp2);
            return subExp1.equal(0);
        }
        return super.createExpressionFor(field, builder);
    }
}

