/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.openidconnect.token.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.openidconnect.token.IDToken;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class IdTokenImpl
implements Serializable {
    private static final long serialVersionUID = -6131956027925854513L;
    private final Map<String, Object> mapAll = new HashMap<String, Object>();
    static final String CLIENT_ID = "azp2";
    byte[] idTokenPart2Bytes;
    String accessToken;
    String refreshToken;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public IdTokenImpl(IDToken origIdToken, String idTokenString, String accessToken, String refreshToken) {
        origIdToken.addToIdTokenImpl(this);
        this.accessToken = accessToken;
        this.refreshToken = refreshToken;
        this.idTokenPart2Bytes = this.getPart2PlainText(idTokenString);
    }

    byte[] getPart2PlainText(String idTokenString) {
        int index1 = idTokenString.indexOf(".") + 1;
        int index2 = idTokenString.indexOf(".", index1);
        if (index2 < 0) {
            index2 = idTokenString.length();
        }
        String part2 = idTokenString.substring(index1, index2);
        return Base64.decodeBase64((String)part2);
    }

    public String getJwtId() {
        return (String)this.mapAll.get("jti");
    }

    public String getType() {
        return (String)this.mapAll.get("typ");
    }

    public String getIssuer() {
        return (String)this.mapAll.get("iss");
    }

    public String getSubject() {
        return (String)this.mapAll.get("sub");
    }

    public List<String> getAudience() {
        Object obj = this.mapAll.get("aud");
        return (List)obj;
    }

    public String getClientId() {
        return (String)this.mapAll.get(CLIENT_ID);
    }

    public long getExpirationTimeSeconds() {
        return (Long)this.mapAll.get("exp");
    }

    public long getNotBeforeTimeSeconds() {
        return (Long)this.mapAll.get("nbf");
    }

    public long getIssuedAtTimeSeconds() {
        return (Long)this.mapAll.get("iat");
    }

    public long getAuthorizationTimeSeconds() {
        return (Long)this.mapAll.get("auth_time");
    }

    public String getNonce() {
        return (String)this.mapAll.get("nonce");
    }

    public String getAccessTokenHash() {
        return (String)this.mapAll.get("at_hash");
    }

    public String getClassReference() {
        return (String)this.mapAll.get("acr");
    }

    public List<String> getMethodsReferences() {
        return (List)this.mapAll.get("amr");
    }

    public String getAuthorizedParty() {
        return (String)this.mapAll.get("azp");
    }

    public Object getClaim(String key) {
        return this.mapAll.get(key);
    }

    public Map<String, Object> getAllClaims() {
        return new HashMap<String, Object>(this.mapAll);
    }

    public void setJwtId(String strJwtId) {
        this.mapAll.put("jti", strJwtId);
    }

    public void setType(String strType) {
        this.mapAll.put("typ", strType);
    }

    public void setIssuer(String strIss) {
        this.mapAll.put("iss", strIss);
    }

    public void setSubject(String strSub) {
        this.mapAll.put("sub", strSub);
    }

    public void setAudience(Object objAud) {
        if (objAud instanceof List) {
            this.mapAll.put("aud", objAud);
        } else if (objAud instanceof String) {
            ArrayList<String> list = new ArrayList<String>();
            list.add((String)objAud);
            this.mapAll.put("aud", list);
        }
    }

    public void setClientId(String clientId) {
        this.mapAll.put(CLIENT_ID, clientId);
    }

    public void setExpirationTimeSeconds(long lExp) {
        this.mapAll.put("exp", lExp);
    }

    public void setNotBeforeTimeSeconds(long lNotBeforeSeconds) {
        this.mapAll.put("nbf", lNotBeforeSeconds);
    }

    public void setIssuedAtTimeSeconds(long lIat) {
        this.mapAll.put("iat", lIat);
    }

    public void setAuthorizationTimeSeconds(long lAT) {
        this.mapAll.put("auth_time", lAT);
    }

    public void setNonce(String strNonce) {
        this.mapAll.put("nonce", strNonce);
    }

    public void setAccessTokenHash(String strAt_hash) {
        this.mapAll.put("at_hash", strAt_hash);
    }

    public void setClassReference(String strAcr) {
        this.mapAll.put("acr", strAcr);
    }

    public void setMethodsReferences(List<String> listAmr) {
        this.mapAll.put("amr", listAmr);
    }

    public void setAuthorizedParty(String strAzp) {
        this.mapAll.put("azp", strAzp);
    }

    public void setOtherClaims(String key, Object value) {
        this.mapAll.put(key, value);
    }

    public String toString() {
        Map<String, Object> mapTmp = this.getAllClaims();
        StringBuffer sb = new StringBuffer("IDToken");
        if (!mapTmp.isEmpty()) {
            sb.append(":");
        }
        if (mapTmp.get("iss") != null) {
            this.appendClaimKey(sb, "iss").append((String)mapTmp.get("iss"));
        }
        if (mapTmp.get("typ") != null) {
            this.appendClaimKey(sb, "type").append((String)mapTmp.remove("typ"));
        }
        if (mapTmp.get(CLIENT_ID) != null) {
            this.appendClaimKey(sb, "client_id").append((String)mapTmp.remove(CLIENT_ID));
        }
        if (mapTmp.get("sub") != null) {
            this.appendClaimKey(sb, "sub").append((String)mapTmp.remove("sub"));
        }
        if (mapTmp.get("aud") != null) {
            this.appendClaimKey(sb, "aud").append(this.getListString((List)mapTmp.remove("aud")));
        }
        if (mapTmp.get("exp") != null) {
            this.appendClaimKey(sb, "exp").append(Long.parseLong(mapTmp.remove("exp").toString()));
        }
        if (mapTmp.get("iat") != null) {
            this.appendClaimKey(sb, "iat").append(Long.parseLong(mapTmp.remove("iat").toString()));
        }
        if (mapTmp.get("nonce") != null) {
            this.appendClaimKey(sb, "nonce").append((String)mapTmp.remove("nonce"));
        }
        if (mapTmp.get("at_hash") != null) {
            this.appendClaimKey(sb, "at_hash").append((String)mapTmp.remove("at_hash"));
        }
        if (mapTmp.get("acr") != null) {
            this.appendClaimKey(sb, "acr").append((String)mapTmp.remove("acr"));
        }
        if (mapTmp.get("amr") != null) {
            this.appendClaimKey(sb, "amr").append(this.getListString((List)mapTmp.remove("amr")));
        }
        if (mapTmp.get("azp") != null) {
            this.appendClaimKey(sb, "azp").append((String)mapTmp.remove("azp"));
        }
        Set<Map.Entry<String, Object>> entries = mapTmp.entrySet();
        for (Map.Entry<String, Object> entry : entries) {
            String key = entry.getKey();
            Object obj = entry.getValue();
            this.appendClaimKey(sb, key).append(obj);
        }
        return sb.toString();
    }

    protected StringBuffer appendClaimKey(StringBuffer sb, String claimKey) {
        if (sb.indexOf("=") > 0) {
            sb.append(", ");
        }
        sb.append(claimKey).append("=");
        return sb;
    }

    protected String getListString(List<?> list) {
        if (list == null) {
            return null;
        }
        return list.toString();
    }

    public String getAllClaimsAsJson() {
        try {
            return new String(this.idTokenPart2Bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.ws.security.openidconnect.token.impl.IdTokenImpl", (String)"471", (Object)this, (Object[])new Object[0]);
            return new String(this.idTokenPart2Bytes);
        }
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(IdTokenImpl.class);
    }
}

