/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.openidconnect.clients.common;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.common.internal.encoder.Base64Coder;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.web.WebUtils;
import com.ibm.ws.security.openidconnect.clients.common.BadPostRequestException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocketFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.StrictHostnameVerifier;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class OidcClientHttpUtil {
    private static final TraceComponent tc = Tr.register(OidcClientHttpUtil.class);
    private String clientId;
    static OidcClientHttpUtil instance = null;
    static final long serialVersionUID = -8163764434389036019L;

    protected OidcClientHttpUtil() {
    }

    public void setClientId(String id) {
        this.clientId = id;
    }

    /*
     * WARNING - void declaration
     */
    String extractTokensFromResponse(Map<String, Object> postResponseMap) throws Exception {
        HttpResponse response = (HttpResponse)postResponseMap.get("RESPONSEMAP_CODE");
        HttpEntity entity = response.getEntity();
        if (entity == null) {
            return null;
        }
        try {
            return EntityUtils.toString((HttpEntity)entity);
        }
        catch (Exception exception) {
            void ioe;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.openidconnect.clients.common.OidcClientHttpUtil", (String)"70", (Object)this, (Object[])new Object[]{postResponseMap});
            String insertMsg = Tr.formatMessage((TraceComponent)tc, (String)"OIDC_CLIENT_INVALID_HTTP_RESPONSE_NO_MSG", (Object[])new Object[0]);
            String eMsg = ioe.getMessage();
            if (eMsg != null && !eMsg.isEmpty()) {
                insertMsg = eMsg;
            }
            Tr.error((TraceComponent)tc, (String)"OIDC_CLIENT_INVALID_HTTP_RESPONSE", (Object[])new Object[]{insertMsg, this.clientId});
            throw ioe;
        }
    }

    HttpPost createPostMethod(String url, List<NameValuePair> commonHeaders) {
        HttpPost postMethod = new HttpPost(url);
        for (NameValuePair nvp : commonHeaders) {
            postMethod.addHeader(nvp.getName(), nvp.getValue());
        }
        return postMethod;
    }

    HttpGet createHttpGetMethod(String url, List<NameValuePair> commonHeaders) {
        HttpGet getMethod = new HttpGet(url);
        for (NameValuePair nvp : commonHeaders) {
            getMethod.addHeader(nvp.getName(), nvp.getValue());
        }
        return getMethod;
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={SSLException.class})
    Map<String, Object> postToEndpoint(String url, @Sensitive List<NameValuePair> params, String baUsername, @Sensitive String baPassword, String accessToken, SSLSocketFactory sslSocketFactory, List<NameValuePair> commonHeaders, boolean isHostnameVerification, String authMethod, boolean useSystemPropertiesForHttpClientConnections) throws Exception {
        this.debugPostToEndPoint(url, params, baUsername, baPassword, accessToken, commonHeaders);
        HttpPost postMethod = this.createPostMethod(url, commonHeaders);
        postMethod.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
        this.setAuthorizationHeaderForPostMethod(baUsername, baPassword, accessToken, postMethod, authMethod);
        HttpClient httpClient = OidcClientHttpUtil.getInstance().createHTTPClient(sslSocketFactory, url, isHostnameVerification, useSystemPropertiesForHttpClientConnections);
        HttpResponse response = null;
        try {
            response = httpClient.execute((HttpUriRequest)postMethod);
        }
        catch (SSLException ex) {
            throw ex;
        }
        catch (Exception ex) {
            void ioe;
            Object[] objectArray = new Object[10];
            objectArray[0] = url;
            objectArray[1] = "<sensitive java.util.List>";
            objectArray[2] = baUsername;
            objectArray[3] = "<sensitive java.lang.String>";
            objectArray[4] = accessToken;
            objectArray[5] = sslSocketFactory;
            objectArray[6] = commonHeaders;
            objectArray[7] = isHostnameVerification;
            objectArray[8] = authMethod;
            objectArray[9] = useSystemPropertiesForHttpClientConnections;
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.security.openidconnect.clients.common.OidcClientHttpUtil", (String)"134", (Object)this, (Object[])objectArray);
            throw ioe;
        }
        StatusLine status = response.getStatusLine();
        if (status == null || status.getStatusCode() != 200) {
            String errorMsg = "Could not get the status of the response, or the response returned an error.";
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                errorMsg = EntityUtils.toString((HttpEntity)entity).trim();
            }
            if (status != null && status.getStatusCode() == 400) {
                throw new BadPostRequestException(errorMsg, 400);
            }
            throw new IOException("Failed to reach endpoint " + url + " because of the following error: " + errorMsg);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("RESPONSEMAP_CODE", response);
        result.put("RESPONSEMAP_METHOD", postMethod);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={SSLException.class})
    Map<String, Object> postToIntrospectEndpoint(String url, @Sensitive List<NameValuePair> params, String baUsername, @Sensitive String baPassword, String accessToken, SSLSocketFactory sslSocketFactory, List<NameValuePair> commonHeaders, boolean isHostnameVerification, String authMethod, boolean useSystemPropertiesForHttpClientConnections) throws Exception {
        this.debugPostToEndPoint(url, params, baUsername, baPassword, accessToken, commonHeaders);
        HttpPost postMethod = this.createPostMethod(url, commonHeaders);
        postMethod.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
        this.setAuthorizationHeaderForPostMethod(baUsername, baPassword, accessToken, postMethod, authMethod);
        HttpClient httpClient = OidcClientHttpUtil.getInstance().createHTTPClient(sslSocketFactory, url, isHostnameVerification, useSystemPropertiesForHttpClientConnections);
        HttpResponse response = null;
        try {
            response = httpClient.execute((HttpUriRequest)postMethod);
        }
        catch (SSLException ex) {
            throw ex;
        }
        catch (Exception ex) {
            void ioe;
            Object[] objectArray = new Object[10];
            objectArray[0] = url;
            objectArray[1] = "<sensitive java.util.List>";
            objectArray[2] = baUsername;
            objectArray[3] = "<sensitive java.lang.String>";
            objectArray[4] = accessToken;
            objectArray[5] = sslSocketFactory;
            objectArray[6] = commonHeaders;
            objectArray[7] = isHostnameVerification;
            objectArray[8] = authMethod;
            objectArray[9] = useSystemPropertiesForHttpClientConnections;
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.security.openidconnect.clients.common.OidcClientHttpUtil", (String)"185", (Object)this, (Object[])objectArray);
            throw ioe;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("RESPONSEMAP_CODE", response);
        result.put("RESPONSEMAP_METHOD", postMethod);
        return result;
    }

    void setAuthorizationHeaderForPostMethod(String baUsername, @Sensitive String baPassword, String accessToken, HttpPost postMethod, String authMethod) {
        if (authMethod.contains("basic")) {
            String userpass = baUsername + ":" + baPassword;
            String basicAuth = "Basic " + Base64Coder.base64Encode(userpass);
            postMethod.setHeader("Authorization", basicAuth);
        }
        if (accessToken != null) {
            postMethod.addHeader("Authorization", "Bearer " + accessToken);
        }
    }

    static int getTokenEndPointPort(String url) {
        int last;
        int port = 0;
        int first = url.indexOf(":");
        if (first != (last = url.lastIndexOf(":"))) {
            int end = -1;
            int begin = last;
            if (begin > 0 && (end = url.substring(begin).indexOf("/")) > 0) {
                String s = url.substring(begin + 1, begin + end);
                port = Integer.valueOf(s);
            }
        } else if (url.startsWith("https:")) {
            port = 443;
        } else if (url.startsWith("http:")) {
            port = 80;
        }
        return port;
    }

    void debugPostToEndPoint(String url, @Sensitive List<NameValuePair> params, String baUsername, @Sensitive String baPassword, String accessToken, List<NameValuePair> commonHeaders) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("OIDC _SSO RP POST TO URL [" + WebUtils.stripSecretFromUrl((String)url, (String)"client_secret") + "]"), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("postToEndpoint: url: " + url + " headers: " + commonHeaders + " params: ***** baUsername: " + baUsername + " baPassword: " + (baPassword != null ? "****" : null) + " accessToken: " + accessToken), (Object[])new Object[0]);
            StringBuffer sb = new StringBuffer();
            sb.append("curl -k -v");
            if (commonHeaders != null) {
                for (NameValuePair nvp : commonHeaders) {
                    sb.append(" -H \"");
                    sb.append(nvp.getName());
                    sb.append(": ");
                    sb.append(nvp.getValue());
                    sb.append("\"");
                }
            }
            if (params != null && params.size() > 0) {
                sb.append(" -d \"");
                Iterator<NameValuePair> i = params.iterator();
                while (i.hasNext()) {
                    NameValuePair nvp;
                    nvp = i.next();
                    String name = nvp.getName();
                    sb.append(name);
                    sb.append("=");
                    if (name.equals("client_secret")) {
                        sb.append("*****");
                    } else {
                        sb.append(nvp.getValue());
                    }
                    if (!i.hasNext()) continue;
                    sb.append("&");
                }
                sb.append("\"");
            }
            if (baUsername != null && baPassword != null) {
                sb.append(" -u \"");
                sb.append(baUsername);
                sb.append(":");
                sb.append("****");
                sb.append("\"");
            }
            if (accessToken != null) {
                sb.append(" -H \"Authorization: bearer ");
                sb.append(accessToken);
                sb.append("\"");
            }
            sb.append(" ");
            sb.append(url);
            Tr.debug((TraceComponent)tc, (String)("CURL Command: " + sb.toString()), (Object[])new Object[0]);
        }
    }

    public HttpClient createHTTPClient(SSLSocketFactory sslSocketFactory, String url, boolean isHostnameVerification, boolean useSystemPropertiesForHttpClientConnections) {
        CloseableHttpClient client = null;
        if (url.startsWith("http:")) {
            client = this.createBuilder(useSystemPropertiesForHttpClientConnections).build();
        } else {
            SSLConnectionSocketFactory connectionFactory = null;
            connectionFactory = !isHostnameVerification ? new SSLConnectionSocketFactory(sslSocketFactory, (X509HostnameVerifier)new AllowAllHostnameVerifier()) : new SSLConnectionSocketFactory(sslSocketFactory, (X509HostnameVerifier)new StrictHostnameVerifier());
            client = this.createBuilder(useSystemPropertiesForHttpClientConnections).setSSLSocketFactory((LayeredConnectionSocketFactory)connectionFactory).build();
        }
        return client;
    }

    private HttpClientBuilder createBuilder(boolean useSystemProperties) {
        return useSystemProperties ? HttpClientBuilder.create().useSystemProperties() : HttpClientBuilder.create();
    }

    public HttpClient createHTTPClient(SSLSocketFactory sslSocketFactory, String url, boolean isHostnameVerification, String baUser, @Sensitive String baPassword, boolean useSystemPropertiesForHttpClientConnections) {
        CloseableHttpClient client = null;
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(baUser, baPassword));
        if (url.startsWith("http:")) {
            client = this.createBuilder(useSystemPropertiesForHttpClientConnections).setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).build();
        } else {
            SSLConnectionSocketFactory connectionFactory = null;
            connectionFactory = !isHostnameVerification ? new SSLConnectionSocketFactory(sslSocketFactory, (X509HostnameVerifier)new AllowAllHostnameVerifier()) : new SSLConnectionSocketFactory(sslSocketFactory, (X509HostnameVerifier)new StrictHostnameVerifier());
            client = this.createBuilder(useSystemPropertiesForHttpClientConnections).setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).setSSLSocketFactory((LayeredConnectionSocketFactory)connectionFactory).build();
        }
        return client;
    }

    public static OidcClientHttpUtil getInstance() {
        if (instance == null) {
            instance = new OidcClientHttpUtil();
        }
        return instance;
    }
}

