/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.service.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.osgi.report.resolution.ResolutionReport;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.hooks.resolver.ResolverHook;
import org.osgi.framework.hooks.resolver.ResolverHookFactory;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.resource.Resource;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ResolutionReportHelper
implements ResolverHookFactory,
ResolverHook,
ResolutionReport.Listener {
    private static final TraceComponent tc = Tr.register(ResolutionReportHelper.class);
    private final AtomicReference<ResolutionReport> _reportRef = new AtomicReference();
    private ServiceRegistration<ResolverHookFactory> ResolverHookFactoryReg;
    private Long _resolvingThread = null;
    static final long serialVersionUID = 6546887883138038745L;

    public ResolverHook begin(Collection<BundleRevision> triggers) {
        ResolutionReportHelper hook = null;
        if (this._resolvingThread.longValue() == Thread.currentThread().getId()) {
            hook = this;
        }
        return hook;
    }

    public void handleResolutionReport(ResolutionReport report) {
        this._reportRef.compareAndSet(null, report);
    }

    public void filterResolvable(Collection<BundleRevision> candidates) {
    }

    public void filterSingletonCollisions(BundleCapability singleton, Collection<BundleCapability> collisionCandidates) {
    }

    public void filterMatches(BundleRequirement requirement, Collection<BundleCapability> candidates) {
    }

    public void end() {
    }

    public void startHelper(BundleContext bContext) {
        this._resolvingThread = Thread.currentThread().getId();
        this.ResolverHookFactoryReg = bContext.registerService(ResolverHookFactory.class, (Object)this, null);
    }

    public void stopHelper() {
        this._resolvingThread = null;
        if (this.ResolverHookFactoryReg != null) {
            this.ResolverHookFactoryReg.unregister();
        }
    }

    public ResolutionReport getResolutionReport() {
        return this._reportRef.get();
    }

    public String getResolutionReportString() {
        ResolutionReport report = this._reportRef.get();
        StringBuilder reportMessage = null;
        if (report != null) {
            reportMessage = new StringBuilder().append("Resolver report:\n");
            Map unresolved = report.getEntries();
            if (!unresolved.isEmpty()) {
                for (Resource resource : unresolved.keySet()) {
                    reportMessage.append(report.getResolutionReportMessage(resource));
                }
            }
            if (report.getResolutionException() != null) {
                reportMessage.append("\nResolution exception:\n" + report.getResolutionException());
            }
        }
        return reportMessage == null ? "No resolution report generated." : reportMessage.toString();
    }
}

