/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.service.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.security.AccessController;
import java.security.PrivilegedAction;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class JavaInfo {
    private static JavaInfo instance;
    private final int MAJOR;
    private final int MINOR;
    private final int MICRO;
    private final int SERVICE_RELEASE;
    private final int FIXPACK;
    private final Vendor VENDOR;
    static final long serialVersionUID = 1253984531855194845L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    private JavaInfo() {
        String version = JavaInfo.getSystemProperty("java.version");
        String[] versionElements = version.split("\\D");
        int i = Integer.valueOf(versionElements[0]) == 1 ? 1 : 0;
        this.MAJOR = Integer.valueOf(versionElements[i++]);
        this.MINOR = i < versionElements.length ? JavaInfo.parseIntSafe(versionElements[i++]) : 0;
        this.MICRO = i < versionElements.length ? JavaInfo.parseIntSafe(versionElements[i]) : 0;
        String vendor = JavaInfo.getSystemProperty("java.vendor").toLowerCase();
        this.VENDOR = vendor.contains("openj9") ? Vendor.OPENJ9 : (vendor.contains("ibm") || vendor.contains("j9") ? Vendor.IBM : (vendor.contains("oracle") ? Vendor.ORACLE : ((vendor = JavaInfo.getSystemProperty("java.vm.name", "unknown").toLowerCase()).contains("openj9") ? Vendor.OPENJ9 : (vendor.contains("ibm") || vendor.contains("j9") ? Vendor.IBM : (vendor.contains("oracle") || vendor.contains("openjdk") ? Vendor.ORACLE : Vendor.UNKNOWN)))));
        String runtimeVersion = JavaInfo.getSystemProperty("java.runtime.version").toLowerCase();
        int sr = 0;
        int srloc = runtimeVersion.indexOf("sr");
        if (srloc > -1 && (srloc += 2) < runtimeVersion.length()) {
            int len = 0;
            while (srloc + len < runtimeVersion.length() && Character.isDigit(runtimeVersion.charAt(srloc + len))) {
                ++len;
            }
            sr = JavaInfo.parseIntSafe(runtimeVersion.substring(srloc, srloc + len));
        }
        this.SERVICE_RELEASE = sr;
        int fp = 0;
        int fploc = runtimeVersion.indexOf("fp");
        if (fploc > -1 && (fploc += 2) < runtimeVersion.length()) {
            int len = 0;
            while (fploc + len < runtimeVersion.length() && Character.isDigit(runtimeVersion.charAt(fploc + len))) {
                ++len;
            }
            fp = JavaInfo.parseIntSafe(runtimeVersion.substring(fploc, fploc + len));
        }
        this.FIXPACK = fp;
    }

    private static final String getSystemProperty(final String propName, final String defaultValue) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){
            static final long serialVersionUID = -711096860540306369L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public String run() {
                return System.getProperty(propName, defaultValue);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class);
            }
        });
    }

    private static final String getSystemProperty(final String propName) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){
            static final long serialVersionUID = 3620127931986235410L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public String run() {
                return System.getProperty(propName);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(2.class);
            }
        });
    }

    private static JavaInfo instance() {
        if (instance == null) {
            instance = new JavaInfo();
        }
        return instance;
    }

    public static int majorVersion() {
        return JavaInfo.instance().MAJOR;
    }

    public static int minorVersion() {
        return JavaInfo.instance().MINOR;
    }

    public static int microVersion() {
        return JavaInfo.instance().MICRO;
    }

    public static Vendor vendor() {
        return JavaInfo.instance().VENDOR;
    }

    public static int serviceRelease() {
        return JavaInfo.instance().SERVICE_RELEASE;
    }

    public static int fixPack() {
        return JavaInfo.instance().FIXPACK;
    }

    private static int parseIntSafe(String str) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException numberFormatException) {
            FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.kernel.service.util.JavaInfo", (String)"162", null, (Object[])new Object[]{str});
            return 0;
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(JavaInfo.class);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    public static final class Vendor
    extends Enum<Vendor> {
        public static final /* enum */ Vendor IBM;
        public static final /* enum */ Vendor OPENJ9;
        public static final /* enum */ Vendor ORACLE;
        public static final /* enum */ Vendor UNKNOWN;
        private static final /* synthetic */ Vendor[] $VALUES;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public static Vendor[] values() {
            return (Vendor[])$VALUES.clone();
        }

        public static Vendor valueOf(String name) {
            return Enum.valueOf(Vendor.class, name);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(Vendor.class);
            IBM = new Vendor();
            OPENJ9 = new Vendor();
            ORACLE = new Vendor();
            UNKNOWN = new Vendor();
            $VALUES = new Vendor[]{IBM, OPENJ9, ORACLE, UNKNOWN};
        }
    }
}

