/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jndi.startup;

import java.lang.reflect.Field;
import java.util.Arrays;
import javax.naming.spi.InitialContextFactory;
import javax.naming.spi.InitialContextFactoryBuilder;
import javax.naming.spi.NamingManager;
import javax.naming.spi.ObjectFactory;
import javax.naming.spi.ObjectFactoryBuilder;
import org.apache.aries.jndi.AugmenterInvokerImpl;
import org.apache.aries.jndi.ContextManagerServiceFactory;
import org.apache.aries.jndi.JREInitialContextFactoryBuilder;
import org.apache.aries.jndi.OSGiInitialContextFactoryBuilder;
import org.apache.aries.jndi.OSGiObjectFactoryBuilder;
import org.apache.aries.jndi.ProviderAdminServiceFactory;
import org.apache.aries.jndi.Utils;
import org.apache.aries.jndi.spi.AugmenterInvoker;
import org.apache.aries.jndi.spi.EnvironmentAugmentation;
import org.apache.aries.jndi.spi.EnvironmentUnaugmentation;
import org.apache.aries.jndi.tracker.ServiceTrackerCustomizers;
import org.apache.aries.jndi.urls.URLObjectFactoryFinder;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.jndi.JNDIContextManager;
import org.osgi.service.jndi.JNDIProviderAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)Activator.class.getName());
    private OSGiInitialContextFactoryBuilder icfBuilder;
    private static InitialContextFactoryBuilder originalICFBuilder;
    private OSGiObjectFactoryBuilder ofBuilder;
    private static ObjectFactoryBuilder originalOFBuilder;
    private static volatile ServiceTracker icfBuilders;
    private static volatile ServiceTracker urlObjectFactoryFinders;
    private static volatile ServiceTracker initialContextFactories;
    private static volatile ServiceTracker objectFactories;
    private static volatile ServiceTracker environmentAugmentors;
    private static volatile ServiceTracker environmentUnaugmentors;

    public void start(BundleContext context) {
        Object builder;
        initialContextFactories = this.initServiceTracker(context, InitialContextFactory.class, ServiceTrackerCustomizers.ICF_CACHE);
        objectFactories = this.initServiceTracker(context, ObjectFactory.class, ServiceTrackerCustomizers.URL_FACTORY_CACHE);
        icfBuilders = this.initServiceTracker(context, InitialContextFactoryBuilder.class, ServiceTrackerCustomizers.LAZY);
        urlObjectFactoryFinders = this.initServiceTracker(context, URLObjectFactoryFinder.class, ServiceTrackerCustomizers.LAZY);
        environmentAugmentors = this.initServiceTracker(context, EnvironmentAugmentation.class, null);
        environmentUnaugmentors = this.initServiceTracker(context, EnvironmentUnaugmentation.class, null);
        try {
            builder = new OSGiInitialContextFactoryBuilder();
            Activator.setField(InitialContextFactoryBuilder.class, builder, true);
            this.icfBuilder = builder;
        }
        catch (IllegalStateException e) {
            LOGGER.info(Utils.MESSAGES.getMessage("unable.to.set.static.ICFB.already.exists", new Object[]{this.getClassName(InitialContextFactoryBuilder.class)}));
            LOGGER.debug(Utils.MESSAGES.getMessage("unable.to.set.static.ICFB.already.exists", new Object[]{this.getClassName(InitialContextFactoryBuilder.class)}), (Throwable)e);
        }
        try {
            builder = new OSGiObjectFactoryBuilder(context);
            Activator.setField(ObjectFactoryBuilder.class, builder, true);
            this.ofBuilder = builder;
        }
        catch (IllegalStateException e) {
            LOGGER.info(Utils.MESSAGES.getMessage("unable.to.set.static.OFB.already.exists", new Object[]{this.getClassName(ObjectFactoryBuilder.class)}));
            LOGGER.debug(Utils.MESSAGES.getMessage("unable.to.set.static.OFB.already.exists", new Object[]{this.getClassName(ObjectFactoryBuilder.class)}), (Throwable)e);
        }
        context.registerService(JNDIProviderAdmin.class.getName(), (Object)new ProviderAdminServiceFactory(context), null);
        context.registerService(InitialContextFactoryBuilder.class.getName(), (Object)new JREInitialContextFactoryBuilder(), null);
        context.registerService(JNDIContextManager.class.getName(), (Object)new ContextManagerServiceFactory(), null);
        context.registerService(AugmenterInvoker.class.getName(), (Object)AugmenterInvokerImpl.getInstance(), null);
    }

    private String getClassName(Class<?> expectedType) {
        try {
            for (Field field : NamingManager.class.getDeclaredFields()) {
                if (!expectedType.equals(field.getType())) continue;
                field.setAccessible(true);
                Object icf = field.get(null);
                return icf.getClass().getName();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "";
    }

    private ServiceTracker initServiceTracker(BundleContext context, Class<?> type, ServiceTrackerCustomizer custom) {
        ServiceTracker t = new ServiceTracker(context, type.getName(), custom);
        t.open();
        return t;
    }

    public void stop(BundleContext context) {
        if (this.icfBuilder != null) {
            Activator.setField(InitialContextFactoryBuilder.class, originalICFBuilder, false);
        }
        if (this.ofBuilder != null) {
            Activator.setField(ObjectFactoryBuilder.class, originalOFBuilder, false);
        }
        icfBuilders.close();
        urlObjectFactoryFinders.close();
        objectFactories.close();
        initialContextFactories.close();
        environmentAugmentors.close();
        environmentUnaugmentors.close();
    }

    private static void setField(Class<?> expectedType, Object value, boolean saveOriginal) throws IllegalStateException {
        try {
            for (Field field : NamingManager.class.getDeclaredFields()) {
                if (!expectedType.equals(field.getType())) continue;
                field.setAccessible(true);
                if (saveOriginal) {
                    if (expectedType.equals(InitialContextFactoryBuilder.class)) {
                        originalICFBuilder = (InitialContextFactoryBuilder)field.get(null);
                    } else {
                        originalOFBuilder = (ObjectFactoryBuilder)field.get(null);
                    }
                }
                field.set(null, value);
            }
        }
        catch (Throwable t) {
            LOGGER.debug("Error setting field.", t);
            throw new IllegalStateException(t);
        }
    }

    public static ServiceReference[] getInitialContextFactoryBuilderServices() {
        ServiceReference[] refs = icfBuilders.getServiceReferences();
        if (refs != null) {
            Arrays.sort(refs, Utils.SERVICE_REFERENCE_COMPARATOR);
            for (int i = 0; i < refs.length; ++i) {
                if (refs[i] != null) continue;
                LOGGER.warn("org.apache.aries.jndi.startup.Activator.getInitialContextFactoryBuilderServices: refs[" + i + "] is null");
            }
        }
        return refs;
    }

    public static ServiceReference[] getInitialContextFactoryServices() {
        ServiceReference[] refs = initialContextFactories.getServiceReferences();
        if (refs != null) {
            Arrays.sort(refs, Utils.SERVICE_REFERENCE_COMPARATOR);
            for (int i = 0; i < refs.length; ++i) {
                if (refs[i] != null) continue;
                LOGGER.warn("org.apache.aries.jndi.startup.Activator.getInitialContextFactoryServices: refs[" + i + "] is null");
            }
        }
        return refs;
    }

    public static ServiceReference[] getURLObectFactoryFinderServices() {
        ServiceReference[] refs = urlObjectFactoryFinders.getServiceReferences();
        if (refs != null) {
            Arrays.sort(refs, Utils.SERVICE_REFERENCE_COMPARATOR);
        }
        return refs;
    }

    public static Object[] getEnvironmentAugmentors() {
        return environmentAugmentors.getServices();
    }

    public static Object[] getEnvironmentUnaugmentors() {
        return environmentUnaugmentors.getServices();
    }
}

