/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jca.internal;

import com.ibm.websphere.config.WSConfigurationHelper;
import com.ibm.websphere.metatype.MetaTypeFactory;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.classloading.ClassProvider;
import com.ibm.ws.container.service.app.deploy.ApplicationInfo;
import com.ibm.ws.container.service.app.deploy.ConnectorModuleInfo;
import com.ibm.ws.container.service.app.deploy.extended.ExtendedModuleInfo;
import com.ibm.ws.container.service.state.StateChangeException;
import com.ibm.ws.dynamic.bundle.BundleFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.jca.internal.ConnectorModuleMetaDataImpl;
import com.ibm.ws.jca.internal.ConnectorModuleMetatype;
import com.ibm.ws.jca.internal.ResourceAdapterMetaData;
import com.ibm.ws.jca.internal.ResourceAdapterService;
import com.ibm.ws.jca.internal.Utils;
import com.ibm.ws.jca.utils.metagen.MetatypeGenerator;
import com.ibm.ws.jca.utils.xml.metatype.Metatype;
import com.ibm.ws.jca.utils.xml.metatype.MetatypeOcd;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.classloading.ApiType;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.startlevel.FrameworkStartLevel;
import org.osgi.framework.wiring.FrameworkWiring;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
class ConnectorModuleMetatypeBundleImpl
implements ConnectorModuleMetatype {
    private static final TraceComponent tc = Tr.register(ConnectorModuleMetatypeBundleImpl.class);
    private static final String BUNDLE_LOCATION_PREFIX = "ConnectorModuleMetatype@";
    private static final String MANIFEST_API_TYPE_VISIBILITY_KEY = "IBM-ApiTypeVisibility";
    private static final String MANIFEST_DEFAULT_CONFIG_KEY = "IBM-Default-Config";
    private final BundleContext bundleContext;
    private final ConnectorModuleInfo cmInfo;
    private final ConnectorModuleMetaDataImpl metadataImpl;
    private final String id;
    private final ConcurrentHashMap<String, String> bootstrapContextFactoryPids;
    private Metatype metatype;
    private String bootstrapContextAlias;
    private String bootstrapContextFactoryPid;
    private Boolean autoStart;
    private List<String> factoryPids;
    private String defaultInstance;
    private String metatypeXML;
    private Bundle metatypeBundle;
    private ServiceRegistration<?> registration;
    private String rarFileName;
    private Collection<URL> urls;
    private static final List<String> DYNAMIC_IMPORT_PACKAGE_LIST = Collections.unmodifiableList(Arrays.asList("*"));
    private static final EnumSet<ApiType> DEFAULT_API_TYPES = EnumSet.of(ApiType.SPEC, ApiType.IBMAPI, ApiType.API, ApiType.STABLE);
    static final long serialVersionUID = -8551008613865166410L;

    public ConnectorModuleMetatypeBundleImpl(BundleContext bundleContext, ConnectorModuleInfo cmInfo, WSConfigurationHelper configurationHelper, ConcurrentHashMap<String, String> bootstrapContextFactoryPids, ConcurrentHashMap<String, CountDownLatch> metatypeRemovedLatches) {
        this.bundleContext = bundleContext;
        this.cmInfo = cmInfo;
        this.metadataImpl = (ConnectorModuleMetaDataImpl)((ExtendedModuleInfo)cmInfo).getMetaData();
        this.id = this.metadataImpl.getIdentifier();
        this.bootstrapContextFactoryPids = bootstrapContextFactoryPids;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void generateMetatype() throws Exception {
        String previousValue;
        boolean trace = TraceComponent.isAnyTracingEnabled();
        ClassLoader raClassLoader = this.cmInfo.getClassLoader();
        this.rarFileName = this.cmInfo.getURI();
        this.urls = this.cmInfo.getContainer().getURLs();
        Map<String, Object> metagenConfig = this.metadataImpl.getMetaGenConfig();
        metagenConfig.put("rar.classloader", raClassLoader);
        MetaTypeFactory mtpService = (MetaTypeFactory)Utils.priv.getService(this.bundleContext, MetaTypeFactory.class);
        this.metatype = MetatypeGenerator.generateMetatype(metagenConfig, (MetaTypeFactory)mtpService);
        this.metatypeXML = this.metatype.toMetatypeString(true);
        List ocds = this.metatype.getOcds();
        this.factoryPids = new ArrayList<String>(ocds.size());
        this.bootstrapContextFactoryPid = null;
        for (MetatypeOcd ocd : ocds) {
            String pid = ocd.getId();
            this.factoryPids.add(pid);
            if (pid.charAt(15) != 'r') continue;
            this.bootstrapContextFactoryPid = pid;
            this.bootstrapContextAlias = ocd.getChildAlias();
        }
        this.autoStart = this.metadataImpl.getAutoStart();
        if (this.autoStart == null) {
            this.autoStart = ocds.size() <= 1;
        }
        if ((previousValue = this.bootstrapContextFactoryPids.putIfAbsent(this.id.toUpperCase(), this.bootstrapContextFactoryPid)) != null) {
            throw new StateChangeException(Tr.formatMessage((TraceComponent)tc, (String)"J2CA8815.duplicate.resource.adapter.id", (Object[])new Object[]{this.id}));
        }
        try {
            this.defaultInstance = this.metadataImpl.getDefaultInstancesXML(this.bootstrapContextAlias);
            if (this.defaultInstance == null) {
                this.defaultInstance = "<server>\n  <" + this.bootstrapContextFactoryPid + "/>\n</server>";
            }
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("[" + this.id + "] defaultInstance " + this.defaultInstance), (Object[])new Object[0]);
            }
        }
        catch (Exception ocd) {
            void x;
            FFDCFilter.processException((Throwable)ocd, (String)"com.ibm.ws.jca.internal.ConnectorModuleMetatypeBundleImpl", (String)"141", (Object)this, (Object[])new Object[0]);
            this.bootstrapContextFactoryPids.remove(this.id.toUpperCase(), this.bootstrapContextFactoryPid);
            throw new StateChangeException((Throwable)x);
        }
    }

    private static String getSymbolicName(String bundleId) {
        return String.format("connector.module.metatype.bundle.ConnectorModule.%s", bundleId);
    }

    private void setStartLevel(Bundle b) {
        FrameworkWiring frameworkWiring = (FrameworkWiring)this.bundleContext.getBundle("System Bundle").adapt(FrameworkWiring.class);
        FrameworkStartLevel fsl = (FrameworkStartLevel)frameworkWiring.getBundle().adapt(FrameworkStartLevel.class);
        BundleStartLevel bsl = (BundleStartLevel)b.adapt(BundleStartLevel.class);
        int currentStartLevel = fsl.getStartLevel();
        int neededStartLevel = bsl.getStartLevel();
        if (neededStartLevel > currentStartLevel) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Changing the start level of bundle {0} from {1} to the current level of {2}", (Object[])new Object[]{b, neededStartLevel, currentStartLevel});
            }
            bsl.setStartLevel(currentStartLevel);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void start(Bundle b) throws BundleException {
        Object resolverException = null;
        for (int i = 0; i < 2; ++i) {
            resolverException = null;
            try {
                b.start();
                return;
            }
            catch (BundleException bundleException) {
                void e;
                FFDCFilter.processException((Throwable)bundleException, (String)"com.ibm.ws.jca.internal.ConnectorModuleMetatypeBundleImpl", (String)"178", (Object)this, (Object[])new Object[]{b});
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"An exception occurred while starting bundle {0}: {1}", (Object[])new Object[]{b, e});
                }
                if (e.getType() != 4) continue;
                resolverException = e;
                continue;
            }
        }
        if (resolverException != null) {
            throw resolverException;
        }
    }

    @Override
    public void registerMetatype() throws Exception {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        ApplicationInfo appInfo = this.cmInfo.getApplicationInfo();
        String appName = appInfo.getName();
        String moduleName = this.cmInfo.getName();
        String defaultConfig = "OSGI-INF/wlp/defaultInstances.xml";
        if (this.bootstrapContextAlias != null && this.metadataImpl.hasConfig()) {
            defaultConfig = defaultConfig + "; requireExisting=true";
        }
        if (trace && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"synthetic bundle info:", (Object[])new Object[]{this.bootstrapContextAlias, this.metadataImpl.hasConfig(), "IBM-Default-Config=" + defaultConfig, this.defaultInstance});
        }
        this.metatypeBundle = new BundleFactory().setBundleName("ConnectorModuleMetatype bundle for " + appName + "-" + moduleName).setBundleSymbolicName(ConnectorModuleMetatypeBundleImpl.getSymbolicName(this.id)).dynamicallyImportPackages(DYNAMIC_IMPORT_PACKAGE_LIST).addManifestAttribute(MANIFEST_API_TYPE_VISIBILITY_KEY, DEFAULT_API_TYPES).addManifestAttribute(MANIFEST_DEFAULT_CONFIG_KEY, Arrays.asList(defaultConfig)).setBundleLocationPrefix(BUNDLE_LOCATION_PREFIX).setBundleLocation("ConnectorModule:" + this.id).setBundleContext(this.bundleContext).setDefaultInstance(this.defaultInstance).setMetatypeXML(this.metatypeXML).createBundle();
        if (trace && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("[" + this.id + "] bundle " + this.metatypeBundle), (Object[])new Object[0]);
        }
        this.setStartLevel(this.metatypeBundle);
        this.start(this.metatypeBundle);
        ResourceAdapterService service = new ResourceAdapterService();
        service.setClassLoader(this.cmInfo.getClassLoader());
        service.setResourceAdapterMetaData((ResourceAdapterMetaData)this.metadataImpl.getComponentMetaDatas()[0]);
        Hashtable<String, Object> dict = new Hashtable<String, Object>();
        dict.put("id", this.id);
        dict.put("rarFileName", this.rarFileName);
        dict.put("urls", this.urls);
        if (this.metadataImpl.resourceAdapterPid != null) {
            dict.put("source.pid", this.metadataImpl.resourceAdapterPid);
        }
        String[] providedClassNames = new String[]{ResourceAdapterService.class.getName(), ClassProvider.class.getName()};
        this.registration = this.bundleContext.registerService(providedClassNames, (Object)service, dict);
    }

    @Override
    @FFDCIgnore(value={IllegalStateException.class})
    public void removeMetatype() throws Exception {
        if (this.registration != null) {
            try {
                this.registration.unregister();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        this.metatypeBundle.uninstall();
        this.bootstrapContextFactoryPids.remove(this.id.toUpperCase());
    }

    @Override
    public String getBootstrapContextFactoryPid() {
        return this.bootstrapContextFactoryPid;
    }

    @Override
    public boolean getAutoStart() {
        return this.autoStart;
    }
}

