/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.context.service.serializable;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.context.service.serializable.ThreadContextDescriptorImpl;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.serialization.DeserializationObjectInputStream;
import com.ibm.wsspi.threadcontext.ThreadContextDeserializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public abstract class ContextualObject<T> {
    static final String CONTEXT = "C";
    static final String EXEC_PROPS = "E";
    static final String INTERNAL_PROP_NAMES = "I";
    static final String OBJECT = "O";
    static final ObjectStreamField[] serialFields;
    private static final GetThreadContextClassLoader getThreadContextClassLoader;
    transient T object;
    private transient Set<String> internalPropNames;
    transient ThreadContextDescriptorImpl threadContextDescriptor;
    static final long serialVersionUID = -3325018751476745545L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    ContextualObject() {
    }

    @Trivial
    ContextualObject(ThreadContextDescriptorImpl threadContextDescriptor, T object, Set<String> internalPropNames) {
        this.object = object;
        this.threadContextDescriptor = threadContextDescriptor;
        this.internalPropNames = internalPropNames;
    }

    @Trivial
    public final Map<String, String> getExecutionProperties() {
        TreeMap<String, String> copy = null;
        if (this.internalPropNames != null) {
            copy = new TreeMap<String, String>(this.threadContextDescriptor.getExecutionProperties());
            for (String name : this.internalPropNames) {
                copy.remove(name);
            }
        }
        return copy;
    }

    @Trivial
    public final ThreadContextDescriptorImpl getThreadContextDescriptor() {
        return this.threadContextDescriptor;
    }

    void read(ObjectInputStream in) throws ClassNotFoundException, IOException {
        ObjectInputStream.GetField fields = in.readFields();
        this.internalPropNames = (Set)fields.get(INTERNAL_PROP_NAMES, null);
        byte[] bytes = (byte[])fields.get(OBJECT, null);
        DeserializationObjectInputStream doin = new DeserializationObjectInputStream((InputStream)new ByteArrayInputStream(bytes), AccessController.doPrivileged(getThreadContextClassLoader));
        this.object = doin.readObject();
        doin.close();
        Map execProps = (Map)fields.get(EXEC_PROPS, null);
        bytes = (byte[])fields.get(CONTEXT, null);
        this.threadContextDescriptor = (ThreadContextDescriptorImpl)ThreadContextDeserializer.deserialize(bytes, execProps);
    }

    void write(ObjectOutputStream out) throws IOException {
        ObjectOutputStream.PutField fields = out.putFields();
        fields.put(CONTEXT, this.threadContextDescriptor.serialize());
        fields.put(EXEC_PROPS, this.threadContextDescriptor.getExecutionProperties());
        fields.put(INTERNAL_PROP_NAMES, this.internalPropNames);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream oout = new ObjectOutputStream(bout);
        oout.writeObject(this.object);
        oout.flush();
        fields.put(OBJECT, bout.toByteArray());
        oout.close();
        out.writeFields();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ContextualObject.class);
        serialFields = new ObjectStreamField[]{new ObjectStreamField(CONTEXT, ThreadContextDescriptorImpl.class), new ObjectStreamField(EXEC_PROPS, Map.class), new ObjectStreamField(INTERNAL_PROP_NAMES, Set.class), new ObjectStreamField(OBJECT, byte[].class)};
        getThreadContextClassLoader = new GetThreadContextClassLoader();
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static final class GetThreadContextClassLoader
    implements PrivilegedAction<ClassLoader> {
        static final long serialVersionUID = 5694404510978877093L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private GetThreadContextClassLoader() {
        }

        @Override
        public ClassLoader run() {
            return Thread.currentThread().getContextClassLoader();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(GetThreadContextClassLoader.class);
        }
    }
}

