/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.audit.event;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.audit.AuditEvent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.audit.utils.AuditUtils;
import java.util.Arrays;
import java.util.Map;
import javax.management.ObjectName;
import javax.management.QueryExp;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class JMXMBeanEvent
extends AuditEvent {
    private static final TraceComponent tc = Tr.register(JMXMBeanEvent.class);
    static final long serialVersionUID = -4021507986132351815L;

    public JMXMBeanEvent() {
        this.set("eventName", "JMX_MBEAN");
        this.setInitiator((Map)AuditEvent.STD_INITIATOR.clone());
        this.setObserver((Map)AuditEvent.STD_OBSERVER.clone());
        this.setTarget((Map)AuditEvent.STD_TARGET.clone());
    }

    /*
     * WARNING - void declaration
     */
    public JMXMBeanEvent(ObjectName name, String className, ObjectName loader, String operationName, Object[] params, String[] signature, QueryExp query, String action, String outcome, String reason) {
        block25: {
            this();
            try {
                StringBuffer buf;
                if (name != null) {
                    this.set("target.jmx.mbean.name", name.toString());
                }
                if (className != null) {
                    this.set("target.jmx.mbean.classname", className);
                }
                if (action != null) {
                    this.set("target.jmx.mbean.action", action);
                }
                if (loader != null) {
                    this.set("target.jmx.mbean.classloader.name", loader.toString());
                }
                if (operationName != null) {
                    this.set("target.jmx.mbean.invoke.operation", operationName);
                }
                this.set("target.realm", AuditUtils.getRealmName());
                if (params != null) {
                    buf = new StringBuffer();
                    for (int i = 0; i < params.length; ++i) {
                        if (params[i] == null) continue;
                        if (params[i].getClass() != null && params[i].getClass().isArray()) {
                            if (params[i] instanceof long[]) {
                                buf.append("[").append(Arrays.toString((long[])params[i])).append("]");
                                continue;
                            }
                            if (params[i] instanceof boolean[]) {
                                buf.append("[").append(Arrays.toString((boolean[])params[i])).append("]");
                                continue;
                            }
                            if (params[i] instanceof byte[]) {
                                buf.append("[").append(Arrays.toString((byte[])params[i])).append("]");
                                continue;
                            }
                            if (params[i] instanceof int[]) {
                                buf.append("[").append(Arrays.toString((int[])params[i])).append("]");
                                continue;
                            }
                            if (params[i] instanceof short[]) {
                                buf.append("[").append(Arrays.toString((short[])params[i])).append("]");
                                continue;
                            }
                            if (params[i] instanceof char[]) {
                                buf.append("[").append(Arrays.toString((char[])params[i])).append("]");
                                continue;
                            }
                            if (params[i] instanceof float[]) {
                                buf.append("[").append(Arrays.toString((float[])params[i])).append("]");
                                continue;
                            }
                            if (params[i] instanceof double[]) {
                                buf.append("[").append(Arrays.toString((double[])params[i])).append("]");
                                continue;
                            }
                            if (!(params[i] instanceof Object[])) continue;
                            buf.append("[").append(this.unravelArray(buf, params[i])).append("]");
                            continue;
                        }
                        buf.append("[").append(params[i]).append("]");
                    }
                    String siggy = buf.toString();
                    if (!siggy.isEmpty()) {
                        this.set("target.jmx.mbean.params", siggy);
                    }
                }
                if (signature != null) {
                    buf = new StringBuffer();
                    for (int i = 0; i < signature.length; ++i) {
                        buf.append("[").append(signature[i]).append("]");
                    }
                    String siggy = buf.toString();
                    if (!siggy.isEmpty()) {
                        this.set("target.jmx.mbean.signature", siggy);
                    }
                }
                if (query != null) {
                    this.set("target.jmx.mbean.queryExp", query.toString());
                }
                this.set("observer.name", "JMXService");
                this.set("target.typeURI", "server/mbean");
                if (outcome.equals("success")) {
                    this.setOutcome("success");
                    this.set("reason.reasonCode", 200);
                    this.set("reason.reasonType", reason);
                } else {
                    this.setOutcome("failure");
                    this.set("reason.reasonCode", 201);
                    this.set("reason.reasonType", reason);
                }
            }
            catch (Exception buf) {
                void e;
                FFDCFilter.processException((Throwable)buf, (String)"com.ibm.ws.security.audit.event.JMXMBeanEvent", (String)"125", (Object)((Object)this), (Object[])new Object[]{name, className, loader, operationName, params, signature, query, action, outcome, reason});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block25;
                Tr.debug((TraceComponent)tc, (String)"Internal error creating JMXMBeanEvent", (Object[])new Object[]{e});
            }
        }
    }

    public StringBuffer unravelArray(StringBuffer buf, Object param) {
        if (param instanceof long[]) {
            buf.append("[").append(Arrays.toString((long[])param)).append("]");
        } else if (param instanceof boolean[]) {
            buf.append("[").append(Arrays.toString((boolean[])param)).append("]");
        } else if (param instanceof int[]) {
            buf.append("[").append(Arrays.toString((int[])param)).append("]");
        } else if (param instanceof byte[]) {
            buf.append("[").append(Arrays.toString((byte[])param)).append("]");
        } else if (param instanceof short[]) {
            buf.append("[").append(Arrays.toString((short[])param)).append("]");
        } else if (param instanceof char[]) {
            buf.append("[").append(Arrays.toString((char[])param)).append("]");
        } else if (param instanceof float[]) {
            buf.append("[").append(Arrays.toString((float[])param)).append("]");
        } else if (param instanceof double[]) {
            buf.append("[").append(Arrays.toString((double[])param)).append("]");
        } else if (param instanceof Object[]) {
            buf.append("[").append(this.unravelArray(buf, param)).append("]");
        }
        return buf;
    }
}

