/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.config.xml.internal;

import com.ibm.websphere.config.ConfigEvaluatorException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.config.xml.internal.ConfigElement;
import com.ibm.ws.config.xml.internal.ConfigEvaluator;
import com.ibm.ws.config.xml.internal.ConfigExpressionEvaluator;
import com.ibm.ws.config.xml.internal.ConfigNotFoundException;
import com.ibm.ws.config.xml.internal.ConfigVariableRegistry;
import com.ibm.ws.config.xml.internal.EvaluationContext;
import com.ibm.ws.config.xml.internal.MetaTypeHelper;
import com.ibm.ws.config.xml.internal.StringUtils;
import com.ibm.ws.config.xml.internal.XMLConfigConstants;
import com.ibm.ws.config.xml.internal.metatype.ExtendedAttributeDefinition;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class VariableEvaluator {
    private final ConfigVariableRegistry variableRegistry;
    private final StringUtils stringUtils = new StringUtils();
    private final ConfigEvaluator configEvaluator;
    static final long serialVersionUID = 3435820265446668882L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public VariableEvaluator(ConfigVariableRegistry variableRegistry, ConfigEvaluator configEvaluator) {
        this.variableRegistry = variableRegistry;
        this.configEvaluator = configEvaluator;
    }

    private String lookupVariableFromRegistry(String variableName) {
        return this.variableRegistry == null ? null : this.variableRegistry.lookupVariable(variableName);
    }

    String resolveVariables(String str, EvaluationContext context, boolean ignoreWarnings) throws ConfigEvaluatorException {
        Matcher matcher = XMLConfigConstants.VAR_PATTERN.matcher(str);
        while (matcher.find()) {
            String var = matcher.group(1);
            String rep = this.getProperty(var, context, ignoreWarnings, true);
            if (rep == null) {
                rep = this.tryEvaluateExpression(var, context, ignoreWarnings);
            }
            if (rep == null) continue;
            context.push(rep);
            rep = this.resolveVariables(rep, context, ignoreWarnings);
            context.pop();
            str = str.replace(matcher.group(0), rep);
            matcher.reset(str);
        }
        return str;
    }

    private String getProperty(String variable, EvaluationContext context, boolean ignoreWarnings, boolean useEnvironment) throws ConfigEvaluatorException {
        return this.stringUtils.convertToString(this.getPropertyObject(variable, context, ignoreWarnings, useEnvironment));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private Object getPropertyObject(String variable, EvaluationContext context, boolean ignoreWarnings, boolean useEnvironment) throws ConfigEvaluatorException {
        Object realValue = null;
        if (context.containsValue(variable)) {
            realValue = context.getValue(variable);
        } else {
            if ("service.pid".equals(variable)) {
                try {
                    realValue = this.configEvaluator.getPid(context.getConfigElement().getConfigID());
                    context.putValue("service.pid", realValue);
                }
                catch (ConfigNotFoundException configNotFoundException) {
                    void ex;
                    FFDCFilter.processException((Throwable)configNotFoundException, (String)"com.ibm.ws.config.xml.internal.VariableEvaluator", (String)"102", (Object)this, (Object[])new Object[]{variable, context, ignoreWarnings, useEnvironment});
                    throw new ConfigEvaluatorException("Could not obtain PID for configID", (Throwable)ex);
                }
            }
            context.push(variable);
            realValue = this.lookupVariableFromRegistry(variable);
            if (realValue == null) {
                Map<String, ExtendedAttributeDefinition> attributeMap;
                realValue = context.getProperties().get(variable);
                if (realValue == null) {
                    ExtendedAttributeDefinition attributeDef = context.getAttributeDefinition(variable);
                    if (attributeDef != null) {
                        String currentAttribute = context.getAttributeName();
                        Set<EvaluationContext.NestedInfo> nestedInfo = context.getNestedInfo();
                        String flatPrefix = "";
                        try {
                            realValue = this.configEvaluator.evaluateMetaTypeAttribute(variable, context, attributeDef, flatPrefix, ignoreWarnings);
                        }
                        finally {
                            context.setAttributeName(currentAttribute);
                            context.setNestedInfo(nestedInfo);
                        }
                    }
                    ConfigElement configElement = context.getConfigElement();
                    Object rawValue = configElement.getAttribute(variable);
                    if (rawValue != null) {
                        String currentAttribute = context.getAttributeName();
                        Set<EvaluationContext.NestedInfo> nestedInfo = context.getNestedInfo();
                        try {
                            realValue = this.configEvaluator.evaluateSimpleAttribute(variable, rawValue, context, "", ignoreWarnings);
                        }
                        finally {
                            context.setAttributeName(currentAttribute);
                            context.setNestedInfo(nestedInfo);
                        }
                    }
                }
                if (realValue == null && (attributeMap = context.getAttributeMap()) != null) {
                    for (Map.Entry<String, ExtendedAttributeDefinition> entry : attributeMap.entrySet()) {
                        if (context.isProcessed(entry.getKey()) || !entry.getValue().isFlat()) continue;
                        try {
                            this.configEvaluator.evaluateMetaTypeAttribute(entry.getKey(), context, entry.getValue(), "", true);
                        }
                        catch (ConfigEvaluatorException configEvaluatorException) {
                            FFDCFilter.processException((Throwable)configEvaluatorException, (String)"com.ibm.ws.config.xml.internal.VariableEvaluator", (String)"160", (Object)this, (Object[])new Object[]{variable, context, ignoreWarnings, useEnvironment});
                        }
                    }
                    realValue = context.getProperties().get(variable);
                }
                if (realValue == null && useEnvironment) {
                    realValue = this.lookupEnvironmentVariable(variable);
                }
                if (realValue == null) {
                    realValue = this.lookupDefaultVariable(variable);
                }
                if (realValue == null) {
                    context.addDefinedVariable(variable, null);
                }
            } else {
                context.addDefinedVariable(variable, realValue);
            }
            context.pop();
            context.putValue(variable, realValue);
        }
        return realValue;
    }

    @FFDCIgnore(value={NumberFormatException.class, ArithmeticException.class, ConfigEvaluatorException.class})
    private String tryEvaluateExpression(String expr, final EvaluationContext context, final boolean ignoreWarnings) {
        try {
            return new ConfigExpressionEvaluator(){
                static final long serialVersionUID = 5710998497829458912L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                String getProperty(String argName) throws ConfigEvaluatorException {
                    return VariableEvaluator.this.getProperty(argName, context, ignoreWarnings, false);
                }

                @Override
                Object getPropertyObject(String argName) throws ConfigEvaluatorException {
                    return VariableEvaluator.this.getPropertyObject(argName, context, ignoreWarnings, false);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class);
                }
            }.evaluateExpression(expr);
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (ArithmeticException arithmeticException) {
        }
        catch (ConfigEvaluatorException configEvaluatorException) {
            // empty catch block
        }
        return null;
    }

    Object processVariableLists(Object rawValue, ExtendedAttributeDefinition attributeDef, EvaluationContext context, boolean ignoreWarnings) throws ConfigEvaluatorException {
        if (attributeDef != null && !attributeDef.resolveVariables()) {
            return rawValue;
        }
        if (rawValue instanceof List) {
            ArrayList<Object> returnList = new ArrayList<Object>();
            List values = rawValue;
            for (Object o : values) {
                Object processed = this.processVariableLists(o, attributeDef, context, ignoreWarnings);
                if (processed instanceof List) {
                    returnList.addAll((List)processed);
                    continue;
                }
                returnList.add(processed);
            }
            return returnList;
        }
        if (rawValue instanceof String) {
            Matcher matcher = XMLConfigConstants.VAR_LIST_PATTERN.matcher((String)((Object)rawValue));
            if (matcher.find()) {
                String var = matcher.group(1);
                String rep = this.getProperty(var, context, ignoreWarnings, true);
                return rep == null ? rawValue : MetaTypeHelper.parseValue(rep);
            }
            return rawValue;
        }
        return rawValue;
    }

    Object lookupVariableExtension(EvaluationContext context, ExtendedAttributeDefinition attrDef) throws ConfigEvaluatorException {
        if (this.variableRegistry == null) {
            return null;
        }
        String variableName = attrDef.getVariable();
        if (variableName != null) {
            ExtendedAttributeDefinition targetAttrDef;
            Object variableValue;
            if (!attrDef.resolveVariables()) {
                return "${" + variableName + "}";
            }
            boolean isList = false;
            if (variableName.startsWith("list(") && variableName.endsWith(")")) {
                variableName = variableName.substring(5, variableName.length() - 1);
                isList = true;
            }
            if ((variableValue = this.variableRegistry.lookupVariable(variableName)) == null && !variableName.equals(attrDef.getID()) && !isList && (targetAttrDef = context.getAttributeDefinition(variableName)) != null) {
                variableValue = this.configEvaluator.evaluateMetaTypeAttribute(variableName, context, targetAttrDef, "", true);
            }
            context.addDefinedVariable(variableName, variableValue);
            if (variableValue == null) {
                return null;
            }
            return isList ? MetaTypeHelper.parseValue((String)variableValue) : variableValue;
        }
        return null;
    }

    private Object lookupEnvironmentVariable(String variableName) {
        if (this.variableRegistry == null) {
            return null;
        }
        String value = null;
        value = this.variableRegistry.lookupVariable("env." + variableName);
        if (value == null) {
            variableName = this.stringUtils.replaceNonAlpha(variableName);
            value = this.variableRegistry.lookupVariable("env." + variableName);
        }
        if (value == null) {
            variableName = variableName.toUpperCase();
            value = this.variableRegistry.lookupVariable("env." + variableName);
        }
        return value;
    }

    private Object lookupDefaultVariable(String variableName) {
        if (this.variableRegistry == null) {
            return null;
        }
        return this.variableRegistry.lookupVariableDefaultValue(variableName);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(VariableEvaluator.class);
    }
}

