/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.config.xml.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.config.xml.internal.ConfigElement;
import com.ibm.ws.config.xml.internal.ConfigurationList;
import com.ibm.ws.config.xml.internal.MetaTypeRegistry;
import com.ibm.ws.config.xml.internal.ServerConfiguration;
import com.ibm.ws.config.xml.internal.SimpleElement;
import com.ibm.ws.config.xml.internal.SystemConfiguration;
import com.ibm.ws.config.xml.internal.metatype.ExtendedAttributeDefinition;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.logging.IntrospectableService;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={IntrospectableService.class}, immediate=true, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class ConfigIntrospection
implements IntrospectableService {
    private static final String NAME = "ConfigIntrospection";
    private static final String DESC = "Introspect internal configuration store";
    private SystemConfiguration systemConfiguration;
    private MetaTypeRegistry metaTypeRegistry;
    static final long serialVersionUID = -1648086078932322837L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Activate
    protected void activate(BundleContext context) {
    }

    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    protected void setSystemConfiguration(SystemConfiguration sc) {
        this.systemConfiguration = sc;
    }

    protected void unsetSystemConfiguration(SystemConfiguration sc) {
        if (sc == this.systemConfiguration) {
            this.systemConfiguration = null;
        }
    }

    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    protected void setMetaTypeRegistry(MetaTypeRegistry mtr) {
        this.metaTypeRegistry = mtr;
    }

    protected void unsetMetaTypeRegistry(MetaTypeRegistry mtr) {
        if (mtr == this.metaTypeRegistry) {
            this.metaTypeRegistry = null;
        }
    }

    public String getName() {
        return NAME;
    }

    public String getDescription() {
        return DESC;
    }

    public void introspect(OutputStream out) throws IOException {
        PrintStream ps = new PrintStream(out);
        ServerConfiguration server = this.systemConfiguration.getServerConfiguration();
        for (String name : server.getConfigurationNames()) {
            ps.println("");
            ps.println("Configuration Element Information for top level PID: " + name);
            MetaTypeRegistry.RegistryEntry re = this.metaTypeRegistry.getRegistryEntry(name);
            ps.println("Has Metatype: " + (re != null));
            ConfigurationList<SimpleElement> cl = server.getConfigurationList(name);
            ConfigurationList<SimpleElement> defaultCl = server.getDefaultConfiguration().getConfigurationList(name);
            List<Object> elements = new ArrayList();
            elements = cl.collectElements(elements);
            elements = defaultCl.collectElements(elements);
            ps.println("Number of Elements: " + elements.size());
            for (SimpleElement simpleElement : elements) {
                ps.println("");
                ps.println("\tSequence Number: " + simpleElement.getSequenceId());
                ps.println("\tOrigin: " + simpleElement.getDocumentLocation());
                ps.println("\tAttributes: " + this.filterMetatypeAttributes(re, simpleElement.getAttributes()));
                ps.println("\tMerge Behavior: " + (Object)((Object)simpleElement.mergeBehavior));
                this.printNestedConfiguration(1, ps, simpleElement);
            }
        }
    }

    private void printNestedElementInformation(int indent, PrintStream ps, ConfigElement element, MetaTypeRegistry.RegistryEntry re) {
        boolean hasMetatype = re != null;
        this.print(indent, ps, "");
        this.print(indent, ps, "PID: " + (hasMetatype ? re.getPid() : element.getNodeDisplayName()));
        this.print(indent, ps, "Has Metatype: " + hasMetatype);
        this.print(indent, ps, "Sequence Number: " + element.getSequenceId());
        this.print(indent, ps, "Attributes: " + this.filterMetatypeAttributes(re, element.getAttributes()));
        this.printNestedConfiguration(indent + 1, ps, element);
    }

    private void print(int indent, PrintStream ps, String text) {
        StringWriter writer = new StringWriter();
        writer.append('\t');
        for (int i = 0; i < indent; ++i) {
            writer.append("   ");
        }
        writer.append(text);
        ps.println(writer.toString());
    }

    private void printNestedConfiguration(int indent, PrintStream ps, ConfigElement element) {
        if (!element.hasNestedElements()) {
            return;
        }
        this.print(indent, ps, "");
        this.print(indent, ps, "Nested Elements for " + element.getNodeDisplayName());
        for (ConfigElement nested : element.getChildren()) {
            MetaTypeRegistry.RegistryEntry re = this.metaTypeRegistry.getRegistryEntry(nested);
            if (re == null) {
                re = this.metaTypeRegistry.getRegistryEntry(nested.getNodeName());
            }
            this.printNestedElementInformation(indent, ps, nested, re);
        }
        this.print(indent, ps, "");
    }

    private Map<String, Object> filterMetatypeAttributes(MetaTypeRegistry.RegistryEntry re, Map<String, Object> attributes) {
        if (re == null) {
            return attributes;
        }
        Map<String, ExtendedAttributeDefinition> attributeMap = re.getObjectClassDefinition().getAttributeMap();
        HashMap<String, Object> retVal = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : attributes.entrySet()) {
            ExtendedAttributeDefinition ad = attributeMap.get(entry.getKey());
            if (this.isPasswordType(ad)) {
                retVal.put(entry.getKey(), "*******");
                continue;
            }
            retVal.put(entry.getKey(), entry.getValue());
        }
        return retVal;
    }

    private boolean isPasswordType(ExtendedAttributeDefinition ad) {
        if (ad == null) {
            return false;
        }
        return ad.getType() == 1003 || ad.getType() == 1008;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ConfigIntrospection.class);
    }
}

