/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.config.featuregen.internal;

import com.ibm.websphere.config.mbeans.FeatureListMBean;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={FeatureListMBean.class}, property={"jmx.objectname=WebSphere:name=com.ibm.websphere.config.mbeans.FeatureListMBean", "service.vendor=IBM"})
public class FeatureListMBeanImpl
extends StandardMBean
implements FeatureListMBean {
    private static final TraceComponent tc = Tr.register(FeatureListMBeanImpl.class);
    public static final String TRACE_BUNDLE_SCHEMA = "com.ibm.ws.config.internal.resources.SchemaData";
    static final String KEY_LOCATION_ADMIN = "locationAdmin";
    private static final AtomicServiceReference<WsLocationAdmin> locationAdminRef = new AtomicServiceReference("locationAdmin");
    private static final String FEAT_LIST_PREFIX = "featureList_";
    private static final String FEAT_LIST_SUFFIX = ".xml";
    static final long serialVersionUID = 5205377492624187580L;

    public FeatureListMBeanImpl() throws NotCompliantMBeanException {
        super(FeatureListMBean.class, false);
    }

    @Activate
    protected void activate(ComponentContext ctxt) throws IOException {
        locationAdminRef.activate(ctxt);
    }

    @Deactivate
    protected void deactivate(ComponentContext ctxt) {
        locationAdminRef.deactivate(ctxt);
    }

    @Reference(name="locationAdmin", service=WsLocationAdmin.class)
    protected void setLocationAdmin(ServiceReference<WsLocationAdmin> ref) {
        locationAdminRef.setReference(ref);
    }

    protected void unsetLocationAdmin(ServiceReference<WsLocationAdmin> ref) {
        locationAdminRef.unsetReference(ref);
    }

    protected WsLocationAdmin getWsLocationAdmin() {
        WsLocationAdmin locationAdmin = (WsLocationAdmin)locationAdminRef.getService();
        if (locationAdmin == null) {
            this.throwMissingServiceError("WsLocationAdmin");
        }
        return locationAdmin;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Map<String, Object> generate(String encoding, String locale, String productExt) {
        HashMap<String, Object> returnMap;
        try {
            File targetDirectory;
            ArrayList<String> commandList = new ArrayList<String>();
            String javaHome = AccessController.doPrivileged(new PrivilegedAction<String>(){
                static final long serialVersionUID = 3906763682676499752L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public String run() {
                    return System.getProperty("java.home");
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class);
                }
            });
            String featureListGenPath = this.getWsLocationAdmin().resolveString("${wlp.install.dir}/bin/tools/ws-featurelist.jar");
            commandList.add(javaHome + "/bin/java");
            commandList.add("-jar");
            commandList.add(featureListGenPath);
            if (encoding != null && !encoding.trim().isEmpty()) {
                commandList.add("--encoding=" + encoding);
            }
            if (locale != null && !locale.trim().isEmpty()) {
                commandList.add("--locale=" + locale);
            }
            if (productExt != null && !productExt.trim().isEmpty()) {
                commandList.add("--productExtension=" + productExt);
            }
            if (!FileUtils.fileExists((File)(targetDirectory = new File(this.getWsLocationAdmin().resolveString("${server.state.dir}/"))))) {
                FileUtils.fileMkDirs((File)targetDirectory);
            }
            File generatedFile = File.createTempFile(FEAT_LIST_PREFIX, FEAT_LIST_SUFFIX, targetDirectory);
            commandList.add(generatedFile.getAbsolutePath());
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                for (String command : commandList) {
                    sb.append(command);
                    sb.append("\n");
                }
                Tr.debug((TraceComponent)tc, (String)("List of commands:\n" + sb.toString()), (Object[])new Object[0]);
            }
            ProcessBuilder builder = new ProcessBuilder(commandList);
            builder.redirectErrorStream(true);
            Process featureListGenProc = builder.start();
            String output = this.getOutput(featureListGenProc);
            int exitVal = featureListGenProc.waitFor();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("ExitVal: " + exitVal), (Object[])new Object[0]);
            }
            if (exitVal != 0) {
                return this.retError(output);
            }
            returnMap = new HashMap<String, Object>();
            returnMap.put("keyFilePath", generatedFile.getAbsolutePath());
            returnMap.put("keySystemOut", output);
            returnMap.put("keyReturnCode", 0);
        }
        catch (IOException commandList) {
            void ioe;
            FFDCFilter.processException((Throwable)commandList, (String)"com.ibm.ws.config.featuregen.internal.FeatureListMBeanImpl", (String)"179", (Object)this, (Object[])new Object[]{encoding, locale, productExt});
            return this.retError(ioe.getMessage());
        }
        catch (InterruptedException ioe) {
            void ie;
            FFDCFilter.processException((Throwable)ioe, (String)"com.ibm.ws.config.featuregen.internal.FeatureListMBeanImpl", (String)"181", (Object)this, (Object[])new Object[]{encoding, locale, productExt});
            return this.retError(ie.getMessage());
        }
        return returnMap;
    }

    private Map<String, Object> retError(String msg) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("keySystemOut", msg);
        resultMap.put("keyReturnCode", 21);
        return resultMap;
    }

    private void throwMissingServiceError(String service) {
        throw new RuntimeException(Tr.formatMessage((TraceComponent)tc, (String)"OSGI_SERVICE_ERROR", (Object[])new Object[]{service}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getOutput(Process joinProc) throws IOException {
        InputStream stream = joinProc.getInputStream();
        char[] buf = new char[512];
        StringBuilder sb = new StringBuilder();
        try (InputStreamReader reader = null;){
            int charsRead;
            reader = new InputStreamReader(stream);
            while ((charsRead = reader.read(buf)) > 0) {
                sb.append(buf, 0, charsRead);
            }
        }
        return sb.toString();
    }
}

